<?php
session_start(); 
require 'conexao.php';

// Debug: verificar dados recebidos
error_log("Dados recebidos na sessão: " . print_r($_SESSION, true));

// Verificar se as variáveis necessárias existem
if (!isset($_SESSION['situacaodef'], $_SESSION['personagemdef'], $_SESSION['soldadosdef'])) {
    die("Dados incompletos na sessão");
}

$situacaodef = $_SESSION['situacaodef'];
$personagemdef = $_SESSION['personagemdef'];
$soldadosdef = $_SESSION['soldadosdef'];

try {
    if ($situacaodef == 'caçando') {
        $nvsaldocarne = $soldadosdef;
        
        // Atualiza a carne do personagem
        $sql = "UPDATE personagens SET carne = :valor WHERE personagem = :personagem";
        $stmt = $pdo->prepare($sql);
        $stmt->bindParam(':valor', $nvsaldocarne, PDO::PARAM_INT);
        $stmt->bindParam(':personagem', $personagemdef, PDO::PARAM_STR);
       
        if ($stmt->execute()) {
            $_SESSION['carne_atualizada'] = true;
            error_log("Carne atualizada para $nvsaldocarne no personagem $personagemdef");
        } else {
            throw new Exception("Erro ao atualizar carne: " . implode(", ", $stmt->errorInfo()));
        }
    } 
    elseif ($situacaodef == 'pegando madeira') {
        $nvsaldomadeira = $soldadosdef;
        
        // Atualiza a madeira do personagem
        $sql = "UPDATE personagens SET madeira = :valor WHERE personagem = :personagem";
        $stmt = $pdo->prepare($sql);
        $stmt->bindParam(':valor', $nvsaldomadeira, PDO::PARAM_INT);
        $stmt->bindParam(':personagem', $personagemdef, PDO::PARAM_STR);
       
        if ($stmt->execute()) {
            $_SESSION['madeira_atualizada'] = true;
            error_log("Madeira atualizada para $nvsaldomadeira no personagem $personagemdef");
        } else {
            throw new Exception("Erro ao atualizar madeira: " . implode(", ", $stmt->errorInfo()));
        }
    }
    
    // Redirecionamento único após todas operações
    header("Location: atacando.php?updated=1");
    exit;

} catch (Exception $e) {
    error_log($e->getMessage());
    $_SESSION['error'] = $e->getMessage();
    header("Location: atacando.php?error=1");
    exit;
}
?>