<?php
session_start();
require '../../conexao.php';

if (!isset($_SESSION['personagem'])) {
    $_SESSION['msg'] = "Nenhum personagem selecionado";
    header("Location: ../../dashboardmed.php");
    exit();
}

// Configura o fuso horário (importante!)
date_default_timezone_set('America/Sao_Paulo'); // Ajuste para seu fuso
$datamovimentacao = date('Y-m-d H:i:s');

try {
    $sql = "UPDATE personagens SET situacao = 'livre', datamovimentacao = :datamovimentacao WHERE id = :personagem_id";
    $stmt = $pdo->prepare($sql);
    
    // CORREÇÃO: Remova o PARAM_INT ou use PARAM_STR
    $stmt->bindParam(':datamovimentacao', $datamovimentacao); // PDO irá detectar automaticamente
    $stmt->bindParam(':personagem_id', $_SESSION['personagem'], PDO::PARAM_INT);
    
    // DEBUG: Verifique os valores antes de executar
    error_log("Data a ser inserida: " . $datamovimentacao);
    error_log("ID do personagem: " . $_SESSION['personagem']);
    
    if ($stmt->execute()) {
        $_SESSION['msg'] = "Situação do personagem atualizada para livre";
        
        // DEBUG: Verifique quantas linhas foram afetadas
        error_log("Linhas afetadas: " . $stmt->rowCount());
    } else {
        $_SESSION['msg'] = "Erro ao atualizar a situação do personagem";
        
        // DEBUG: Capture informações de erro
        $errorInfo = $stmt->errorInfo();
        error_log("Erro PDO: " . print_r($errorInfo, true));
    }
    
} catch (PDOException $e) {
    $_SESSION['msg'] = "Erro no banco de dados: " . $e->getMessage();
    error_log("PDOException: " . $e->getMessage());
}

// DEBUG: Verifique a mensagem antes de redirecionar
error_log("Mensagem da sessão: " . $_SESSION['msg']);
header("Location: ../../dashboardmed.php");
exit();
?>