<?php
// api_vendas.php
require '../conexao.php';
require '../config_seguranca.php'; // ADICIONADO

if (!isset($_SESSION['user_id'])) { exit; }

$user_name = $_SESSION['user_name'];

// --- FILTROS E PAGINAÇÃO ---
$filtro_ordem = $_GET['ordem'] ?? 'valor_asc';
$filtro_dono = $_GET['dono'] ?? 'todos';
$paginaAtual = isset($_GET['pagina']) ? max(1, intval($_GET['pagina'])) : 1;
$itensPorPagina = 20;

$where_sql = "WHERE 1=1";
$params = [];

if ($filtro_dono == 'ocultar_meus') {
    $where_sql .= " AND jogador != :eu";
    $params[':eu'] = $user_name;
} elseif ($filtro_dono == 'somente_meus') {
    $where_sql .= " AND jogador = :eu";
    $params[':eu'] = $user_name;
}

$order_sql = "ORDER BY ";
// Whitelist de ordenação para evitar SQL Injection no ORDER BY
switch ($filtro_ordem) {
    case 'valor_desc': $order_sql .= "valor DESC"; break;
    case 'data_asc':   $order_sql .= "dataehora ASC"; break;
    case 'data_desc':  $order_sql .= "dataehora DESC"; break;
    case 'valor_asc': 
    default:           $order_sql .= "valor ASC"; break;
}

// Contagem
$stmtCount = $pdo->prepare("SELECT COUNT(*) FROM ordem_vendas $where_sql");
$stmtCount->execute($params);
$totalItens = $stmtCount->fetchColumn();
$totalPaginas = ceil($totalItens / $itensPorPagina);
$offset = ($paginaAtual - 1) * $itensPorPagina;

// Busca
$sql = "SELECT * FROM ordem_vendas $where_sql $order_sql LIMIT :offset, :limit";
$stmt = $pdo->prepare($sql);
foreach ($params as $key => $val) { $stmt->bindValue($key, $val); }
$stmt->bindValue(':offset', $offset, PDO::PARAM_INT);
$stmt->bindValue(':limit', $itensPorPagina, PDO::PARAM_INT);
$stmt->execute();
$lista_vendas = $stmt->fetchAll(PDO::FETCH_ASSOC);

// --- GERAÇÃO DA TABELA HTML ---
if (count($lista_vendas) > 0) {
    echo '<div class="table-container">
            <table>
                <thead>
                    <tr>
                        <th>Personagem</th>
                        <th>Valor (R$)</th>
                        <th>Data Publicação</th>
                        <th>Ação</th>
                    </tr>
                </thead>
                <tbody>';
    
    foreach ($lista_vendas as $row) {
        $isMine = ($row['jogador'] == $user_name);
        
        echo '<tr>';
        // HTMLSPECIALCHARS É CRUCIAL AQUI (Você já tinha, mantive)
        echo '<td><span class="char-name">' . htmlspecialchars($row['personagem']) . '</span></td>';
        echo '<td><span class="price-tag">R$ ' . number_format($row['valor'], 2, ',', '.') . '</span></td>';
        echo '<td><span class="date-tag">' . date('d/m H:i', strtotime($row['dataehora'])) . '</span></td>';
        echo '<td>';
        
        // MANTIVE OS LINKS (GET), POIS SEUS ARQUIVOS DE DESTINO AGORA VÃO EXIGIR 
        // UMA CONFIRMAÇÃO VIA POST NA PRÓXIMA TELA.
        if ($isMine) {
            // Link para tela de confirmação de exclusão
            echo '<a href="apagarordemdv.php?id=' . $row['id'] . '">
                    <button class="btn-table btn-cancel">
                        <i class="fas fa-trash"></i> Cancelar
                    </button>
                  </a>';
        } else {
            // Link para tela de confirmação de compra
            echo '<a href="comprandopersonagem.php?id=' . $row['id'] . '">
                    <button class="btn-table btn-buy">
                        <i class="fas fa-shopping-cart"></i> Comprar
                    </button>
                  </a>';
        }
        
        echo '</td></tr>';
    }
    
    echo '</tbody></table></div>';
    
    // --- PAGINAÇÃO OTIMIZADA PARA AJAX ---
    echo '<div id="paginacao-data" data-total="' . $totalPaginas . '" data-atual="' . $paginaAtual . '" style="display:none;"></div>';

} else {
    echo '<div style="text-align:center; padding:50px; color:#aaa; font-style:italic; background:rgba(0,0,0,0.6); border:1px dashed #555; border-radius:10px;">
            <i class="fas fa-ghost fa-2x"></i><br><br>
            Nenhum personagem encontrado.
          </div>';
}
?>