<?php
session_start();

// Ajuste o caminho conforme sua estrutura de pastas
require '../../conexao.php'; // ou o caminho correto

// Verifique se o usuário não está logado
if (!isset($_SESSION['user_id'])) {
    header("Location: ../../login.php");
    exit;
}

// Verifica se o personagem está definido na sessão
if (!isset($_SESSION['personagem'])) {
    $_SESSION['msg'] = "Personagem não selecionado.";
    header("Location: ../../dashboardmed.php");
    exit;
}

// CORREÇÃO: O nome do campo deve ser 'dominarcity' (igual no formulário)
if (isset($_POST['dominarcity'])) {
    $local = $_POST['local']; // Local a ser pesquisado
        $trabalhando = "Dominando cidade";
    $personagem = $_SESSION['personagem'];
    $tempotrabalho = date('Y-m-d H:i:s', strtotime('+2 minutes'));

// xxxxxxxxxxxxxxxxxxxxxxxxxx     xxxxxxxxxxxxxxxxxxxx
// verificar se o personagem pertence a um clã e tem cargo maior que 2
$cla = $_SESSION['cla'];
$cargo = $_SESSION['cargo'];
if ($cla === '') {
        $_SESSION['msg'] = "Seu personagem não pertence a clã nenhum para tentar dominar uma cidade";
        header("Location: ../../dashboardmed.php");
        exit;
    }

    // CORREÇÃO: Verificar cargo
    if ($cargo < 3) {
        $_SESSION['msg'] = "Seu cargo não lhe permite atacar/ dominar territórios.";
        header("Location: ../../dashboardmed.php");
        exit;
    }

// xxxxxxxxxxxxxxxxxxxxxxxxxx     xxxxxxxxxxxxxxxxxxxx
// pARALISAR PERSONAGEM
/*
    try {
        // Atualize a coluna 'local' na tabela 'personagens' para o novo valor
        $sql = "UPDATE personagens SET situacao = :trabalhando, paralisado = :tempotrabalho WHERE id = :personagem";
        $stmt = $pdo->prepare($sql);
        
        $stmt->bindParam(':trabalhando', $trabalhando, PDO::PARAM_STR);
        $stmt->bindParam(':tempotrabalho', $tempotrabalho, PDO::PARAM_STR);
        $stmt->bindParam(':personagem', $personagem, PDO::PARAM_STR);
        
        if ($stmt->execute()) {
            $_SESSION['msg'] = "Personagem começou a dominar a cidade!";
            header("Location: ../../dashboardmed.php");
            exit;
            
        } else {
            $_SESSION['msg'] = "Erro ao iniciar domínio.";
            header("Location: ../../dashboardmed.php");
            exit;
        }
        
        */
        
    } catch (PDOException $e) {
        // Log do erro (em produção, não mostre detalhes ao usuário)
        error_log("Erro ao dominar cidade: " . $e->getMessage());
        $_SESSION['msg'] = "Erro interno do sistema.";
        header("Location: ../../dashboardmed.php");
        exit;
    }
} else {
    // Se não veio pelo formulário correto
    $_SESSION['msg'] = "Ação inválida.";
    header("Location: ../../dashboardmed.php");
    exit;
}

?>