<?php
session_start();

// Conexão
if (file_exists('../../conexao.php')) {
    require '../../conexao.php';
} else {
    require '../conexao.php';
}

// DEBUG ATIVO
ini_set('display_errors', 1);
error_reporting(E_ALL);

// 1. SEGURANÇA
if (!isset($_SESSION['user_id']) || empty($_SESSION['personagem'])) {
    header("Location: ../login.php");
    exit();
}

$nomePersonagem = $_SESSION['personagem_nome'];
$local_alvo = $_SESSION['local']; 

// 2. DADOS DO ATACANTE
$stmtP = $pdo->prepare("SELECT id, cla FROM personagens WHERE personagem = :nome LIMIT 1");
$stmtP->execute([':nome' => $nomePersonagem]);
$user_data = $stmtP->fetch(PDO::FETCH_ASSOC);

if (!$user_data || empty($user_data['cla']) || $user_data['cla'] === 'Nenhum') {
    $_SESSION['msg'] = "Você precisa de um Clã para dominar territórios.";
    header("Location: ../../dashboardmed.php");
    exit();
}

$cla_atacante = $user_data['cla'];
$id_atacante = $user_data['id'];

try {
    $pdo->beginTransaction();

    // 3. BUSCA DADOS ATUAIS DO LOCAL (Antes de mudar)
    // Precisamos disso para o Log do infossistema  (Saber quem perdeu)
    $stmtMap = $pdo->prepare("SELECT dominio, governante FROM mapasmed WHERE nome = :local LIMIT 1");
    $stmtMap->execute([':local' => $local_alvo]);
    $dados_mapa = $stmtMap->fetch(PDO::FETCH_ASSOC);

    if (!$dados_mapa) {
        throw new Exception("Local '$local_alvo' não encontrado.");
    }

    $cla_antigo = $dados_mapa['dominio'];
    $gov_antigo = $dados_mapa['governante'];

    // 4. VERIFICAR SE EXISTE DEFENSORES (Exceto o próprio atacante, caso bug)
    if ($cla_antigo !== 'Nenhum' && $cla_antigo !== $cla_atacante) {
        $stmtDefesa = $pdo->prepare("SELECT personagem FROM personagens 
                                     WHERE cla = :cla_def 
                                     AND local = :local 
                                     AND situacao != 'escondido' 
                                     AND personagem != :atacante
                                     LIMIT 1");
        $stmtDefesa->execute([
            ':cla_def' => $cla_antigo, 
            ':local' => $local_alvo,
            ':atacante' => $nomePersonagem
        ]);

        if ($stmtDefesa->rowCount() > 0) {
            $defensor = $stmtDefesa->fetch(PDO::FETCH_ASSOC);
            $_SESSION['msg'] = "DOMÍNIO FALHOU! O defensor {$defensor['personagem']} ainda está no local. Expulse-o!";
            $pdo->rollBack();
            header("Location: ../../dashboardmed.php");
            exit();
        }
    }

   
    $id_guerra = $guerra['id'];
    $data_inicio = $guerra['iniciou'];
    $data_fim = date('Y-m-d H:i:s'); // Agora

    // ==========================================================
    // 6. ATUALIZAÇÕES (CONQUISTA)
    // ==========================================================

    // A. Atualiza Mapa
    $stmtMapUp = $pdo->prepare("UPDATE mapasmed SET dominio = :novo_cla, governante = :novo_gov WHERE nome = :local");
    $stmtMapUp->execute([
        ':novo_cla' => $cla_atacante,
        ':novo_gov' => $nomePersonagem,
        ':local' => $local_alvo
    ]);

    // B. Atualiza Guerra (Vitória)
    $stmtGuerraUp = $pdo->prepare("UPDATE guerra_dominio SET dominou = 1 WHERE id = :id_guerra");
    $stmtGuerraUp->execute([':id_guerra' => $id_guerra]);

    // C. Libera Personagem e Atualiza Reputação (+1)
    $stmtAtacanteUp = $pdo->prepare("UPDATE personagens SET situacao = 'livre', reputacao = reputacao + 1 WHERE id = :id");
    $stmtAtacanteUp->execute([':id' => $id_atacante]);

    // D. Penaliza Antigo Governante (-0.5)
    if ($gov_antigo && $gov_antigo !== 'Ninguém' && $gov_antigo !== $nomePersonagem) {
        // Busca ID do antigo governante pelo nome
        $stmtOldGov = $pdo->prepare("SELECT id FROM personagens WHERE personagem = :nome LIMIT 1");
        $stmtOldGov->execute([':nome' => $gov_antigo]);
        $id_old_gov = $stmtOldGov->fetchColumn();

        if ($id_old_gov) {
            $stmtPunish = $pdo->prepare("UPDATE personagens SET reputacao = reputacao - 0.5 WHERE id = :id");
            $stmtPunish->execute([':id' => $id_old_gov]);
        }
    }

    // E. infossistema  (Log Completo)
    // Formata as datas para ficar bonito
    $inicio_fmt = date('d/m H:i', strtotime($data_inicio));
    $fim_fmt = date('d/m H:i', strtotime($data_fim));

    $assunto = "Conquista de Território";
    $mensagem = "O personagem $nomePersonagem dominou $local_alvo (Antigo gov: $gov_antigo do clã $cla_antigo). Iniciou o dominio às $inicio_fmt e conquistou às $fim_fmt.";

    // Se sua coluna de texto chama 'info' ou 'mensagem', ajuste aqui. Estou usando 'mensagem'.
    $stmtInfo = $pdo->prepare("INSERT INTO infossistema  (assunto, informacao, dataehora) VALUES (:assunto, :msg, NOW())");
    $stmtInfo->execute([
        ':assunto' => $assunto,
        ':msg' => $mensagem
    ]);

    $pdo->commit();

    $_SESSION['msg'] = "VITÓRIA! Você conquistou a $local_alvo, este tirrotório agora pertence ao clã $cla_atacante! Seus soldados vibram! Parabéns!";
    header("Location: ../../dashboardmed.php");
    exit();

} catch (Exception $e) {
    if ($pdo->inTransaction()) {
        $pdo->rollBack();
    }
    $_SESSION['msg'] = "Erro Crítico: " . $e->getMessage();
    header("Location: ../../dashboardmed.php");
    exit();
}
?>