<?php
session_start();
// Ajuste o caminho para voltar à raiz onde está conexao.php
require '../conexao.php'; 

// ATIVAR DEBUG (remover em produção)
ini_set('display_errors', 1);
error_reporting(E_ALL);

// 1. DADOS INICIAIS E SEGURANÇA
if (!isset($_SESSION['user_id']) || empty($_SESSION['personagem'])) {
    header("Location: ../login.php");
    exit();
}

$nomePersonagem = $_SESSION['personagem_nome'];
$local_alvo = $_SESSION['local']; 

// Busca dados do personagem (atacante)
$stmtP = $pdo->prepare("SELECT id, cla, cargo FROM personagens WHERE personagem = :nome LIMIT 1");
$stmtP->execute([':nome' => $nomePersonagem]);
$user_data = $stmtP->fetch(PDO::FETCH_ASSOC);

if (!$user_data || empty($user_data['cla']) || $user_data['cla'] === 'Nenhum') {
    $_SESSION['msg'] = "Você precisa ter um Clã para dominar cidades.";
    header("Location: ../dashboardmed.php");
    exit();
}

$cla_atacante = $user_data['cla'];
$cargo_atacante = (int)$user_data['cargo'];
$id_atacante = $user_data['id'];

try {



    // 2. CONSULTAR DOMÍNIO DO LOCAL (Tabela mapasmed)
    // Busca as colunas 'dominio' e 'governante'
    $stmtMap = $pdo->prepare("SELECT dominio, governante FROM mapasmed WHERE nome = :local LIMIT 1");
    $stmtMap->execute([':local' => $local_alvo]);
    $dados_mapa = $stmtMap->fetch(PDO::FETCH_ASSOC);

    if (!$dados_mapa) {
        $_SESSION['msg'] = "Local não encontrado no sistema.";
        header("Location: ../dashboardmed.php");
        exit();
    }
 



    // Define variáveis (Fallback para evitar erro de índice indefinido)
    $cla_dominante_atual = !empty($dados_mapa['dominio']) ? $dados_mapa['dominio'] : 'Nenhum';
    $governante_atual = !empty($dados_mapa['governante']) ? $dados_mapa['governante'] : 'Ninguém';




    // --- IMPLEMENTAÇÃO DO IMPEDIMENTO: NÃO ATACAR trs do PRÓPRIO CLÃ ---
    if ($cla_atacante == $cla_dominante_atual) {
        $_SESSION['msg'] = "Seu Clã já domina o local alvo ($local_alvo). Você não pode atacá-lo.";
        header("Location: ../dashboardmed.php");
        exit();
    }
    




    // 3. VERIFICAR PRESENÇA DO Clã DOMINANTE (Defesa Ativa)
    if ($cla_dominante_atual !== 'Nenhum') {
        $stmtDefesa = $pdo->prepare("SELECT id FROM personagens WHERE cla = :cla_dom AND local = :local AND situacao != 'escondido' LIMIT 1");
        $stmtDefesa->execute([':cla_dom' => $cla_dominante_atual, ':local' => $local_alvo]);

        if ($stmtDefesa->rowCount() > 0) {
            $_SESSION['msg'] = "Para iniciar a tomada de território, você deve atacar e expulsar todos os membros do Clã dominante presente.";
            header("Location: ../dashboardmed.php");
            exit();
        }
    }
    
    
    
   

 // ==========================================================
    // 3. VERIFICAÇÃO DE DEFENSORES (Clã DOMINANTE)
    // ==========================================================
    
    // Regra: Se houver membro do Clã que é DONO da cidade no local (ativo), você não pode iniciar domínio.
    if ($cla_dominante_atual !== 'Nenhum') {
        $stmtDefesa = $pdo->prepare("SELECT personagem FROM personagens 
                                     WHERE cla = :cla_dom 
                                     AND local = :local 
                                     AND situacao != 'escondido' 
                                     LIMIT 1");
        $stmtDefesa->execute([':cla_dom' => $cla_dominante_atual, ':local' => $local_alvo]);
        
        if ($stmtDefesa->rowCount() > 0) {
            $defensor = $stmtDefesa->fetch(PDO::FETCH_ASSOC);
            $_SESSION['msg'] = "O local está protegido! O defensor {$defensor['personagem']} (Clã Dominante) está ativo. Elimine-o primeiro.";
            header("Location: ../dashboardmed.php");
            exit();
        }
    }

    // ==========================================================
    // 4. VERIFICAÇÃO DE INVASORES RIVAIS
    // ==========================================================
    
    // Busca se existe alguma campanha de guerra ativa iniciada nos últimos 7 minutos
    $stmtInvasao = $pdo->prepare("SELECT cla FROM guerra_dominio 
                                  WHERE local = :local 
                                  AND dominou = 0 
                                  AND (defensor IS NULL OR defensor = '') 
                                  AND iniciou > DATE_SUB(NOW(), INTERVAL 7 MINUTE) 
                                  ORDER BY iniciou DESC 
                                  LIMIT 1");
    $stmtInvasao->execute([':local' => $local_alvo]);
    $dados_invasao = $stmtInvasao->fetch(PDO::FETCH_ASSOC);

    if ($dados_invasao) {
        $nomeclainvasor = $dados_invasao['cla'];
        
        // Se o Clã invasor for DIFERENTE do seu, verificamos se eles ainda estão lá
        if ($nomeclainvasor !== $cla_atacante) {
            
            // Verifica se tem alguém desse Clã rival fisicamente no local
            $stmtRivalPresente = $pdo->prepare("SELECT personagem FROM personagens 
                                                WHERE cla = :cla_rival 
                                                AND local = :local 
                                                AND situacao != 'escondido' 
                                                LIMIT 1");
            $stmtRivalPresente->execute([':cla_rival' => $nomeclainvasor, ':local' => $local_alvo]);
            
            if ($stmtRivalPresente->rowCount() > 0) {
                // Tem registro de guerra E tem gente lá -> BLOQUEIA
                $rival = $stmtRivalPresente->fetch(PDO::FETCH_ASSOC);
                $_SESSION['msg'] = "Este local está sob cerco do Clã $nomeclainvasor e há membros deles mantendo a posição. Expulse-os para assumir a invasão.";
                header("Location: ../dashboardmed.php");
                exit();
            }
            // Se não tiver ninguém lá, o código segue e permite você assumir a invasão.
        }
        // Se $nomeclainvasor === $cla_atacante, o código segue e permite o ataque conjunto.
    }
    // 5. VERIFICAÇÕES FINAIS (Clã diferente e Cargo > 1)
    if ($cla_atacante == $cla_dominante_atual) {
        $_SESSION['msg'] = "Seu Clã já domina este local.";
        header("Location: ../dashboardmed.php");
        exit();
    }

    if ($cargo_atacante <= 1) {
        $_SESSION['msg'] = "Seu cargo é muito baixo para iniciar uma invasão.";
        header("Location: ../dashboardmed.php");
        exit();
    }

    // 6. INICIAR DOMÍNIO
    $pdo->beginTransaction();

    // Inserir na tabela guerra_dominio (dominou e defensor ficam padrão/null)
    $sqlInsert = "INSERT INTO guerra_dominio (atacante, cargo, cla, local, cladominante, governante, iniciou, dominou, defensor) 
                  VALUES (:atacante, :cargo, :cla, :local, :cladominante, :governante, NOW(), 0, NULL)";
    $stmtInsert = $pdo->prepare($sqlInsert);
    $stmtInsert->execute([
        ':atacante' => $nomePersonagem,
        ':cargo' => $cargo_atacante,
        ':cla' => $cla_atacante,
        ':local' => $local_alvo,
        ':cladominante' => $cla_dominante_atual,
        ':governante' => $governante_atual
    ]);

    // Atualizar tabela personagens (Situacao e Tempo)
    $sqlUpdate = "UPDATE personagens SET situacao = 'Invadindo cidade', paralisado = DATE_ADD(NOW(), INTERVAL 5 MINUTE) WHERE id = :id";
    $stmtUpdate = $pdo->prepare($sqlUpdate);
    $stmtUpdate->execute([':id' => $id_atacante]);

    $pdo->commit();
    
    $_SESSION['msg'] = "Você iniciou a invasão de $local_alvo! Aguarde 5 minutos.";
    header("Location: ../dashboardmed.php");
    exit();

} catch (Exception $e) {
    if ($pdo->inTransaction()) {
        $pdo->rollBack();
    }
    // Mostra erro na tela se falhar
    $_SESSION['msg'] = "Erro no Banco de Dados: " . $e->getMessage();
    header("Location: ../dashboardmed.php");
    exit();
}
?>