<?php
session_start();
require '../conexao.php';

ini_set('display_errors', 1);
ini_set('display_startup_errors', 1);
error_reporting(E_ALL);

if (!isset($_SESSION['user_id'])) {
    header("Location: ../login.php");
    exit();
}

$jogador_atual = $_SESSION['user_name'];
$user_id = $_SESSION['user_id'];

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $jogador_destino = trim($_POST['jogador_destino']);
    $quantidade = (int)$_POST['quantidade'];
    $pin = $_POST['pin'];
    
    if (empty($jogador_destino) || $quantidade <= 0 || empty($pin)) {
        $_SESSION['msg'] = "Preencha todos os campos corretamente!";
        header("Location: transferir_fichas.php");
        exit();
    }

    if (!password_verify($pin, $_SESSION['user_pin'])) {
        $_SESSION['msg'] = "PIN incorreto!";
        header("Location: transferir_fichas.php");
        exit();
    }

    try {
        $stmt = $pdo->prepare("SELECT user FROM usersblock WHERE user = ?");
        $stmt->execute([$jogador_destino]);
        if ($stmt->rowCount() === 0) {
            $_SESSION['msg'] = "Jogador destino não encontrado!";
            header("Location: transferir_fichas.php");
            exit();
        }
    } catch (PDOException $e) {
        $_SESSION['msg'] = "Erro ao verificar jogador: " . $e->getMessage();
        header("Location: transferir_fichas.php");
        exit();
    }

    try {
        $pdo->beginTransaction();

        $stmt = $pdo->prepare("SELECT COUNT(*) FROM fichaspersonagens WHERE jogador = ? AND situacao = '1'");
        $stmt->execute([$jogador_atual]);
        $fichas_disponiveis = $stmt->fetchColumn();

        if ($fichas_disponiveis < $quantidade) {
            $pdo->rollBack();
            $_SESSION['msg'] = "Você só tem $fichas_disponiveis fichas disponíveis!";
            header("Location: transferir_fichas.php");
            exit();
        }

        // Usa diretamente o valor de $quantidade no SQL
        $limite = intval($quantidade);
        $sql_transferencia = "UPDATE fichaspersonagens 
                              SET jogador = ? 
                              WHERE jogador = ? AND situacao = '1' 
                              LIMIT $limite";
        $stmt = $pdo->prepare($sql_transferencia);
        $stmt->execute([$jogador_destino, $jogador_atual]);

        $stmt = $pdo->query("SELECT MAX(chave) FROM transferencias");
        $ultima_chave = $stmt->fetchColumn();
        $nova_chave = $ultima_chave ? $ultima_chave + 1 : 1;

        $stmt = $pdo->prepare("SELECT COUNT(*) FROM transferencias WHERE chave = ?");
        $stmt->execute([$nova_chave]);
        if ($stmt->fetchColumn() > 0) {
            $nova_chave = $pdo->query("SELECT MAX(chave)+1 FROM transferencias")->fetchColumn();
        }

        $info_transferencia = "$quantidade fichas transferidas";

        $sql_insert = "INSERT INTO transferencias 
                      (tipo, transferiu, recebeu, informacoes, chave, val) 
                      VALUES 
                      ('ficha', ?, ?, ?, ?, 1)";
        $stmt = $pdo->prepare($sql_insert);
        $stmt->execute([$jogador_atual, $jogador_destino, $info_transferencia, $nova_chave]);

        $info_sistema = "O usuário $jogador_atual transferiu $quantidade fichas para o jogador $jogador_destino";
        $sql_info = "INSERT INTO infossistema (informacao, p1, p2, origem, dataehora) 
                    VALUES (?, ?, ?, 'transferencia ficha', NOW())";
        $stmt = $pdo->prepare($sql_info);
        $stmt->execute([$info_sistema, $jogador_atual, $jogador_destino]);

        $pdo->commit();

        $_SESSION['msg'] = "Transferência de $quantidade fichas para $jogador_destino realizada com sucesso!";
        header("Location: transferir_fichas.php");
        exit();

    } catch (PDOException $e) {
        $pdo->rollBack();
        $_SESSION['msg'] = "Erro na transferência: " . $e->getMessage();
        header("Location: transferir_fichas.php");
        exit();
    }
}

try {
    $stmt = $pdo->prepare("SELECT COUNT(*) FROM fichaspersonagens WHERE jogador = ? AND situacao = '1'");
    $stmt->execute([$jogador_atual]);
    $total_fichas = $stmt->fetchColumn();
} catch (PDOException $e) {
    $total_fichas = 0;
    $_SESSION['msg'] = "Erro ao consultar fichas: " . $e->getMessage();
}
?>


<!DOCTYPE html>
<html lang="pt-BR">
<head>
    <meta charset="UTF-8">
    <title>Transferência de Fichas - Reino Medieval</title>
    <link rel="preconnect" href="https://fonts.googleapis.com">
    <link rel="preconnect" href="https://fonts.gstatic.com" crossorigin>
    <link href="https://fonts.googleapis.com/css2?family=MedievalSharp&family=Cinzel+Decorative&display=swap" rel="stylesheet">
    <style>
        :root {
            --primary-color: #8B4513;
            --secondary-color: #5D2906;
            --accent-color: #D4A76A;
            --text-color: #F5DEB3;
            --dark-bg: #1A120B;
            --light-bg: #3E2723;
            --danger-color: #8B0000;
        }
        
        body {
            font-family: 'MedievalSharp', cursive;
            background-color: var(--dark-bg);
            color: var(--text-color);
            background-image: url('https://images.unsplash.com/photo-1605106702734-205df224ecce?ixlib=rb-4.0.3&ixid=M3wxMjA3fDB8MHxwaG90by1wYWdlfHx8fGVufDB8fHx8fA%3D%3D&auto=format&fit=crop&w=1470&q=80');
            background-size: cover;
            background-attachment: fixed;
            margin: 0;
            padding: 20px;
        }
        
        .container {
            max-width: 800px;
            margin: 30px auto;
            background-color: rgba(26, 18, 11, 0.9);
            border: 3px solid var(--primary-color);
            border-radius: 10px;
            padding: 30px;
            box-shadow: 0 0 20px rgba(0, 0, 0, 0.7);
        }
        
        .titulo {
            font-family: 'Cinzel Decorative', cursive;
            font-size: 2.5rem;
            color: var(--accent-color);
            text-align: center;
            margin-bottom: 30px;
            text-shadow: 2px 2px 4px #000;
            letter-spacing: 2px;
        }
        
        .transfer-form {
            display: grid;
            grid-template-columns: 1fr 1fr;
            gap: 20px;
        }
        
        .form-group {
            margin-bottom: 20px;
        }
        
        .form-group.full-width {
            grid-column: span 2;
        }
        
        label {
            display: block;
            margin-bottom: 8px;
            font-size: 1.1rem;
            color: var(--accent-color);
        }
        
        input, select {
            width: 100%;
            padding: 12px;
            background-color: rgba(245, 222, 179, 0.1);
            border: 2px solid var(--primary-color);
            border-radius: 5px;
            color: var(--text-color);
            font-family: 'MedievalSharp', cursive;
            font-size: 1rem;
        }
        
        input:focus, select:focus {
            outline: none;
            border-color: var(--accent-color);
            box-shadow: 0 0 10px rgba(212, 167, 106, 0.5);
        }
        
        .btn {
            background-color: var(--primary-color);
            color: var(--text-color);
            border: none;
            padding: 14px 28px;
            border-radius: 5px;
            cursor: pointer;
            font-family: 'MedievalSharp', cursive;
            font-size: 1.1rem;
            transition: all 0.3s;
            width: 100%;
            grid-column: span 2;
        }
        
        .btn:hover {
            background-color: var(--secondary-color);
            transform: translateY(-2px);
            box-shadow: 0 5px 15px rgba(0, 0, 0, 0.3);
        }
        
        .fichas-info {
            background-color: rgba(62, 39, 35, 0.7);
            padding: 20px;
            border-radius: 8px;
            border-left: 5px solid var(--accent-color);
            margin-bottom: 30px;
            text-align: center;
            font-size: 1.2rem;
        }
        
        .fichas-count {
            font-size: 2rem;
            color: var(--accent-color);
            font-weight: bold;
        }
        
        .mensagem {
            background-color: rgba(139, 69, 19, 0.8);
            color: white;
            padding: 15px;
            border-radius: 5px;
            margin-bottom: 30px;
            text-align: center;
            font-size: 1.1rem;
            border-left: 5px solid var(--accent-color);
        }
        
        @media (max-width: 768px) {
            .transfer-form {
                grid-template-columns: 1fr;
            }
            
            .form-group.full-width {
                grid-column: span 1;
            }
            
            .btn {
                grid-column: span 1;
            }
        }
    </style>
</head>
<body>
    <div class="container">
        <h1 class="titulo">Transferência de Fichas</h1>
        
        <?php if (isset($_SESSION['msg'])): ?>
            <div class="mensagem">
                <?= $_SESSION['msg'] ?>
                <?php unset($_SESSION['msg']); ?>
            </div>
        <?php endif; ?>
        
        <div class="fichas-info">
            <p>Suas fichas disponíveis para transferência:</p>
            <p class="fichas-count"><?= $total_fichas ?> fichas</p>
        </div>
        
        <form method="POST" class="transfer-form">
            <div class="form-group">
                <label for="jogador_destino">Nome do Jogador Destino:</label>
                <input type="text" id="jogador_destino" name="jogador_destino" required>
            </div>
            
            <div class="form-group">
                <label for="quantidade">Quantidade de Fichas:</label>
                <input type="number" id="quantidade" name="quantidade" min="1" max="<?= $total_fichas ?>" required>
            </div>
            
            <div class="form-group full-width">
                <label for="pin">Código PIN:</label>
                <input type="password" id="pin" name="pin" maxlength="4" required>
            </div>
            
            <button type="submit" class="btn">Realizar Transferência</button>
        </form>
    </div>
</body>
</html>