<?php
session_start();
require 'conexao.php';

// Verifique se o usuário não está logado
if (!isset($_SESSION['user_id'])) {
    // Redirecione-o para a página de login
    header("Location: login.php");
}
?>

<!DOCTYPE html>
<html>
<head>
<title>Criar jogo</title>
<link rel="stylesheet" type="text/css" href="style.css">
</head>
<body><center>
<img class="bn" src="bn.png" alt=""><br><br><br>
<a href="dashboard.php"><button class="btnmenu">Menu principal</button></a><br><br>



<?php

// Verifique se o formulário foi submetido
if ($_SERVER['REQUEST_METHOD'] === 'POST' && isset($_POST['game_id'])) {
    $game_id = $_POST['game_id'];
   $_SESSION['game_select'] = $game_id;
$games = $_SESSION['game_select'];
try {
    // Consulta SQL para selecionar os valores de p1, bet, time e limite onde game seja igual a $game_id
    $stmt = $pdo->prepare("SELECT p1, bet, time, limite FROM games WHERE game = :game_id");
    $stmt->bindParam(':game_id', $game_id, PDO::PARAM_STR);
    $stmt->execute();
    
    // Verifica se a consulta retornou algum resultado
    if ($stmt->rowCount() > 0) {
        $row = $stmt->fetch(PDO::FETCH_ASSOC);
        $p1 = $row['p1'];
        $bet = $row['bet'];
        $time = $row['time'];
        $limite = $row['limite'];

        // Agora você pode exibir esses valores
        echo "Quer mesmo entrar nesse jogo?<br>";
        echo "Jogador 1: $p1<br>";
        echo "Aposta: $bet<br>";
        echo "Tempo por turno: $time minutos<br>";
        echo "Limite de turnos: $limite<br>";
        echo $games;
    } else {
        echo "Jogo não encontrado.";
    }
} catch (PDOException $e) {
    echo "Erro na consulta: " . $e->getMessage();
}


    
}

?>
<br>

<a href="entrar_no_jogo.php"><button class="btnmenu">Entrar</button></a><br><br>

