<?php
session_start();

// Verificar se o usuário está logado (remetente)
if (!isset($_SESSION['user_id'])) {
    $_SESSION['mensagem'] = 'Erro: Você precisa estar logado para realizar uma transação.';
    header('Lo
   cation: dashboard.php');
    exit;
}

// Verificar se os dados do formulário foram enviados
if (isset($_POST['destinatario']) && isset($_POST['valor'])) {
    $destinatario = $_POST['destinatario'];
    $moeda = $_POST['moeda'];
    $remetente = $_SESSION['user_wallet']; // Alterado para usar a wallet do usuário
    $dataehora = date('Y-m-d H:i:s');
    $valor = $_POST['valor'];
    $pin = $_SESSION['user_pin'];
    $postpin = $_POST['pin'];
    
        // Verificar se o destinatário é igual ao remetente
    if ($destinatario === $remetente) {
        $_SESSION['mensagem'] = 'Erro: Não pode enviar pra sua carteira.';
        header('Location: dashboard.php');
        exit;
    }


    // Verificar se o valor é 0
  
    if ($valor <= 0) {
        $_SESSION['mensagem'] = 'Erro: Você não pode enviar 0 Latillas.';
        header('Location: dashboard.php');
        exit;
    }


    



if ($moeda = lts) {
// Verificar se o valor é maior que a quantidade de latillas disponíveis
    $latillasDisponiveis = $_SESSION['latilas'];
    if ($valor > $latillasDisponiveis) {
        $_SESSION['mensagem'] = 'Erro: Você só tem ' . $latillasDisponiveis . ' Latillas disponíveis.';
        header('Location: dashboard.php');
        exit;
    }
}
else if ($moeda = btc) {
$latillasDisponiveis = $_SESSION['bitcoins'];
    if ($valor > $latillasDisponiveis) {
        $_SESSION['mensagem'] = 'Erro: Você só tem ' . $latillasDisponiveis . ' Bitcoins disponíveis.';
        header('Location: dashboard.php');
        exit;
    }
}




$pincripto = password_hash($postpin, PASSWORD_DEFAULT); // Criptografar o PIN fornecido via POST










    // Verificar se o destinatário existe na tabela "usersblock"
    try {
        // Incluir o arquivo de conexão com o banco de dados
        require_once 'conexao.php';

        // Preparar a consulta SQL para verificar se o destinatário existe
        $stmt = $pdo->prepare("SELECT COUNT(*) FROM usersblock WHERE wallet = :destinatario");
        $stmt->bindParam(':destinatario', $destinatario);
        $stmt->execute();

        $existeDestinatario = $stmt->fetchColumn();
        if ($existeDestinatario) {
            // Gerar o hash único usando os dados da transação
            $hash = sha1($destinatario . $remetente . $dataehora . $valor . uniqid());

            // Gerar o hash interno aleatório (link)
            $link = uniqid('', true);
            $link = str_replace('.', '', $link); // Remover os pontos, se houver
            while (strlen($link) < 50) {
                $link .= uniqid('', true);
            }

            try {
                // Preparar a consulta SQL para inserir na mempool
                $stmt = $pdo->prepare("INSERT INTO mempool (destinatario, remetente, dataehora, valor, hash, link) VALUES (:destinatario, :remetente, :dataehora, :valor, :hash, :link)");

                // Bind dos parâmetros
                $stmt->bindParam(':destinatario', $destinatario);
                $stmt->bindParam(':remetente', $remetente);
                $stmt->bindParam(':dataehora', $dataehora);
                $stmt->bindParam(':valor', $valor);
                $stmt->bindParam(':hash', $hash);
                $stmt->bindParam(':link', $link);

                // Executar a consulta
                if ($stmt->execute()) {
                    $_SESSION['mensagem'] = 'Transação realizada com sucesso!';
                    $_SESSION['linkhash'] = '$link';
                } else {
                    $_SESSION['mensagem'] = 'Erro ao processar a transação.';
                }
            } catch (PDOException $e) {
                $_SESSION['mensagem'] = 'Erro na consulta: ' . $e->getMessage();
            }
        } else {
            $_SESSION['mensagem'] = 'Erro: A carteira do destinatário não existe.';
        }
    } catch (PDOException $e) {
        $_SESSION['mensagem'] = 'Erro na consulta: ' . $e->getMessage();
    }

    header('Location: dashboard.php');
    exit;
} else {
    $_SESSION['mensagem'] = 'Erro: Todos os campos do formulário são obrigatórios.';
    header('Location: dashboard.php');
    exit;
}
?>
