<?php
session_start();
require 'conexao.php';

// Verifique se o usuário não está logado
if (!isset($_SESSION['user_id'])) {
    // Redirecione-o para a página de login
    header("Location: login.php");
}

$_SESSION['vendido'] = "1"; // pra verificação se já foi vendido na ordem n vender dnv
?>

<!DOCTYPE html>
<html>
<head>
<style>
table {
width: 60%;
}
body {
    font-family: Arial, sans-serif;
    
    font-size: 16px;
}
.link-vermelho {
    color: red; /* Cor vermelha */
    text-decoration: none; /* Remova o sublinhado */
}

.link-verde {
    color: green; /* Cor vermelha */
    text-decoration: none; /* Remova o sublinhado */
}

</style>
    <title>Painel de Controle</title>
    <link rel="stylesheet" type="text/css" href="style.css">
    <style>
        /* Adicione o estilo da paginação aqui, se necessário */
    </style>
</head>
<body>
    <center>
        <img class="bn" src="bn.png" alt=""><br><br>
        <a href="dashboard.php"><button class="btnmenu">Menu principal</button></a><br>
        <h1>Ordens de Compra</h1>

        <?php
        $msg = $_SESSION['msg'];
        echo "<p class='txtpadrao'>$msg</p><br>";
        
        // Defina o número máximo de itens por página
        $itensPorPagina = 10;

        // Obtenha o número total de itens
        $sqlTotal = "SELECT COUNT(*) FROM ordens_compra";
        $stmtTotal = $pdo->prepare($sqlTotal);
        $stmtTotal->execute();
        $totalItens = $stmtTotal->fetchColumn();

        // Calcule o número total de páginas
        $totalPaginas = ceil($totalItens / $itensPorPagina);

        // Obtenha a página atual da URL, ou defina como 1 se não houver valor
        $paginaAtual = isset($_GET['pagina']) ? $_GET['pagina'] : 1;

        // Calcule o índice do primeiro item a ser exibido
        $indicePrimeiroItem = ($paginaAtual - 1) * $itensPorPagina;

        // Consulta SQL com limitação para a página atual
        $sql = "SELECT * FROM ordens_compra ORDER BY valor DESC LIMIT :indicePrimeiroItem, :itensPorPagina";
        $stmt = $pdo->prepare($sql);
        $stmt->bindParam(':indicePrimeiroItem', $indicePrimeiroItem, PDO::PARAM_INT);
        $stmt->bindParam(':itensPorPagina', $itensPorPagina, PDO::PARAM_INT);
        $stmt->execute();

        // Exibir uma tabela com os resultados
        echo "<table border='1'>";
        echo "<tr><th>Quantidade</th><th>Valor</th><th>Data de Publicação</th><th>Ação</th></tr>";

        while ($row = $stmt->fetch(PDO::FETCH_ASSOC)) {
            $quantidade = $row['quantidade'];
            $valor = $row['valor'];
            $data_publicacao = $row['dataehora'];

            echo "<tr>";
            echo "<td>$quantidade</td>";
            echo "<td>R$ $valor</td>"; // Formatando o valor como moeda
            echo "<td>$data_publicacao</td>";
            echo "<td>";

            // Verifique se o usuário da ordem de compra é o mesmo que o usuário logado
            if ($_SESSION['user_name'] == $row['user']) {
                echo "<a href='apagarordemc.php?id=" . $row['id'] . "' class='link-vermelho' onclick=\"return confirm('Tem certeza de que deseja apagar esta ordem de compra?');\">Apagar</a>";
            } else {
                echo "<div class='link-verde'>Dispolível</div>";
            }

            echo "</td>";
            echo "</tr>";
        }

        echo "</table>";

        // Exibir a paginação
        echo '<br><br><div class="pagination">';
        if ($paginaAtual > 1) {
            echo '<a href="?pagina=1">&lt;&lt;</a>'; // Primeira página
            echo '<a href="?pagina=' . ($paginaAtual - 1) . '">&lt;</a>'; // Página anterior
        }

        for ($i = 1; $i <= $totalPaginas; $i++) {
            if ($i == $paginaAtual) {
                echo '<span class="current">' . $i . '</span>'; // Página atual
            } else {
                echo '<a href="?pagina=' . $i . '">' . $i . '</a>'; // Outras páginas
            }
        }

        if ($paginaAtual < $totalPaginas) {
            echo '<a href="?pagina=' . ($paginaAtual + 1) . '">&gt;</a>'; // Próxima página
            echo '<a href="?pagina=' . $totalPaginas . '">&gt;&gt;</a>'; // Última página
        }

        echo '</div>';
        ?>
        
    </center>
</body>
</html>
