<?php
session_start();
require 'conexao.php';

// Verifique se o jogador está logado (você pode usar sua lógica de verificação)
if (!isset($_SESSION['user_id'])) {
    header("Location: login.php");
    exit;
}



// Cálculo do saldo na carteira (baseado na mempool - tabela mempool)
try {
    $wallet = $_SESSION['user_wallet'];

    // Consulta de saldo enviado (remetente) na mempool
    $stmt = $pdo->prepare("SELECT SUM(valor) AS total_enviado FROM mempool WHERE remetente = :wallet");
    $stmt->bindParam(':wallet', $wallet);
    $stmt->execute();
    $result = $stmt->fetch(PDO::FETCH_ASSOC);

    $saldo_enviado = $result['total_enviado'];

    // Consulta de saldo recebido (destinatário) na mempool
    $stmt = $pdo->prepare("SELECT SUM(valor) AS total_recebido FROM mempool WHERE destinatario = :wallet");
    $stmt->bindParam(':wallet', $wallet);
    $stmt->execute();
    $result = $stmt->fetch(PDO::FETCH_ASSOC);

    $saldo_recebido = $result['total_recebido'];

    // Saldo na carteira (considerando valores enviados e recebidos)
    $saldo_carteira = bcsub($saldo_recebido, $saldo_enviado, 10);

    // Verificar se o saldo é negativo e ajustar para zero, se necessário
    $saldo_carteira = max($saldo_carteira, 0);

    // Definir a cor do saldo na carteira
    $cor_saldo_carteira = $saldo_carteira >= 0 ? 'darkgreen' : 'darkred';

    // Calcular o saldo livre (sem considerar valores no cofre)
    $saldo_livre = $saldo_carteira;
    $_SESSION['latillas'] = $saldo_livre;
    $_SESSION['saldolivre'] = $saldo_livre;

} catch (PDOException $e) {
    $saldo_carteira = "Erro na consulta: " . $e->getMessage();
    $cor_saldo_carteira = 'darkred';
    $saldo_livre = "Erro na consulta: " . $e->getMessage();
}





// Verifique se o formulário foi submetido
if (1 < 2) {
    $game_id = $_SESSION['game_select'];
    $player_name = $_SESSION['user_name'];
    $current_datetime = date("Y-m-d H:i:s");


// pegar dados do jogo selecionado
try {
    // Certifique-se de que $game_id esteja em um formato seguro para consulta SQL
    $game_id = intval($game_id); // Converte para inteiro, se necessário
    
    // Consulta SQL para selecionar os dados do jogo com base em $game_id
    $stmt = $pdo->query("SELECT * FROM games WHERE game = $game_id");
    $rows = $stmt->fetchAll(PDO::FETCH_ASSOC);

    foreach ($rows as $row) {
        $game = $row['game'];
        $bet = $row['bet'];
        $p1 = $row['p1'];
        $p2 = $row['p2'];
    }
} catch (PDOException $e) {
    echo "Erro na consulta: " . $e->getMessage();
}

if ($p2 != '') {
echo "Você ou outro player já entrou nesse jogo.";
exit;
}
// pegar o valor da bet, verificar se o jogar tem saldo disponível, mandar para mempol, 



// Defina $idgame com o valor desejado.
$idgame = $_SESSION['game_select'];
try {
    // Consulta SQL para obter o valor da coluna 'bet' onde 'id' é igual a $idgame
    $sql = "SELECT * FROM games WHERE game = :idgame";
    $stmt = $pdo->prepare($sql);
    $stmt->bindParam(':idgame', $idgame, PDO::PARAM_INT);
    $stmt->execute();

    // Verifique se a consulta retornou algum resultado
    if ($stmt->rowCount() > 0) {
        // Obtém o resultado como um array associativo
        $row = $stmt->fetch(PDO::FETCH_ASSOC);

        // Atribui o valor de 'bet' a $betgame
        $betgame = $row['bet'];
$p1 = $row['p1'];
        // Agora $betgame contém o valor da coluna 'bet' para o jogo com o ID $idgame
        // echo "O valor da aposta para o jogo com ID $idgame é: $betgame";
    } else {
        echo "Jogo não encontrado com o ID $idgame.";
    }
} catch (PDOException $e) {
    echo "Erro ao buscar o valor da aposta: " . $e->getMessage();
}



if ($betgame > $saldo_livre) {
$_SESSION['msg'] = "O valor da aposta é maior que o saldo disponível.";
header("Location: entrarjogo.php");
exit;
}





    try {
        // Atualize o jogo com os dados do jogador
        $sql = "UPDATE games SET p2 = :player_name, turn = :player_name, played = :current_datetime WHERE game = :game_id AND p2 = 0";
        $stmt = $pdo->prepare($sql);
        $stmt->bindParam(':player_name', $player_name, PDO::PARAM_STR);
        $stmt->bindParam(':current_datetime', $current_datetime, PDO::PARAM_STR);
        $stmt->bindParam(':game_id', $game_id, PDO::PARAM_INT);
        $stmt->execute();

        // Verifique se a atualização foi bem-sucedida
        if ($stmt->rowCount() > 0) {
              $_SESSION['msg'] = "";

        } else {
            echo "Não foi possível entrar no jogo. O jogo já está em andamento ou não existe.";
            exit;
        }
    } catch (PDOException $e) {
        echo "Erro ao entrar no jogo: " . $e->getMessage();
        exit;
    }
} else {
    echo "Formulário inválido.";
}




        // Inserir dados na mempol / tirar saldo usuário 
try {
    // Seus valores
    $userwallet = $_SESSION['user_wallet'];
    $bet = $betgame;
    $game_id = $_SESSION['game_select'];
    $dataehora = date("Y-m-d H:i:s"); // Obtém a data e hora atual no formato 'AAAA-MM-DD HH:MM:SS'
    
    // Preparar a declaração SQL para inserção na tabela mempool
    $sql = "INSERT INTO mempool (destinatario, remetente, dataehora, valor) VALUES (:destinatario, :remetente, :dataehora, :valor)";
    $stmt = $pdo->prepare($sql);

    // Vincular os parâmetros com os valores
    $stmt->bindParam(':destinatario', $game_id, PDO::PARAM_STR);
    $stmt->bindParam(':remetente', $userwallet, PDO::PARAM_STR);
    $stmt->bindParam(':dataehora', $dataehora, PDO::PARAM_STR);
    $stmt->bindParam(':valor', $bet, PDO::PARAM_STR);

    // Executar a consulta
    $stmt->execute();

    // Verificar se o INSERT foi bem-sucedido
    if ($stmt->rowCount() > 0) {
      //  echo "Inserção na mempool bem-sucedida!";
    } else {
        echo "Nenhum registro inserido na mempool.";
    }
} catch (PDOException $e) {
    echo "Erro na inserção na mempool: " . $e->getMessage();
    exit;
}

        

// Criar tabulheiro
$game = $idgame;
$pl1 = $p1;
$play2 = $_SESSION['user_name'];
$pl2 = $play2;

    $insercoes = "
('$game', 1, '', 0, '1', '0', '2', '8', '0'),
('$game', 2, '1', '$pl1', '1', '0', '3', '9', '1'),
('$game', 3, '2', '$pl1', '1', '0', '4', '10', '2'),
('$game', 4, '3', '$pl1', '1', '0', '5', '11', '3'),
('$game', 5, '4', '$pl1', '1', '0', '6', '12', '4'),
('$game', 6, '5', '$pl1', '1', '0', '7', '13', '5'),
('$game', 7, '', 0, '1', '0', '0', '14', '6'),

('$game', 8, '', 0, '1', '1', '9', '15', '0'),
('$game', 9, '', 0, '1', '2', '10', '0', '8'),
('$game', 10, '', 0, '1', '3', '11', '17', '9'),
('$game', 11, '', 0, '1', '4', '12', '0', '10'),
('$game', 12, '', 0, '1', '5', '13', '19', '11'),
('$game', 13, '', 0, '1', '6', '14', '0', '12'),
('$game', 14, '', 0, '1', '7', '0', '21', '13'),

('$game', 15, '', 0, '1', '8', '0', '22', '0'),
('$game', 16, 'x', 0, '0', '9', '17', '23', '15'),
('$game', 17, '', 0, '1', '10', '0', '24', '0'),
('$game', 18, 'x', 0, '0', '11', '19', '25', '17'),
('$game', 19, '', 0, '1', '12', '0', '26', '0'),
('$game', 20, 'x', 0, '0', '13', '21', '27', '19'),
('$game', 21, '', 0, '1', '14', '0', '28', '0'),

('$game', 22, '', 0, '1', '15', '23', '29', '0'),
('$game', 23, '', 0, '1', '0', '24', '30', '22'),
('$game', 24, '', 0, '1', '17', '25', '31', '23'),
('$game', 25, '', 0, '1', '0', '26', '32', '24'),
('$game', 26, '', 0, '1', '19', '27', '33', '25'),
('$game', 27, '', 0, '1', '0', '28', '34', '26'),
('$game', 28, '', 0, '1', '21', '0', '35', '27'),

('$game', 29, '', 0, '1', '22', '30', '0', '0'),
('$game', 30, '5', '$pl2', '1', '23', '31', '0', '29'),
('$game', 31, '4', '$pl2', '1', '24', '32', '0', '30'),
('$game', 32, '3', '$pl2', '1', '25', '33', '0', '31'),
('$game', 33, '2', '$pl2', '1', '26', '34', '0', '32'),
('$game', 34, '1', '$pl2', '1', '27', '35', '0', '33'),
('$game', 35, '', 0, '1', '28', '0', '0', '34')
";

    


$sql = "INSERT INTO `tabuleiro` (`game`, `id2`, `peca`, `player`, `tipo`, `n`, `l`, `s`, `o`) VALUES ";
$sql .= $insercoes;


try {
    $pdo->exec($sql); // Use a variável $pdo para executar a consulta
   // echo "Inserções realizadas com sucesso!";
 $_SESSION['game_select'] = $game;
   $_SESSION['gameselect'] = $game;
   
   
   
   header("Location: tst.php");
} catch (PDOException $e) {
    echo "Erro ao executar as inserções: " . $e->getMessage();
    exit;
}



?>