<?php
session_start();
require 'conexao.php';

// Verificar se o usuário está logado
if (!isset($_SESSION['user_id'])) {
    // Redirecione-o para a página de login
    header("Location: login.php");
}

// Definir o usuário atual
$user_name = $_SESSION['user_name'];

// Paginação
$registros_por_pagina = 10;
$pagina_atual = isset($_GET['pagina']) ? (int)$_GET['pagina'] : 1;
$offset = ($pagina_atual - 1) * $registros_por_pagina;

// Consulta para obter notificações onde user2 é igual a $user_name
$sql = "SELECT * FROM notificacoes_sis WHERE user2 = :user_name ORDER BY dataehora DESC";
$stmt = $pdo->prepare($sql);
$stmt->bindParam(':user_name', $user_name, PDO::PARAM_STR);
$stmt->execute();

// Atualizar vz2 para 1 para marcar como lido
$sqlUpdateVz2 = "UPDATE notificacoes_sis SET vz2 = 1 WHERE user2 = :user_name";
$stmtUpdateVz2 = $pdo->prepare($sqlUpdateVz2);
$stmtUpdateVz2->bindParam(':user_name', $user_name, PDO::PARAM_STR);
$stmtUpdateVz2->execute();

// Total de notificações não lidas (vz2 = 0)
$sqlTotal = "SELECT COUNT(*) AS total FROM notificacoes_sis WHERE user2 = :user_name AND vz2 = 0";
$stmtTotal = $pdo->prepare($sqlTotal);
$stmtTotal->bindParam(':user_name', $user_name, PDO::PARAM_STR);
$stmtTotal->execute();
$total_notificacoes = $stmtTotal->fetchColumn();

?>

<!DOCTYPE html>
<html>
<head>
    <title>Notificações</title>
    <link rel="stylesheet" type="text/css" href="style.css">
    <style>
        .notificacoes-container {
            
            width: 80%;
            margin: 20px auto;
            padding: 20px;
            border-radius: 10px;
        }

        .notificacao {
            border: 4px solid #007bff;
            border-radius: 15px;
            padding: 10px;
            margin-bottom: 20px;
            word-wrap: break-word;
        }

        .notificacao-lida {
            border: 4px solid #fff; /* Azul */
        }

        .pagination {
            display: flex;
            justify-content: center;
            list-style: none;
            padding: 0;
        }

        .page-item {
            margin: 5px;
        }
    </style>
</head>
<body>
<img class="bn" src="bn.png" alt=""><br><br>
<div class="titulo">Minhas Notificações</div>
<a href="dashboard.php"><button class="btnmenu">Menu principal</button></a><br><br>

<div class="notificacoes-container">
    <?php
    if ($stmt->rowCount() > 0) {
        while ($row = $stmt->fetch(PDO::FETCH_ASSOC)) {
            $classe_notificacao = ($row['vz2'] == 0) ? 'notificacao' : 'notificacao notificacao-lida';
            echo '<div class="' . $classe_notificacao . '">';
            echo 'Tipo: ' . $row['tipo'] . '<br>';
            echo 'Notificação: ' . $row['notificacao'] . '<br>';
            echo 'Data & Hora: ' . $row['dataehora'] . '<br>';
            echo '</div>';
        }
    } else {
        echo '<p>Nenhuma notificação encontrada.</p>';
    }
    ?>
</div>


</body>
</html>
