<?php
session_start();
require 'conexao.php';

// Verifica se o usuário está logado
if (!isset($_SESSION['user_id'])) {
    header("Location: login.php");
    exit();
}

// Obtém o nome do jogador da sessão
$jogador = $_SESSION['user_name'];

// Consulta as fichas do jogador
try {
    $stmt = $pdo->prepare("
        SELECT quantidade, preco, jogador
        FROM fichas
        WHERE jogador = :jogador
    ");
    $stmt->bindParam(':jogador', $jogador, PDO::PARAM_STR);
    $stmt->execute();
    $fichas = $stmt->fetchAll(PDO::FETCH_ASSOC);
} catch (PDOException $e) {
    die("Erro ao consultar fichas: " . $e->getMessage());
}
?>

<!DOCTYPE html>
<html lang="pt-br">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Minhas Fichas</title>
    <link rel="stylesheet" href="style.css">
    <style>
        table {
            width: 80%; /* Define a largura maior para a tabela */
            border-collapse: collapse;
            margin: 20px auto;
            font-size: 18px; /* Aumenta o tamanho da fonte */
        }

        th, td {
            border: 1px solid white;
            padding: 10px;
            text-align: center;
        }

        th {
            background-color: black;
        }

        
    </style>
</head>
<body>
    <h1>Minhas Fichas</h1>
    <a href="dashboard.php"><button class="btnmenu">Menu Principal</button></a><br><br>
    <center>
    <?php if (count($fichas) > 0): ?>
        <table>
            <thead>
                <tr>
                    <th>Quantidade</th>
                    <th>Valor da Ficha</th>
                </tr>
            </thead>
            <tbody>
                <?php foreach ($fichas as $ficha): ?>
                    <tr>
                        <td><?= htmlspecialchars($ficha['quantidade']) ?></td>
                        <td><?= htmlspecialchars($ficha['preco']) ?></td>
                    </tr>
                <?php endforeach; ?>
            </tbody>
        </table>
    <?php else: ?>
        <p>Você não possui fichas cadastradas no momento.</p>
    <?php endif; ?>
    </center>
</body>
</html>
