<?php
session_start();
require '../../conex/conexao.php';

// 1. Verificação de Segurança
if (!isset($_SESSION['user_id'])) {
    header("Location: login.php");
    exit(); // Faltava o exit aqui
}

// 2. Verifica se a requisição é POST (evita acesso direto pela URL)
if ($_SERVER['REQUEST_METHOD'] == 'POST') {

    // Recupera dados da Sessão
    $personagem = $_SESSION['personagem'] ?? null;
    $sede = $_SESSION['sede'];
    $soldados = $_SESSION['soldados'] ?? 0;

    // Verifica se personagem existe
    if (!$personagem) {
        $_SESSION['msg'] = "Erro: Personagem não selecionado.";
        header("Location: ../../dashboardmed.php");
        exit();
    }

    // 3. Regra de Negócio: Capacidade de Carga
    // Se a sede for mais q 1000
    if ($sede == 100) {
        $_SESSION['msg'] = "Seus soldados não precisam beber água, todos já estão hidratados e as garrafas cheias.";
        header("Location: ../../dashboardmed.php");
        exit(); 
    }

    // 4. Preparação dos Dados
    $bebendoagua = "bebendoagua"; // Define a situação
    $paralisado = date('Y-m-d H:i:s', strtotime('+1 minutes')); // Tempo de pesca

    // 5. Atualização no Banco de Dados (PDO Seguro)
    try {
        $sql = "UPDATE personagens SET situacao = :bebendoagua, paralisado = :paralisado WHERE id = :personagem";
        $stmt = $pdo->prepare($sql);
        
        $stmt->bindParam(':bebendoagua', $bebendoagua, PDO::PARAM_STR);
        $stmt->bindParam(':paralisado', $paralisado, PDO::PARAM_STR);
        $stmt->bindParam(':personagem', $personagem, PDO::PARAM_INT);

        if ($stmt->execute()) {
            // Sucesso
            $_SESSION['msg'] = "Você e seus soldados estão bebendo água (1 min).";
            
            // Opcional: Registrar no log (se você implementou a tabela de logs)
            // registrarLog($pdo, $_SESSION['user_name'], $personagem, 'TRABALHO', 'Iniciou Pesca', []);

            header("Location: ../../dashboardmed.php");
            exit();
        } else {
            // Erro no SQL
            $_SESSION['msg'] = "Erro ao tentar pescar. Tente novamente.";
            header("Location: ../../dashboardmed.php");
            exit();
        }
    } catch (PDOException $e) {
        $_SESSION['msg'] = "Erro de sistema: " . $e->getMessage();
        header("Location: ../../dashboardmed.php");
        exit();
    }

} else {
    // Se tentar acessar pesca.php direto pela URL sem clicar no botão
    header("Location: ../../dashboardmed.php");
    exit();
}
?>