<?php
require 'conexao.php';
session_start();

$mensagem_usuario = ''; // Para feedback (erros, sucesso)

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    // Verifica se o campo de e-mail está preenchido e é válido
    if (isset($_POST['email']) && filter_var($_POST['email'], FILTER_VALIDATE_EMAIL)) {
        
        $email = $_POST['email'];
        $_SESSION['email'] = $email; // Salva o e-mail na sessão

        // Gerar código de recuperação
        $codigo_recuperacao = str_pad(random_int(0, 999999), 6, '0', STR_PAD_LEFT);
        $_SESSION['codigo'] = $codigo_recuperacao; // Salva o código na sessão

        // --- Envio do e-mail ---
        $destinatario = $email;
        $assunto = 'Recuperação de Conta';
        $mensagem_email = "Olá,\n\nSeu código de verificação é: " . $codigo_recuperacao . "\n\nAtt,\nSistem@ Datilla";
        $headers = 'From: sistem@datilla.com' . "\r\n";

        if (mail($destinatario, $assunto, $mensagem_email, $headers)) {
            // SUCESSO: Redireciona para a verificação
            header('Location: verificar_codigo.php');
            exit; 
        } else {
            // FALHA: Informa o usuário
            $mensagem_usuario = '<div class="mensagem-erro">Houve um problema ao enviar o e-mail. Tente novamente.</div>';
        }

    } else {
        // E-mail inválido ou não preenchido
        $mensagem_usuario = '<div class="mensagem-erro">Por favor, insira um endereço de e-mail válido.</div>';
    }
}
?>
<!DOCTYPE html>
<html lang="pt-br">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=devisl-scale=1.0">
    <title>Recuperar Senha</title>
    <link rel="stylesheet" href="login/esqueci_style.css">
    <link href="https://fonts.googleapis.com/css2?family=Poppins:wght@400;600&display=swap" rel="stylesheet">
</head>
<body>

    <div class="card-container">
        
        <h2>Esqueci a Senha</h2>
        <p class="subtitulo">Digite seu e-mail e enviaremos um código de verificação.</p>

        <?php if (!empty($mensagem_usuario)) { echo $mensagem_usuario; } ?>

        <form method="POST">
            <div class="input-group">
                <label for="email">E-mail da Conta</label>
                <input type="email" id="email" name="email" placeholder="seu.email@dominio.com" required>
            </div>
            
            <button type="submit" class="btn btn-principal">
                Enviar Código
            </button>
        </form>

        <div class="links-navegacao">
            <a href="login.php" class="btn btn-navegacao">
                Lembrou? Voltar para o Login
            </a>
        </div>
    </div>
    
</body>
</html>
