<?php
session_start();
require 'conexao.php';

// 1. Verificação de Acesso
if (!isset($_SESSION['user_id'])) {
    header("Location: login.php");
    exit();
}

// 2. Inicialização de Variáveis
$msgsis2 = $_SESSION['msg2'] ?? '';
$user_id = $_SESSION['user_name'];

// Preços e Variáveis Globais
$precomadeira = 27; $_SESSION['precomadeira'] = $precomadeira;
$precocarne = 36; $_SESSION['precocarne'] = $precocarne;

$total_notificacoes = 0;
$personagemAtivo = null; 
$messages = [];
$situacao = 'Nenhum'; 
$local = '';
$paralisado = date('Y-m-d H:i:s'); 
$tipolocal = 'city'; 

// Controle de Direções e Litoral
$norte_id = ''; $leste_id = ''; $sul_id = ''; $oeste_id = ''; 
$show_n = false; $show_l = false; $show_s = false; $show_o = false;
$is_litoral = false;

$horarioAtual = date('Y-m-d H:i:s');
// Variáveis de Status


$row = []; 

// 3. Notificações
$sqlCountNotificacoes = "SELECT COUNT(*) AS total_notificacoes FROM notificacoes_jogo WHERE user2 = :user_name AND vz2 = 0";
$stmtCountNotificacoes = $pdo->prepare($sqlCountNotificacoes);
$stmtCountNotificacoes->bindParam(':user_name', $user_id, PDO::PARAM_STR);
$stmtCountNotificacoes->execute();
$total_notificacoes = $stmtCountNotificacoes->fetch(PDO::FETCH_ASSOC)['total_notificacoes'];

// 4. Modal Local (Ajax)
if (isset($_GET['location'])) {
    $location = $_GET['location'];
    $sqlLocation = "SELECT descricao FROM mapasmed WHERE nome = :location";
    $stmtLocation = $pdo->prepare($sqlLocation);
    $stmtLocation->bindParam(':location', $location, PDO::PARAM_STR);
    $stmtLocation->execute();
    $locationInfo = $stmtLocation->fetch(PDO::FETCH_ASSOC);
    if ($locationInfo) { echo $locationInfo['descricao']; exit(); }
}

// 5. Consulta Personagem
$sql = "SELECT * FROM personagens WHERE jogador = :user_id AND ativo = 1 LIMIT 1";
$stmt = $pdo->prepare($sql);
$stmt->bindParam(':user_id', $user_id, PDO::PARAM_STR);
$stmt->execute();

if ($stmt->rowCount() > 0) {
    $row = $stmt->fetch(PDO::FETCH_ASSOC);
    $personagemAtivo = $row; 
    
    $personagem_id = $row['id'];
    $nomePersonagem = $row['personagem'];
    $situacao = $row['situacao'] ?? 'livre'; 
    $local = $row['local'];
    $paralisado = $row['paralisado'];
    
    // Recursos
    $prata = $row['prata'];
    $soldados = $row['soldados'];
    $carne = $row['carne'];
    $madeira = $row['madeira'];
    $atk = $row['atk'];
    $def = $row['def'];
    $cla = $row['cla'];
    
    // Status
    $hp_atual = $row['hp_atual'] ?? 100; 
    $hp_max = $row['hp_max'] ?? 100;
    
    // Colunas de Fome/Sede
    $fome = $row['fome'] ?? 100;
    $sede = $row['sede'] ?? 100;
    
    // Sessão
    $_SESSION['personagem'] = $personagem_id;
    $_SESSION['personagem_nome'] = $nomePersonagem;
    $_SESSION['local'] = $local;
    $_SESSION['situacao'] = $situacao;
    $_SESSION['carne'] = $carne;
    $_SESSION['madeira'] = $madeira;
    $_SESSION['soldados'] = $soldados;
    $_SESSION['prata'] = $prata;
	$_SESSION['sede'] = $sede;
	$_SESSION['fome'] = $fome;
    // --- LÓGICA DE VIZINHOS E LITORAL ---
    $sqlLocal = "SELECT tipo, regiao, n, l, s, o FROM mapasmed WHERE nome = :local";
    $stmtLocal = $pdo->prepare($sqlLocal);
    $stmtLocal->bindParam(':local', $local, PDO::PARAM_STR);
    $stmtLocal->execute();
    $local_info = $stmtLocal->fetch(PDO::FETCH_ASSOC);
    
    if ($local_info) {
        $tipolocal = $local_info['tipo'];
        $regiao_atual = $local_info['regiao'];
        
        $norte_id = $local_info['n'];
        $leste_id = $local_info['l'];
        $sul_id = $local_info['s'];
        $oeste_id = $local_info['o'];

        $ids_vizinhos = array_filter([$norte_id, $leste_id, $sul_id, $oeste_id]);
        $tipos_vizinhos = [];

        if (!empty($ids_vizinhos)) {
            $inQuery = implode(',', array_map('intval', $ids_vizinhos));
            $sqlViz = "SELECT id2, tipo FROM mapasmed WHERE id2 IN ($inQuery) AND regiao = :regiao";
            $stmtViz = $pdo->prepare($sqlViz);
            $stmtViz->execute([':regiao' => $regiao_atual]);
            $tipos_vizinhos = $stmtViz->fetchAll(PDO::FETCH_KEY_PAIR); 
        }

        function analisarDirecao($id, $lista_tipos) {
            if (empty($id) || !isset($lista_tipos[$id])) return ['show' => false, 'is_mar' => false];
            $tipo = strtolower($lista_tipos[$id]);
            $is_mar = ($tipo === 'mar');
            return ['show' => !$is_mar, 'is_mar' => $is_mar];
        }

        $res = analisarDirecao($norte_id, $tipos_vizinhos); $show_n = $res['show']; if($res['is_mar']) $is_litoral=true;
        $res = analisarDirecao($leste_id, $tipos_vizinhos); $show_l = $res['show']; if($res['is_mar']) $is_litoral=true;
        $res = analisarDirecao($sul_id, $tipos_vizinhos); $show_s = $res['show']; if($res['is_mar']) $is_litoral=true;
        $res = analisarDirecao($oeste_id, $tipos_vizinhos); $show_o = $res['show']; if($res['is_mar']) $is_litoral=true;
    }
    
    // 6. Histórico
    $sqlMessages = "SELECT id, acao, dataehora, vz FROM acoespersonagens WHERE personagem = :personagem ORDER BY dataehora DESC LIMIT 30";
    $stmtMessages = $pdo->prepare($sqlMessages);
    $stmtMessages->bindParam(':personagem', $nomePersonagem, PDO::PARAM_STR);
    $stmtMessages->execute();
    $messages = $stmtMessages->fetchAll(PDO::FETCH_ASSOC);
    
    // Update VZ (Visualizado)
    $idsParaAtualizar = array_column(array_filter($messages, function($m) { return $m['vz'] == 0; }), 'id');
    if (!empty($idsParaAtualizar)) {
        $placeholders = implode(',', array_fill(0, count($idsParaAtualizar), '?'));
        $pdo->prepare("UPDATE acoespersonagens SET vz = 1 WHERE id IN ($placeholders)")->execute($idsParaAtualizar);
    }
}

// --- FUNÇÃO PARA COR DA BARRA ---
function getBarColor($val) {
    if ($val > 70) return '#28a745'; // Verde
    if ($val > 40) return '#ffd700'; // Amarelo
    if ($val > 20) return '#fd7e14'; // Laranja
    if ($val > 10) return '#dc3545'; // Vermelho
    return '#000000'; // Preto
}

function formatarTermino($data) {
    if (empty($data) || strtotime($data) === false || strtotime($data) < time()) { return "Concluído"; }
    return date('d/m/Y H:i', strtotime($data));
}
?>

<!DOCTYPE html>
<html lang="pt-BR">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>RPG ERA MEDIEVAL: Dervian</title>
    <link rel="stylesheet" href="css/dashboardmed.css">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css">
    <style>
        .status-bar-container {
            width: 100%; height: 12px; background: rgba(0, 0, 0, 0.5); border-radius: 8px; overflow: hidden;
            border: 1px solid #444; position: relative;
        }
        .status-bar-fill {
            height: 100%; transition: width 0.5s;
        }
        .status-bar-text {
            position: absolute; width: 100%; text-align: center; top: -1px; color: white; 
            font-size: 0.65rem; font-weight: bold; text-shadow: 1px 1px 2px #000; line-height: 12px;
        }
    </style>
</head>
<body>
    <div class="light-rays"></div>

    <div class="container">
        
        <header class="header-game">
             <h1 style="color: var(--primary); font-family: 'Times New Roman', serif; text-transform: uppercase; letter-spacing: 2px; text-shadow: var(--text-neon-glow); font-size: 2rem; text-align: center; margin-bottom: 10px;">
                RPG ERA MEDIEVAL: Ferro & Fogo
             </h1>
             
             <div class="btn-group navigation">
                <a href="dashboard.php"><button style="width: auto;">Menu Principal</button></a>
                <a href="pagina_notificacoesjogo.php"><button style="width: auto;">Notificações <?= ($total_notificacoes >= 1) ? '<span class="notification-badge">'.$total_notificacoes.'</span>' : '' ?></button></a>
                <button onclick="confirmarSaida()" class="btn-danger" style="width: auto;">Sair</button>
            </div>
            <hr style="margin-top: 15px;">
        </header>

        <?php if (!empty($_SESSION['msg'])): ?>
            <div class="game-msg-box">
                <?= htmlspecialchars($_SESSION['msg']) ?>
            </div>
            <?php $_SESSION['msg'] = ''; ?>
        <?php endif; ?>

        <main class="game-grid">
            
            <section class="game-panel">
                <h2 class="panel-title">Seu Personagem</h2>
                
                <?php if ($personagemAtivo): ?>
                    <div class="character-info">
                        
                        <div class="info-card">
                            <h3>Informações</h3>
                            <p><strong>Nome:</strong> <span><?= $row['personagem']; ?></span></p>
                            <p><strong>Reputação:</strong> <span><?= $row['reputacao']; ?></span></p>
                            <p><strong>Local:</strong> <span><?= $row['local']; ?></span></p>
                            <p><strong>Situação:</strong> <span class="<?= ($situacao == "livre" || $situacao == '') ? 'status-free' : 'status-busy'; ?>"><?= $row['situacao']; ?></span></p>
                            <?php if ($situacao != "livre" && $situacao != ''): ?>
                                <p><strong>Término:</strong> <span><?= formatarTermino($paralisado); ?></span></p>
                            <?php endif; ?>

                            
                                
                                <div>
                                    <div style="display: flex; justify-content: space-between; margin-bottom: 2px;">
                                        <span style="font-size: 0.9rem; font-weight: bold; color: #ccc;">Sede:</span>
                                    </div>
                                    <div class="status-bar-container">
                                        <div class="status-bar-fill" style="width: <?= $sede ?>%; background: <?= getBarColor($sede) ?>;"></div>
                                        <span class="status-bar-text"><?= $sede ?>%</span>
                                    </div>   </div>
                             
 <?php if ($is_litoral): ?>
                                <form action="personagem/acoes/beberagua.php" method="POST">
    <button type="submit" name="treinar">
        Beber Água
    </button>
</form>
                            <?php endif; ?>
                            
                            
                            <div style="margin-top: 12px; border-top: 1px dashed rgba(255,255,255,0.2); padding-top: 10px;">
                                <div style="margin-bottom: 8px;">
                                    <div style="display: flex; justify-content: space-between; margin-bottom: 2px;">
                                        <span style="font-size: 0.9rem; font-weight: bold; color: #ccc;">Fome:</span>
                                    </div>
                                    <div class="status-bar-container">
                                        <div class="status-bar-fill" style="width: <?= $fome ?>%; background: <?= getBarColor($fome) ?>;"></div>
                                        <span class="status-bar-text"><?= $fome ?>%</span>
                                    </div>
                                </div>
                                
                                <?php if ($carne > 0): ?>
                                <form action="personagem/acoes/alimentar.php" method="POST">
    <button type="submit" name="treinar">
        Alimentar-se
    </button>
</form>
</div>
 <?php endif; ?>
                 <?php if ($carne == 0): ?>  </div> <?php endif; ?>
                 
                 
                 
                        </div>
                        
                        <div class="info-card">
                            <h3>Recursos</h3>
                            <ul class="resource-list">
                                <li class="resource-item"><span class="resource-name">Prata:</span> <span class="resource-value"><?= $row['prata']; ?></span></li>
                                <li class="resource-item"><span class="resource-name">Ouro:</span> <span class="resource-value"><?= $row['ouro']; ?></span></li>
                                <li class="resource-item"><span class="resource-name">Carne:</span> <span class="resource-value"><?= $row['carne']; ?></span></li>
                                <li class="resource-item"><span class="resource-name">Madeira:</span> <span class="resource-value"><?= $row['madeira']; ?></span></li>
                            </ul>
                        </div>
                        
                        <div class="info-card">
                            <h3>Militar</h3>
                            <ul class="resource-list">
                                <li class="resource-item"><span class="resource-name">Soldados:</span> <span class="resource-value"><?= $row['soldados']; ?></span></li>
                                <li class="resource-item"><span class="resource-name">Ataque:</span> <span class="resource-value"><?= $row['atk']; ?></span></li>
                                <li class="resource-item"><span class="resource-name">Defesa:</span> <span class="resource-value"><?= $row['def']; ?></span></li>
                            </ul>
                        </div>

                        <div class="info-card">
                            <h3>Histórico</h3>
                            <div class="actions-list">
                                <?php if (!empty($messages)): ?>
                                    <?php foreach ($messages as $message): ?>
                                        <div class="action-item">
                                            <span class="action-description">
                                                <?= !empty($message['acao']) ? htmlspecialchars($message['acao']) : "Ação registrada" ?>
                                            </span>
                                            <div class="action-time">
                                                <?= date('d/m H:i', strtotime($message['dataehora'])) ?>
                                            </div>
                                        </div>
                                    <?php endforeach; ?>
                                <?php else: ?>
                                    <div class="action-item"><span class="action-description">Nenhuma ação recente.</span></div>
                                <?php endif; ?>
                            </div>
                        </div>

                    <?php else: ?>
                    <?php
                    header("Location:admpersonagens/ativarpersonagens.php");
exit();?>
                    
                        
                    <?php endif; ?>
                </div>
            </section>
            
            <section class="map-panel">
                <h2 class="panel-title">Mapa de Dervian</h2>
                <div class="map-container">
                    <?php
                    $local = $local ?? ''; 
                    $sqlMap = "SELECT nome, tipo FROM mapasmed LIMIT 36";
                    $stmtMap = $pdo->query($sqlMap);
                    
                    while ($row_map = $stmtMap->fetch(PDO::FETCH_ASSOC)) {
                        $nome = $row_map["nome"];
                        $tipo = $row_map["tipo"]; 
                        $isCurrent = ($nome == $local);
                        $img_src = "fts/mapa/terreno/" . $tipo . ".png"; 

                        echo '<div class="map-square" onclick="showLocationDescription(\''.$nome.'\')">';
                        echo '<img src="'.$img_src.'" alt="'.$nome.'" class="map-bg-img">';
                        echo '<p class="map-name">'.$nome.'</p>';
                        
                        if ($isCurrent) {
                            echo '<img src="personagem.png" class="map-personagem-marker" alt="Você">'; 
                        }
                        echo '</div>';
                    }
                    ?>
                </div>
            </section>
            
            <section class="actions-panel">
                
                <div class="action-section" style="border-left-color: var(--neon-bright);">
                    <h3 class="panel-title" style="text-align: left; font-size: 1.2rem;">Movimentação</h3>
                    
                    <?php if (isset($situacao) && ($situacao == "livre" || $situacao == '')): ?>
                        
                        <form action="personagem/acoes/moverperson.php" method="post" class="movimentacao-form-grid">
    <input type="hidden" name="mover" value="1">
    
    <!-- Removi os 'style="grid-column.."' e reordenei para ficar lógico na linha: Oeste, Norte, Sul, Leste -->
    <?php if ($show_o): ?>
        <button type="submit" name="direcao" value="<?= $oeste_id ?>" class="btn" onclick="return confirm('Mover para Oeste?')"><i class="fas fa-arrow-left"></i></button>
    <?php endif; ?>

    <?php if ($show_n): ?>
        <button type="submit" name="direcao" value="<?= $norte_id ?>" class="btn" onclick="return confirm('Mover para Norte?')"><i class="fas fa-arrow-up"></i></button>
    <?php endif; ?>

    <?php if ($show_s): ?>
        <button type="submit" name="direcao" value="<?= $sul_id ?>" class="btn" onclick="return confirm('Mover para Sul?')"><i class="fas fa-arrow-down"></i></button>
    <?php endif; ?>

    <?php if ($show_l): ?>
        <button type="submit" name="direcao" value="<?= $leste_id ?>" class="btn" onclick="return confirm('Mover para Leste?')"><i class="fas fa-arrow-right"></i></button>
    <?php endif; ?>
</form>
                        
                        <?php if (isset($tipolocal) && $tipolocal != "city"): ?>
                            <button type="button" class="btn-full-width-neon" onclick="abrirModalPersonagens()">
                                <i class="fas fa-users"></i> Quem está no local
                            </button><br>
                        <?php endif; ?>
                        
   <?php else: ?>
    <!-- ==========================================================
         BLOCO DE PERSONAGEM OCUPADO (DESIGN NEON)
         ========================================================== -->
    <div style="text-align: center; padding: 10px;">
        
        <!-- 1. Título e Situação -->
        <p style="font-size: 0.9rem; color: #aaa; margin-bottom: 5px;">STATUS ATUAL</p>
        <h3 style="color: var(--neon-bright); text-transform: uppercase; margin-bottom: 10px; text-shadow: var(--text-neon-glow);">
            <?php echo $situacao; ?>
        </h3>
        
        <!-- 2. Descrição (Texto auxiliar) -->
        <div style="color: #ccc; font-size: 0.9rem; margin-bottom: 15px; font-style: italic; min-height: 40px;">
            <?php 
            if ($situacao == "trabalhando") {echo "Seus homens estão trabalhando duro na cidade.";}
            elseif ($situacao == "caçando") {echo "Rastreando presas na mata densa.";}
            elseif ($situacao == "pegando madeira") {echo "Derrubando árvores para o estoque.";}
            elseif ($situacao == "treinandoATK") {echo "Treinamento intensivo de combate.";}
            elseif ($situacao == "treinandoDEF") {echo "Treinamento de táticas defensivas.";}
            elseif ($situacao == "escondido") {echo "Escondidos e aguardando o perigo passar.";}
            elseif ($situacao == "fugindo e reagrupando soldados") {echo "Batendo em retirada estratégica.";}
            elseif ($situacao == "reagrupando soldados") {echo "Reorganizando as fileiras após a vitória.";}
            elseif ($situacao == "Dominando cidade") {echo "Ocupando o território inimigo.";}
            elseif ($situacao == "pescando") {echo "Pescando recursos no litoral.";}
            elseif ($situacao == "bebendoagua") {echo "Hidratando as tropas.";}
            elseif ($situacao == "alimentando") {echo "Refeição e descanso.";}
           
            ?>
        </div>

        <?php
        // 3. CÁLCULO DE TEMPO
        $agora = time();
        $fim = strtotime($paralisado);
        $segundos_restantes = $fim - $agora;

        // 4. ROTEAMENTO DO BOTÃO
        $action = ''; $buttonText = '';
        if ($situacao == "trabalhando") { $action = "personagem/acoes/pegarpg.php"; $buttonText = "$ Receber Pagamento $"; }
        elseif ($situacao == "caçando") { $action = "personagem/acoes/finalisarcaca.php"; $buttonText = "♣⚔ Recolher Caça ⚔♣"; }
        elseif ($situacao == "pegando madeira") { $action = "personagem/acoes/finalisarlenha.php"; $buttonText = "♣ Recolher Madeira ♣"; }
        elseif ($situacao == "treinandoATK") { $action = "personagem/acoes/finalisartreinoatk.php"; $buttonText = "♣⚔️ Concluir Treino ⚔♣"; }
        elseif ($situacao == "treinandoDEF") { $action = "personagem/acoes/finalisartreinodef.php"; $buttonText = "♣⚔ Concluir Treino ⚔♣"; }
        elseif ($situacao == "escondido") { $action = "personagem/acoes/jogo/aparecer.php"; $buttonText = "♣ Aparecer ♣"; }
        elseif ($situacao == "fugindo e reagrupando soldados") { $action = "personagem/acoes/personagemlivre.php"; $buttonText = "⚔ Reagrupar ⚔"; }
        elseif ($situacao == "reagrupando soldados") { $action = "personagem/acoes/personagemlivre.php"; $buttonText = "⚔ Reagrupar ⚔"; }
        elseif ($situacao == "Dominando cidade") { $action = "personagem/acoes/personagemlivre.php"; $buttonText = "⚔⚔ Dominar ⚔⚔"; }
        elseif ($situacao == "pescando") { $action = "personagem/acoes/finalisarpesca.php"; $buttonText = "♠️ Recolher Rede ♠️"; }
        elseif ($situacao == "bebendoagua") { $action = "personagem/acoes/finalisarbeberagua.php"; $buttonText = "♣  Voltar à Ativa ♣"; }
        elseif ($situacao == "alimentando") { $action = "personagem/acoes/alimentar_finalizar.php"; $buttonText = "♠️ Voltar à Ativa ♠️"; }

        // Visibilidade Inicial
        $displayTimer = ($segundos_restantes > 0) ? 'block' : 'none';
        $displayBtn   = ($segundos_restantes <= 0) ? 'block' : 'none';
        ?>

        <!-- 5. O CRONÔMETRO NEON -->
        <div id="box-cronometro" style="display: <?= $displayTimer ?>;">
            <div class="timer-neon-box">
                <p style="font-size: 0.7rem; color: var(--primary); text-transform: uppercase; margin-bottom: 5px;">Tempo Restante</p>
                <div id="timer-display" class="timer-digits">--:--:--</div>
            </div>
        </div>

        <!-- 6. O BOTÃO DE AÇÃO (Estilo Neon Verde) -->
        <div id="box-botao-acao" style="display: <?= $displayBtn ?>; margin-top: 15px;">
            <?php if ($action && $buttonText): ?>
                <p style="color: #00ff44; margin-bottom: 8px; font-size: 0.9rem; text-transform: uppercase;">Ação Concluída</p>
                <form action="<?= $action ?>" method="POST" class="action-form">
                    <input type="hidden" name="local" value="treino">
                    <!-- Botão com classe CSS correta agora -->
                    <button type="submit" class="btn-finish-neon" name="treinar">
                        <?= $buttonText ?>
                    </button>
                </form>
            <?php else: ?>
                <p style="color: #555;">Aguardando sistema...</p>
            <?php endif; ?>
        </div>

    </div>

    <!-- SCRIPT DO TIMER (Mantido igual, funciona com os novos IDs) -->
    <script>
    (function() {
        var timeLeft = <?php echo max(0, $segundos_restantes); ?>;
        var display = document.getElementById('timer-display');
        var boxTimer = document.getElementById('box-cronometro');
        var boxBtn = document.getElementById('box-botao-acao');

        function updateTimer() {
            if (timeLeft <= 0) {
                if(boxTimer) boxTimer.style.display = 'none';
                if(boxBtn) boxBtn.style.display = 'block';
                clearInterval(intervalo);
                return;
            }
            var h = Math.floor(timeLeft / 3600);
            var m = Math.floor((timeLeft % 3600) / 60);
            var s = timeLeft % 60;
            h = h < 10 ? '0' + h : h;
            m = m < 10 ? '0' + m : m;
            s = s < 10 ? '0' + s : s;
            if(display) display.textContent = h + ":" + m + ":" + s;
            timeLeft--;
        }
        updateTimer();
        var intervalo = setInterval(updateTimer, 1000);
    })();
    </script>
<?php endif; ?>
                
                
                
                
                
                
                
                
                
                <?php if (isset($situacao) && ($situacao == "livre" || $situacao == '')): ?>
                    
                    <?php if (isset($tipolocal) && $tipolocal == "city"): ?>
                        <div class="action-section" style="border-left-color: var(--success-color);">
                            <h3 style="color: var(--primary); font-size: 1.1rem;">Cidade</h3>
                            
                            <form action="trabalhar.php" method="POST" class="action-form">
                                <button type="submit" class="action-btn-neon" name="trabalhar" onclick="return confirm('Mandar seus homens para trabalhar na cidade? Isso custará 5 minutos e renderá 35 pratas por homem')"><i class="fas fa-hammer"></i> Trabalhar</button>
                            </form>
                            
                            <h4 style="color:#ccc; margin-top:15px;">Contratar Soldados (80$)</h4>
                            <form action="personagem/acoes/contratar.php" method="POST" class="action-form">
                                <input type="number" name="quantidade" min="1" placeholder="Qtd" class="action-input-neon">
                                <button type="submit" class="action-btn-neon" name="contratar">Contratar</button>
                            </form>

                            <?php if ($soldados >= 1): ?>
                                <h4 style="color:#ccc; margin-top:15px;">Dispensar Soldados</h4>
                                <form action="personagem/acoes/dispensarsoldados.php" method="POST" class="action-form">
                                    <input type="number" name="quantidade" min="1" max="<?= $soldados ?>" placeholder="Qtd" class="action-input-neon">
                                    <button type="submit" class="action-btn-neon btn-danger-neon" name="dispensar">Dispensar</button>
                                </form>
                            <?php endif; ?>

                            <?php if ($carne >= 1): ?>
                                <h4 style="color:#ccc; margin-top:15px;">Vender Carne (<?= $precocarne ?>$)</h4>
                                <form action="personagem/acoes/vendercarne.php" method="POST" class="action-form">
                                    <input type="number" name="quantidade" min="1" max="<?= $carne ?>" placeholder="Qtd" class="action-input-neon">
                                    <button type="submit" class="action-btn-neon btn-warning-neon" name="vendercarne">Vender</button>
                                </form>
                            <?php endif; ?>

                            <?php if ($madeira >= 1): ?>
                                <h4 style="color:#ccc; margin-top:15px;">Vender Madeira (<?= $precomadeira ?>$)</h4>
                                <form action="personagem/acoes/vendermadeira.php" method="POST" class="action-form">
                                    <input type="number" name="quantidade" min="1" max="<?= $madeira ?>" placeholder="Qtd" class="action-input-neon">
                                    <button type="submit" class="action-btn-neon btn-warning-neon" name="vendermadeira">Vender</button>
                                </form>
                            <?php endif; ?>

                            <?php if ($is_litoral): ?>
                                <hr style="border-color: #333; margin: 20px 0 10px 0;">
                               <center> <h4 style="color: #00f3ff; margin-bottom: 5px;">Ações Costeiras</h4></center>
                              
                                <form action="personagem/acoes/pesca.php" method="POST" class="action-form">
                                    <button type="submit" class="action-btn-neon" style="border-color: #7fffd4 !important; color: #7fffd4 !important;">
                                        <i class="fas fa-fish"></i> Pescar
                                    </button>
                                </form>
                            <?php endif; ?>
                        </div>
                    <?php endif; ?>
                    
                    <?php if (isset($tipolocal) && ($tipolocal == "campo" || $tipolocal == "mata")): ?>
                        <div class="action-section" style="border-left-color: var(--primary);">
                            <h3 style="color: var(--primary); font-size: 1.1rem;"><center>Exploração</center></h3>
                            
                            <?php if ($tipolocal == "campo"): ?>
                                <form action="treinaratk.php" method="POST" class="action-form">
                                    <button type="submit" class="action-btn-neon" name="treinar"><i class="fas fa-fist-raised"></i> Treinar Ataque</button>
                                </form>
                                <form action="treinardef.php" method="POST" class="action-form">
                                    <button type="submit" class="action-btn-neon" name="treinar"><i class="fas fa-shield-alt"></i> Treinar Defesa</button>
                                </form>
                            <?php endif; ?>
                            
                            <?php if ($tipolocal == "mata"): ?>
                                <form action="personagem/acoes/caca.php" method="POST" class="action-form">
                                    <button type="submit" class="action-btn-neon" name="caca"><i class="fas fa-paw"></i> Caçar</button>
                                </form>
                                <form action="personagem/acoes/lenhar.php" method="POST" class="action-form">
                                    <button type="submit" class="action-btn-neon" name="lenhar"><i class="fas fa-tree"></i> Coletar Madeira</button>
                                </form>
                            <?php endif; ?>

                            <?php if ($is_litoral): ?>
                                <hr style="border-color: #333; margin: 20px 0 10px 0;">
                                <h4 style="color: #00f3ff; margin-bottom: 5px;">Ações Costeiras</h4>
                                
                                <form action="personagem/acoes/beberagua.php" method="POST" class="action-form">
                                    <button type="submit" class="action-btn-neon" style="border-color: #00ffff !important; color: #00ffff !important;">
                                        <i class="fas fa-glass-whiskey"></i> Beber Água
                                    </button>
                                </form>
                                <form action="personagem/acoes/pesca.php" method="POST" class="action-form">
                                    <button type="submit" name="pesca"  class="action-btn-neon" style="border-color: #7fffd4 !important; color: #7fffd4 !important;">
                                        <i class="fas fa-fish"></i> Pescar
                                    </button>
                                </form>
                            <?php endif; ?>

                        </div>
                    <?php endif; ?>
                <?php endif; ?>
                <br>
                <?php if ($situacao !== 'escondido' && $situacao !== 'fugindo e reagrupando soldados'): ?>
                    <div class="action-section" style="border-left-color: var(--neon-bright);">
                        <h3 style="color: var(--primary); text-align: left; font-size: 1.1rem; border-bottom: 1px dashed var(--primary);"><center><font color="white">Chat local</font></center></h3>
                        
                        <div class="combat-iframe" style="height: 350px; border: none;">
                            <iframe src="chat_firebase.php" style="width: 100%; height: 100%; border: none;"></iframe>
                        </div>

                    </div>
                <?php endif; ?>

            </section>
        </main>
        <center>
        <footer class="footer-simple-medieval" style="margin-top: 30px;">
            <div class="footer-content">
                <h4>⚔️ RPG ERA MEDIEVAL: FERRO & FOGO ⚔️</h4>
                <p>&copy; 2025 Todos os direitos reservados.</p>
            </div>
        </footer></center>
    </div>
    
    <div id="locationModal" class="modal"><div class="modal-content"><span class="close-modal" onclick="closeModal()">&times;</span><h2 id="modalLocationName" style="color: var(--neon-bright);"></h2><p id="modalLocationDescription" style="color: var(--light-text);"></p></div></div>
    <div id="modalPersonagens" class="modal"><div class="modal-content"><span class="close-modal" onclick="fecharModalPersonagens()">&times;</span><h2 style="color: var(--neon-bright);">Personagens</h2><div id="conteudoModal" style="max-height: 400px; overflow-y: auto; margin-top: 15px; color: var(--light-text);"></div></div></div>

    <script>
        function confirmarSaida() { if (confirm("Tem certeza que deseja sair?")) { window.location.href = "logout.php"; } }
        function abrirModalPersonagens() { const m = document.getElementById('modalPersonagens'); const c = document.getElementById('conteudoModal'); m.style.display = 'block'; c.innerHTML = '<p>Carregando...</p>'; fetch('jogo/quemestanolocal.php', { method: 'POST', headers: { 'Content-Type': 'application/x-www-form-urlencoded' }, body: 'local=' + encodeURIComponent('<?php echo isset($local) ? $local : ''; ?>') }).then(r => r.text()).then(d => { c.innerHTML = d; }); }
        function fecharModalPersonagens() { document.getElementById('modalPersonagens').style.display = 'none'; }
        function showLocationDescription(n) { fetch('?location=' + encodeURIComponent(n)).then(r => r.text()).then(d => { document.getElementById('modalLocationName').textContent = n; document.getElementById('modalLocationDescription').textContent = d; document.getElementById('locationModal').style.display = 'block'; }); }
        function closeModal() { document.getElementById('locationModal').style.display = 'none'; }
        window.onclick = function(e) { if(e.target == document.getElementById('locationModal')) closeModal(); if(e.target == document.getElementById('modalPersonagens')) fecharModalPersonagens(); }
        setTimeout(function(){ location.reload(); }, 30000);
        function recarregarChat() { const i = document.getElementById('chatIframe'); if(i) i.src = i.src; }
        document.addEventListener('DOMContentLoaded', function() { setInterval(recarregarChat, 5000); });
        
        // --- MONITORAMENTO EM TEMPO REAL da situação quando o personagem ta ocupado---
    // Pega a situação que o PHP carregou inicialmente na tela
    var statusNaTela = "<?php echo isset($situacao) ? $situacao : ''; ?>";

    setInterval(function() {
        // Faz uma chamada silenciosa para o arquivo que criamos no Passo 1
        // ATENÇÃO: Verifique se o caminho 'verificar_status.php' está correto
        fetch('sistema/scripts/verificar_status_situacao_personagem.php')
            .then(response => response.text())
            .then(statusNoBanco => {
                // Remove espaços em branco extras
                statusNoBanco = statusNoBanco.trim();
                
                // Se o status no banco for diferente do que está na tela...
                if (statusNoBanco !== "" && statusNoBanco !== statusNaTela) {
                    console.log("Mudança detectada! De: " + statusNaTela + " Para: " + statusNoBanco);
                    // ...Recarrega a página para atualizar o visual
                    location.reload();
                }
            })
            .catch(err => console.error("Erro ao verificar status:", err));
    }, 3000); // Verifica a cada 3 segundos
    </script>
</body>
</html>