<?php
session_start();
require 'conexao.php';

// Verifique se o usuário não está logado
if (!isset($_SESSION['user_id'])) {
    // Redirecione-o para a página de login
    header("Location: login.php");
}
?>



<!DOCTYPE html>
<html>
<head>
    <title>Criar jogo</title>
<link rel="stylesheet" type="text/css" href="style.css">


    
<style>


</style>
</head>

    


<body>
  <img class="bn" src="bn.png" alt=""><br><br><br>

     <a href="dashboard.php"><button class="btnmenu">Menu principal</button></a><br><br>

<div class="titulo">Criar jogo</div>

<br>



<?php
session_start();
require 'conexao.php';
bcscale(10);
$msgsis = $_SESSION['msg'];


// Cálculo do saldo na carteira (baseado na mempool - tabela mempool)
try {
    $wallet = $_SESSION['user_wallet'];

    // Consulta de saldo enviado (remetente) na mempool
    $stmt = $pdo->prepare("SELECT SUM(valor) AS total_enviado FROM mempool WHERE remetente = :wallet");
    $stmt->bindParam(':wallet', $wallet);
    $stmt->execute();
    $result = $stmt->fetch(PDO::FETCH_ASSOC);

    $saldo_enviado = $result['total_enviado'];

    // Consulta de saldo recebido (destinatário) na mempool
    $stmt = $pdo->prepare("SELECT SUM(valor) AS total_recebido FROM mempool WHERE destinatario = :wallet");
    $stmt->bindParam(':wallet', $wallet);
    $stmt->execute();
    $result = $stmt->fetch(PDO::FETCH_ASSOC);

    $saldo_recebido = $result['total_recebido'];

    // Saldo na carteira (considerando valores enviados e recebidos)
    $saldo_carteira = bcsub($saldo_recebido, $saldo_enviado, 2);

    // Verificar se o saldo é negativo e ajustar para zero, se necessário
    $saldo_carteira = max($saldo_carteira, 0);

    // Definir a cor do saldo na carteira
    $cor_saldo_carteira = $saldo_carteira >= 0 ? 'darkgreen' : 'darkred';

    // Calcular o saldo livre (sem considerar valores no cofre)
    $saldo_livre = $saldo_carteira;
    $_SESSION['latillas'] = $saldo_livre;
    $_SESSION['saldolivre'] = $saldo_livre;

} catch (PDOException $e) {
    $saldo_carteira = "Erro na consulta: " . $e->getMessage();
    $cor_saldo_carteira = 'darkred';
    $saldo_livre = "Erro na consulta: " . $e->getMessage();
}

// Demais partes do código para minerar, exibir resultados, etc.
// (coloque aqui o restante do código que você possui)
?>



<font size="6px">Seu saldo</font>
  
<div class="saldos"><b>
    <br><span style="color: <?php echo $cor_saldo_carteira; ?>"><?php echo $saldo_carteira; ?> R$</span>
  </b> </div> 
  
  <div class="saldos"><b>
    <br><span style="color: blue"><?php echo $msgsis; ?></span>
  </b> </div> 
  <br><br>
  
  
  

        <form method="POST" action="criandojogo.php" onsubmit="return confirmarEnvio()">
        <input type="text" name="aposta" id="aposta" placeholder="Valor da aposta" maxlength="8">
        <br><br>

        <input type="number" name="duracao_por_minuto" max="99999" placeholder="Duração por turno (por minuto)" maxlength="5" required>
        <br><br>

        <input type="number" name="limite_de_turnos_passados" max="999" placeholder="Limite de turnos passados" maxlength="3" required>
        <br><br>

        <input type="submit" value="Criar jogo">
    </form>

    <script>
        function confirmarEnvio() {
            // Exibe um alerta de confirmação
            var confirmacao = confirm("Você deseja criar o jogo?");

            // Retorna true para permitir o envio do formulário se o usuário clicar em "OK"
            // Retorna false para cancelar o envio do formulário se o usuário clicar em "Cancelar"
            return confirmacao;
        }
    </script>



  

</body></html>