<?php
session_start();
require '../../conex/conexao.php';

// 1. Verificação de Segurança
if (!isset($_SESSION['user_id'])) {
    header("Location: ../../login.php");
    exit();
}

// 2. Apenas POST (Evita acesso via URL)
if ($_SERVER['REQUEST_METHOD'] == 'POST') {

    $personagem_id = $_SESSION['personagem'] ?? null;

    if (!$personagem_id) {
        $_SESSION['msg'] = "Erro: Personagem não selecionado.";
        header("Location: ../../dashboardmed.php");
        exit();
    }

    try {
        // Buscamos dados do banco para validar se ele PODE iniciar a ação
        // Não usamos SESSION aqui para garantir que ele tenha carne de verdade agora.
        $sql = "SELECT fome, carne FROM personagens WHERE id = :id";
        $stmt = $pdo->prepare($sql);
        $stmt->bindParam(':id', $personagem_id, PDO::PARAM_INT);
        $stmt->execute();
        $dados = $stmt->fetch(PDO::FETCH_ASSOC);

        if (!$dados) {
            $_SESSION['msg'] = "Personagem não encontrado.";
            header("Location: ../../dashboardmed.php");
            exit();
        }

        $fome_atual = (float)$dados['fome'];
        $carne_estoque = (int)$dados['carne'];

        // VALIDAÇÃO 1: Já está cheio?
        if ($fome_atual >= 100) {
            $_SESSION['msg'] = "Seus soldados não precisam comer, já estão 100% alimentados.";
            header("Location: ../../dashboardmed.php");
            exit();
        }

        // VALIDAÇÃO 2: Tem comida?
        // É importante avisar AGORA, antes de travar o personagem por minutos.
        if ($carne_estoque <= 0) {
            $_SESSION['msg'] = "Você não tem carne suficiente para iniciar a alimentação.";
            header("Location: ../../dashboardmed.php");
            exit();
        }

        // 3. Preparação para Travar o Personagem
        // Define o status e o tempo (Ex: 4 minutos a partir de agora)
        $situacao = "alimentando"; 
        $paralisado = date('Y-m-d H:i:s', strtotime('+1 minutes')); 

        // 4. Atualização no Banco
        $sqlUpdate = "UPDATE personagens SET situacao = :situacao, paralisado = :paralisado WHERE id = :id";
        $stmtUpdate = $pdo->prepare($sqlUpdate);
        
        $stmtUpdate->bindParam(':situacao', $situacao, PDO::PARAM_STR);
        $stmtUpdate->bindParam(':paralisado', $paralisado, PDO::PARAM_STR);
        $stmtUpdate->bindParam(':id', $personagem_id, PDO::PARAM_INT);

        if ($stmtUpdate->execute()) {
            $_SESSION['msg'] = "Você começou a distribuir os alimentos, seus soldados estão comendo... (Aguarde 1 min)";
            header("Location: ../../dashboardmed.php");
            exit();
        } else {
            $_SESSION['msg'] = "Erro ao iniciar alimentação.";
            header("Location: ../../dashboardmed.php");
            exit();
        }

    } catch (PDOException $e) {
        $_SESSION['msg'] = "Erro de sistema: " . $e->getMessage();
        header("Location: ../../dashboardmed.php");
        exit();
    }

} else {
    header("Location: ../../dashboardmed.php");
    exit();
}
?>