<?php
session_start();
require 'conexao.php';

if (!isset($_SESSION['user_id'])) {
    header("Location: login.php");
    exit();
}

$title = "Bem-vindo ao RPG Era Medieval<br>Um Novo Conceito de RPG Online!";
$url = "www.mavilla.online";
?>

<!DOCTYPE html>
<html lang="pt-br">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Nosso Projeto - Mavilla</title>
    <link href="https://fonts.googleapis.com/css2?family=Roboto:wght@400;700&family=Times+New+Roman:wght@700&display=swap" rel="stylesheet">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css">
    <link rel="stylesheet" href="css/dashboard.css">
    
    <style>
        body {
            background: url('rpg-login-background.jpg') no-repeat center center fixed !important;
            background-size: cover !important;
            color: white;
            min-height: 100vh;
            font-family: 'Roboto', sans-serif;
        }

        .project-card {
            background-color: rgba(0, 5, 20, 0.9);
            border: 2px solid var(--primary);
            box-shadow: 0 0 20px rgba(0, 0, 255, 0.3);
            border-radius: 15px;
            padding: 40px;
            max-width: 900px;
            margin: 20px auto;
            text-align: justify;
            line-height: 1.8;
            position: relative;
        }

        h1 {
            text-align: center;
            color: var(--neon-bright);
            font-family: 'Times New Roman', serif;
            text-transform: uppercase;
            text-shadow: 0 0 10px var(--primary);
            border-bottom: 1px solid var(--primary);
            padding-bottom: 20px;
            margin-bottom: 30px;
            font-size: 2rem;
        }

        h2 {
            color: #00f3ff;
            font-family: 'Times New Roman', serif;
            margin-top: 30px;
            margin-bottom: 15px;
            border-left: 4px solid var(--primary);
            padding-left: 15px;
        }

        p { margin-bottom: 15px; color: #e0e0e0; font-size: 1.05rem; }
        strong { color: #ffd700; }
        a { color: var(--neon-bright); text-decoration: none; font-weight: bold; }
        a:hover { text-decoration: underline; text-shadow: 0 0 5px var(--neon-bright); }

        /* === BOTÕES SOCIAIS NEON === */
        .social-section {
            margin-top: 50px;
            text-align: center;
            border-top: 1px dashed var(--primary);
            padding-top: 30px;
        }

        .social-icons {
            display: flex;
            justify-content: center;
            gap: 20px;
            margin-top: 20px;
            flex-wrap: wrap;
        }

        .social-btn {
            width: 50px;
            height: 50px;
            border-radius: 50%;
            display: flex;
            align-items: center;
            justify-content: center;
            font-size: 1.5rem;
            color: #fff;
            text-decoration: none;
            transition: all 0.3s ease;
            border: 2px solid transparent;
            background-color: #000; /* Fundo preto inicial */
        }

        /* Cores Específicas */
        .whatsapp { border-color: #25D366; color: #25D366; }
        .whatsapp:hover { background: #25D366; color: #fff; box-shadow: 0 0 20px #25D366; }

        .facebook { border-color: #1877F2; color: #1877F2; }
        .facebook:hover { background: #1877F2; color: #fff; box-shadow: 0 0 20px #1877F2; }

        .discord { border-color: #5865F2; color: #5865F2; }
        .discord:hover { background: #5865F2; color: #fff; box-shadow: 0 0 20px #5865F2; }

        .instagram { border-color: #E1306C; color: #E1306C; }
        .instagram:hover { background: #E1306C; color: #fff; box-shadow: 0 0 20px #E1306C; }

        /* Caixa de Email */
        .email-box {
            background: rgba(0, 0, 255, 0.1);
            border: 1px solid var(--primary);
            border-radius: 10px;
            padding: 15px;
            margin-top: 30px;
            display: inline-block;
            min-width: 300px;
        }
        .email-box i { color: var(--neon-bright); margin-right: 10px; }
        .email-text { font-size: 1.2rem; color: #fff; font-weight: bold; letter-spacing: 1px; }

        /* Botão Voltar */
        .btn-nav {
            display: inline-block;
            min-width: 200px;
            padding: 12px 30px;
            background-color: #000;
            color: #fff;
            border: 2px solid var(--primary);
            border-radius: 8px;
            text-align: center;
            text-transform: uppercase;
            font-weight: bold;
            cursor: pointer;
            transition: 0.3s;
            text-decoration: none;
            white-space: nowrap;
        }
        .btn-nav:hover {
            background-color: var(--primary);
            color: #000;
            box-shadow: 0 0 20px var(--neon-bright);
        }
        
        .center-btn-container { text-align: center; margin: 40px 0 20px 0; }
    </style>
</head>
<body>
    
    <div class="light-rays"></div>

    <div class="container">
        
        <div class="center-btn-container">
            <a href="dashboard.php" class="btn-nav">Menu Principal</a>
        </div>
        
        <div class="project-card">
            
            <h1><?php echo $title; ?></h1>
            
            <h2>O que é o RPG Era Medieval?</h2>
            <p>O RPG Era Medieval é um projeto inovador que traz a experiência clássica dos RPGs de mesa para um ambiente online e acessível de qualquer lugar, a qualquer hora. Se você já jogou RPG de mesa alguma vez, sabe o quão imersivo é explorar mapas, criar personagens, desenvolver habilidades e interagir com tramas ricas e envolventes. Nosso objetivo é oferecer exatamente essa experiência no seu navegador, com um sistema dinâmico onde cada escolha do jogador influencia diretamente a história do jogo.</p>
            <p>Cada jogador seguirá seu próprio caminho, tomando decisões que podem impactar profundamente o universo do jogo, interagindo com outros personagens e moldando a narrativa de forma única.</p>
            
            <h2>NFTs no RPG Era Medieval</h2>
            <p>Nosso jogo segue o modelo de jogos NFT, onde itens do jogo possuem valor real e podem ser comercializados livremente entre os jogadores. Inicialmente, os NFTs serão os <strong>próprios personagens</strong>, cada um com características únicas e um valor flexível baseado no mercado e na demanda.</p>
            <p>Diferente de projetos que supervalorizam seus ativos da noite para o dia, nosso foco é criar um ecossistema estável e sustentável. Os NFTs começarão com valores acessíveis e se valorizarão de forma gradual, conforme o crescimento do sistema, do jogo e da comunidade. Nossa proposta é proporcionar um ambiente seguro, onde os jogadores possam colecionar e transacionar seus NFTs de forma segura.</p>
            
            <h2>Nosso Desenvolvimento e Estrutura</h2>
            <p>Atualmente, estamos na fase inicial do projeto e sabemos que ainda temos um longo caminho pela frente. O jogo já possui uma estrutura funcional, com um sistema de transações seguro e um marketplace interno onde os NFTs podem ser comprados e vendidos.</p>
            <p>Nosso sistema está construído em PHP, mas contamos com mecanismos robustos de segurança para garantir a integridade das transações. Ainda não temos uma blockchain própria, mas armazenamos os dados de forma segura e estruturada, de maneira similar a uma blockchain, garantindo transparência e proteção para nossos jogadores. Todas as transações ficam registradas e podem ser acessadas pelo site <a href="http://<?php echo $url; ?>" target="_blank"><?php echo $url; ?></a>.</p>
            <p>Nosso compromisso é evoluir continuamente. Com o tempo, vamos aprimorar nossa tecnologia, implementando <strong>Node.js e Solidity</strong> para reforçar a segurança e a automação das transações. Também planejamos migrar ou criar uma blockchain real, garantindo ainda mais confiabilidade e descentralização.</p>
            
            <h2>Por que apostar no RPG Era Medieval?</h2>
            <p>Nosso projeto não é um esquema de ganhos fáceis. Não prometemos valorização exorbitante ou retornos irreais. O RPG Era Medieval é um projeto <strong>sério, sólido e de longo prazo</strong>, desenvolvido para crescer de forma sustentável. Nosso foco não é unicamente a valorização do NFT, mas sim a sustentação do projeto a longo prazo.</p>
            <p>Se você procura um <strong>jogo divertido, inovador e seguro</strong>, onde pode jogar, explorar um universo rico e ainda ter a possibilidade de comercializar seus ativos de forma consciente, este é o lugar certo. Nosso foco é criar uma comunidade engajada, onde jogadores possam aproveitar a experiência sem preocupações com esquemas de hiperinflação ou manipulação de mercado.</p>
            <p>Junte-se a nós nesta jornada! O RPG Era Medieval está apenas começando e, com sua participação, vamos transformar este projeto em algo grandioso! 🚀</p>
            
            <h2>O jogo é só isso?</h2>
            <p>Além de todo o sistema, o jogo também receberá grandes aprimoramentos. Estamos desenvolvendo um sistema de jogo muito rico, complexo e interativo. Você poderá ser um simples camponês, um soldado de algum exército, um ladrão, um rei de uma cidade, um líder de clã mercenário e até mesmo explorar o sistema de navegação, com mares, navios e pirataria sendo implementados. Tudo isso para tornar o jogo ainda mais imersivo e dinâmico.</p>
            <p>Além disso, teremos grandes eventos e acontecimentos como guerras totais, disputas por tronos, batalhas entre clãs e muitas outras mecânicas para tornar a experiência ainda mais emocionante. Você poderá jogar com amigos, dominar reinos, roubar inimigos e explorar um vasto mapa, que será expandido e recheado de novas possibilidades ao longo do tempo.</p>
            <p>Por enquanto, temos apenas uma pequena demonstração do que o jogo será, mas ainda implementaremos muitos sistemas para torná-lo um verdadeiro RPG de mesa digital, rico e complexo. Esse é apenas o começo de uma grande jornada!</p>

            <div class="social-section">
                <h3 style="color: #fff; text-transform: uppercase; font-family:'Times New Roman', serif; letter-spacing: 1px;">Conecte-se Conosco</h3>
                
                <div class="email-box">
                    <i class="fas fa-envelope"></i> 
                    <span class="email-text">suporte@mavilla.online</span>
                </div>

                <div class="social-icons">
                    <a href="#" class="social-btn whatsapp" title="WhatsApp"><i class="fab fa-whatsapp"></i></a>
                    <a href="#" class="social-btn facebook" title="Facebook"><i class="fab fa-facebook-f"></i></a>
                    <a href="#" class="social-btn discord" title="Discord"><i class="fab fa-discord"></i></a>
                    <a href="#" class="social-btn instagram" title="Instagram"><i class="fab fa-instagram"></i></a>
                </div>
            </div>

            <div class="center-btn-container">
                <a href="dashboard.php" class="btn-nav">Voltar ao Painel</a>
            </div>

        </div>

        <footer class="footer-simple-medieval">
            <div class="footer-content">
                <h4>⚔️ RPG ERA MEDIEVAL: FERRO & FOGO ⚔️</h4>
                <p>&copy; <?php echo date("Y"); ?> Todos os direitos reservados.</p>
            </div>
        </footer>

    </div>

</body>
</html>