<?php
session_start();
require '../conexao.php'; // Inclui o arquivo de conexão

ini_set('display_errors', 1);
ini_set('display_startup_errors', 1);
error_reporting(E_ALL);

// Verifica se o usuário está logado
if (!isset($_SESSION['user_id'])) {
    header("Location: login.php");
    exit();
}

$jogador_logado = $_SESSION['user_name']; // Nome do jogador logado

// Verifica se o formulário foi enviado
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $preco = (float)$_POST['preco']; // Preço das fichas a serem canceladas

    try {
        $pdo->beginTransaction();

        // Verifica se há fichas do jogador logado com o preço especificado
        $sql_verifica = "
            SELECT COUNT(*) AS quantidade 
            FROM fichaspersonagens 
            WHERE jogador = ? AND situacao = 'vendendo' AND preco = ?
        ";
        $stmt_verifica = $pdo->prepare($sql_verifica);
        $stmt_verifica->execute([$jogador_logado, $preco]);
        $resultado = $stmt_verifica->fetch(PDO::FETCH_ASSOC);

        if ($resultado['quantidade'] > 0) {
            // Atualiza a situação das fichas para '1' (disponível)
            $sql_cancelar = "
                UPDATE fichaspersonagens 
                SET situacao = '1' 
                WHERE jogador = ? AND situacao = 'vendendo' AND preco = ?
            ";
            $stmt_cancelar = $pdo->prepare($sql_cancelar);
            $stmt_cancelar->execute([$jogador_logado, $preco]);

            $pdo->commit();
            $_SESSION['msg'] = "Venda cancelada com sucesso!";
        } else {
            $pdo->rollBack();
            $_SESSION['msg'] = "Erro: Nenhuma ficha encontrada para cancelar.";
        }
    } catch (PDOException $e) {
        $pdo->rollBack();
        $_SESSION['msg'] = "Erro ao cancelar venda: " . $e->getMessage();
    }

    // Redireciona de volta para a lista de fichas
    header("Location: listavendadefichas.php");
    exit();
}
?>