<?php
session_start();
require '../../conexao.php'; 

// ==========================================================
// 1. SEGURANÇA E DADOS
// ==========================================================
if (!isset($_SESSION['user_id']) || empty($_SESSION['personagem'])) {
    header("Location: ../../login.php");
    exit();
}

$nomePersonagem = $_SESSION['personagem_nome'];

// Busca dados atualizados
$stmtP = $pdo->prepare("SELECT id, cla, cargo, jogador FROM personagens WHERE personagem = :nome LIMIT 1");
$stmtP->execute([':nome' => $nomePersonagem]);
$user_data = $stmtP->fetch(PDO::FETCH_ASSOC);

// Validação de Clã (Ignora vazio ou 'Nenhum')
if (!$user_data || empty($user_data['cla']) || $user_data['cla'] === 'Nenhum') {
    $_SESSION['msg'] = "Você não pertence a um clã.";
    header("Location: ../../dashboard.php");
    exit();
}

// Busca ID do Clã
$stmtC = $pdo->prepare("SELECT id FROM cla WHERE nome = :nome LIMIT 1");
$stmtC->execute([':nome' => $user_data['cla']]);
$cla_data = $stmtC->fetch(PDO::FETCH_ASSOC);

if (!$cla_data) {
    die("Erro de integridade: Clã não encontrado.");
}

$cla_id = $cla_data['id'];
$nome_cla = $user_data['cla'];
$meu_cargo = $user_data['cargo'] ?? 1;

// Permissões
if ($meu_cargo < 4) {
    $_SESSION['msg'] = "Seu cargo não tem permissão para acessar o gerenciamento de membros.";
    header("Location: ../../dashboard.php");
    exit();
}

$pode_convidar = $meu_cargo >= 4;
$pode_expulsar = $meu_cargo >= 5;
$pode_ver_historico = $meu_cargo >= 5;

// ==========================================================
// 2. LÓGICA DE AÇÕES (POST)
// ==========================================================
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    
    // --- CONVIDAR ---
    if (isset($_POST['acao_convidar']) && $pode_convidar) {
        $alvo_nome = trim($_POST['nome_personagem']);
        
        if (empty($alvo_nome)) {
            $_SESSION['msg'] = "Digite o nome do personagem.";
        } else {
            $stmtAlvo = $pdo->prepare("SELECT id, cla, jogador FROM personagens WHERE personagem = :nome LIMIT 1");
            $stmtAlvo->execute([':nome' => $alvo_nome]);
            $alvo_data = $stmtAlvo->fetch(PDO::FETCH_ASSOC);
            
            if (!$alvo_data) {
                $_SESSION['msg'] = "Personagem '$alvo_nome' não encontrado.";
            } elseif (!empty($alvo_data['cla']) && $alvo_data['cla'] !== 'Nenhum') {
                $_SESSION['msg'] = "Este personagem já pertence ao clã " . $alvo_data['cla'];
            } else {
                // --- CORREÇÃO DO ERRO DE CLÃ VAZIO ---
                $dono_alvo = $alvo_data['jogador'];
                
                // A query agora ignora explicitamente strings vazias ('')
                $sqlMulti = "SELECT personagem, cla FROM personagens 
                             WHERE jogador = :dono 
                             AND cla IS NOT NULL 
                             AND cla != 'Nenhum' 
                             AND cla != '' 
                             AND cla != :meu_cla";
                             
                $stmtMulti = $pdo->prepare($sqlMulti);
                $stmtMulti->execute([':dono' => $dono_alvo, ':meu_cla' => $nome_cla]);
                $spy_check = $stmtMulti->fetch(PDO::FETCH_ASSOC);
                
                if ($spy_check) {
                    $_SESSION['msg'] = "ERRO: O jogador dono deste personagem possui outra conta ({$spy_check['personagem']}) no clã '{$spy_check['cla']}'. Recrutamento bloqueado pelas regras.";
                } else {
                    $stmtCheckC = $pdo->prepare("SELECT id FROM cla_convites WHERE cla_id = :cid AND convidado = :alvo");
                    $stmtCheckC->execute([':cid' => $cla_id, ':alvo' => $alvo_nome]);
                    
                    if ($stmtCheckC->rowCount() > 0) {
                        $_SESSION['msg'] = "Já existe um convite pendente para este guerreiro.";
                    } else {
                        $pdo->beginTransaction();
                        try {
                            $stmtIns = $pdo->prepare("INSERT INTO cla_convites (cla_id, convidador, convidado, data) VALUES (:cid, :quem, :alvo, NOW())");
                            $stmtIns->execute([':cid' => $cla_id, ':quem' => $nomePersonagem, ':alvo' => $alvo_nome]);
                            
                            $stmtLog = $pdo->prepare("INSERT INTO cla_log_membros (cla_id, acao, quem_fez, cargo_quem_fez, alvo, data) VALUES (:cid, 'CONVITE', :quem, :cargo, :alvo, NOW())");
                            $stmtLog->execute([':cid' => $cla_id, ':quem' => $nomePersonagem, ':cargo' => $meu_cargo, ':alvo' => $alvo_nome]);
                            
                            $pdo->commit();
                            $_SESSION['msg'] = "Convite enviado para $alvo_nome!";
                        } catch (Exception $e) {
                            $pdo->rollBack();
                            $_SESSION['msg'] = "Erro ao enviar convite.";
                        }
                    }
                }
            }
        }
    }
    
    // --- EXPULSAR ---
    if (isset($_POST['acao_expulsar']) && $pode_expulsar) {
        $alvo_nome = trim($_POST['nome_expulsar']);
        $motivo = trim($_POST['motivacao']);
        
        if (empty($alvo_nome) || empty($motivo)) {
            $_SESSION['msg'] = "Nome e Motivação são obrigatórios.";
        } else {
            $stmtAlvo = $pdo->prepare("SELECT id, cla, cargo FROM personagens WHERE personagem = :nome LIMIT 1");
            $stmtAlvo->execute([':nome' => $alvo_nome]);
            $alvo_data = $stmtAlvo->fetch(PDO::FETCH_ASSOC);
            
            if (!$alvo_data || $alvo_data['cla'] !== $nome_cla) {
                $_SESSION['msg'] = "O alvo não pertence ao seu clã.";
            } else {
                $cargo_alvo = $alvo_data['cargo'] ?? 1;
                
                if ($cargo_alvo >= $meu_cargo) {
                    $stmtLog = $pdo->prepare("INSERT INTO cla_log_membros (cla_id, acao, quem_fez, cargo_quem_fez, alvo, motivo, data) VALUES (:cid, 'TENTATIVA_EXPULSAO', :quem, :cargo, :alvo, :mot, NOW())");
                    $stmtLog->execute([':cid' => $cla_id, ':quem' => $nomePersonagem, ':cargo' => $meu_cargo, ':alvo' => $alvo_nome, ':mot' => "Tentou expulsar superior. Bloqueado."]);
                    $_SESSION['msg'] = "Ação Negada: Você não pode expulsar patente superior/igual.";
                } else {
                    $pdo->beginTransaction();
                    try {
                        $stmtUp = $pdo->prepare("UPDATE personagens SET cla = 'Nenhum', cargo = 1 WHERE id = :id");
                        $stmtUp->execute([':id' => $alvo_data['id']]);
                        
                        $stmtLog = $pdo->prepare("INSERT INTO cla_log_membros (cla_id, acao, quem_fez, cargo_quem_fez, alvo, motivo, data) VALUES (:cid, 'EXPULSAO', :quem, :cargo, :alvo, :mot, NOW())");
                        $stmtLog->execute([':cid' => $cla_id, ':quem' => $nomePersonagem, ':cargo' => $meu_cargo, ':alvo' => $alvo_nome, ':mot' => $motivo]);
                        
                        $pdo->commit();
                        $_SESSION['msg'] = "$alvo_nome foi expulso!";
                    } catch (Exception $e) {
                        $pdo->rollBack();
                        $_SESSION['msg'] = "Erro ao expulsar.";
                    }
                }
            }
        }
    }

    // --- CANCELAR ---
    if (isset($_POST['cancelar_convite_id']) && $pode_convidar) {
        $convite_id = (int)$_POST['cancelar_convite_id'];
        $pdo->prepare("DELETE FROM cla_convites WHERE id = :id AND cla_id = :cid")->execute([':id' => $convite_id, ':cid' => $cla_id]);
        $_SESSION['msg'] = "Convite cancelado.";
    }
    
    header("Location: admmembros_cla.php");
    exit();
}

// 3. BUSCAS (Convites e Histórico)
$convites_pendentes = [];
$historico = [];
$total_paginas = 0;
$pagina = isset($_GET['p']) ? (int)$_GET['p'] : 1;
$busca = isset($_GET['busca']) ? trim($_GET['busca']) : '';

if ($pode_ver_historico) {
    // Convites
    $stmtConv = $pdo->prepare("SELECT * FROM cla_convites WHERE cla_id = :cid ORDER BY data DESC");
    $stmtConv->execute([':cid' => $cla_id]);
    $convites_pendentes = $stmtConv->fetchAll(PDO::FETCH_ASSOC);

    // Histórico
    $limite = 10;
    $offset = ($pagina - 1) * $limite;
    $sqlBase = "FROM cla_log_membros WHERE cla_id = :cid";
    $params = [':cid' => $cla_id];
    
    if (!empty($busca)) {
        $sqlBase .= " AND (alvo LIKE :busca OR quem_fez LIKE :busca)";
        $params[':busca'] = "%$busca%";
    }
    
    $stmtCount = $pdo->prepare("SELECT COUNT(*) $sqlBase");
    $stmtCount->execute($params);
    $total_paginas = ceil($stmtCount->fetchColumn() / $limite);
    
    $stmtHist = $pdo->prepare("SELECT * $sqlBase ORDER BY data DESC LIMIT $limite OFFSET $offset");
    $stmtHist->execute($params);
    $historico = $stmtHist->fetchAll(PDO::FETCH_ASSOC);
}
?>

<!DOCTYPE html>
<html lang="pt-BR">
<head>
    <meta charset="UTF-8">
    <title>Gestão de Membros | <?= htmlspecialchars($nome_cla) ?></title>
    <link rel="stylesheet" href="../../css/dashboardmed.css">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css">
    <style>
        /* LAYOUT GERAL */
        .management-grid {
            display: grid;
            grid-template-columns: 1fr 1fr;
            gap: 20px;
            margin-bottom: 20px;
        }
        @media (max-width: 800px) { .management-grid { grid-template-columns: 1fr; } }
        
        .action-card {
            background: rgba(0,0,0,0.6);
            border: 2px solid var(--primary);
            border-radius: 10px;
            padding: 25px; /* Mais espaço interno */
            box-shadow: 0 0 10px rgba(0,0,255,0.2);
            display: flex;
            flex-direction: column;
            justify-content: space-between;
        }
        .danger-zone {
            border-color: var(--danger-color);
            box-shadow: 0 0 10px rgba(255,0,0,0.2);
        }

        /* FORMULÁRIO ORGANIZADO */
        .form-group {
            margin-bottom: 15px;
            text-align: center; /* Centraliza labels */
        }
        
        .form-group label {
            display: block; /* Força quebra de linha */
            margin-bottom: 5px;
            color: #ccc;
            font-weight: bold;
            font-size: 0.9rem;
        }

        .neon-input, .neon-textarea {
            width: 100%; /* Ocupa toda largura do container */
            background: #000;
            border: 1px solid var(--primary);
            color: #fff;
            padding: 10px;
            border-radius: 5px;
            text-align: center;
            box-sizing: border-box; /* Garante que padding não estoure a largura */
        }
        .neon-textarea { resize: vertical; text-align: left; }
        
        .danger-zone .neon-input, .danger-zone .neon-textarea {
            border-color: var(--danger-color);
        }

        /* TABELAS */
        .table-neon {
            width: 100%;
            border-collapse: collapse;
            color: #fff;
            margin-top: 10px;
        }
        .table-neon th, .table-neon td {
            padding: 10px;
            border-bottom: 1px solid rgba(255,255,255,0.1);
            text-align: left;
        }
        .table-neon th { color: var(--primary); text-transform: uppercase; font-size: 0.8rem; }
        .tag { padding: 3px 8px; border-radius: 4px; font-size: 0.7rem; font-weight: bold; }
        .tag-convite { background: rgba(0,255,0,0.2); color: #00ff00; }
        .tag-expulsao { background: rgba(255,0,0,0.2); color: #ff4444; }
    </style>
</head>
<body>
    <div class="light-rays"></div>
    <div class="container">
        
        <header class="header-game">
             <h1 style="color: var(--primary); font-family: 'Times New Roman', serif; text-transform: uppercase;">Gestão Militar</h1>
             <p style="text-align: center; color: var(--neon-bright);">Clã: <?= htmlspecialchars($nome_cla) ?></p>
             <div class="btn-group navigation">
                 <a href="../../dashboard.php"><button>Voltar</button></a>
             </div>
        </header>

        <?php if (!empty($_SESSION['msg'])): ?>
            <div class="game-msg-box"><?= htmlspecialchars($_SESSION['msg']) ?></div>
            <?php $_SESSION['msg'] = ''; ?>
        <?php endif; ?>

        <main>
            <div class="management-grid">
                
                <div class="action-card">
                    <h2 class="panel-title"><i class="fas fa-user-plus"></i> Recrutar Soldado</h2>
                    
                    <form action="" method="POST">
                        <div class="form-group">
                            <label>Nome do Personagem:</label>
                            <input type="text" name="nome_personagem" class="neon-input" required placeholder="Ex: Sir Arthur">
                        </div>
                        
                        <button type="submit" name="acao_convidar" class="action-btn-neon" style="width: 100%;">
                            <i class="fas fa-envelope"></i> Enviar Convite
                        </button>
                    </form>
                    
                    <p style="font-size:0.75rem; color:#666; margin-top:15px; text-align: center;">
                        * Sistema verifica automaticamente multicontas.
                    </p>
                </div>

                <?php if ($pode_expulsar): ?>
                <div class="action-card danger-zone">
                    <h2 class="panel-title" style="border-color:var(--danger-color); color:var(--danger-color);">
                        <i class="fas fa-gavel"></i> Expulsão
                    </h2>
                    
                    <form action="" method="POST" onsubmit="return confirm('Confirmar expulsão?');">
                        <div class="form-group">
                            <label style="color:var(--danger-color);">Nome do Personagem:</label>
                            <input type="text" name="nome_expulsar" class="neon-input" required>
                        </div>
                        
                        <div class="form-group">
                            <label style="color:var(--danger-color);">Motivação (Obrigatório):</label>
                            <textarea name="motivacao" class="neon-textarea" rows="3" required placeholder="Motivo da expulsão..."></textarea>
                        </div>
                        
                        <button type="submit" name="acao_expulsar" class="action-btn-neon btn-danger-neon" style="width:100%;">
                            <i class="fas fa-user-times"></i> Expulsar Membro
                        </button>
                    </form>
                </div>
                <?php else: ?>
                    <div class="action-card" style="opacity:0.5; justify-content:center; align-items:center;">
                        <i class="fas fa-lock" style="font-size:2rem;"></i>
                        <p>Acesso restrito ao Comando.</p>
                    </div>
                <?php endif; ?>

            </div>

            <?php if ($pode_ver_historico): ?>
            
            <div class="game-panel" style="margin-bottom: 20px;">
                <h2 class="panel-title">Convites Pendentes</h2>
                <?php if (!empty($convites_pendentes)): ?>
                    <table class="table-neon">
                        <thead><tr><th>Convidado</th><th>Por</th><th>Data</th><th>Ação</th></tr></thead>
                        <tbody>
                            <?php foreach ($convites_pendentes as $c): ?>
                            <tr>
                                <td style="color:var(--neon-bright);"><?= htmlspecialchars($c['convidado']) ?></td>
                                <td><?= htmlspecialchars($c['convidador']) ?></td>
                                <td><?= date('d/m H:i', strtotime($c['data'])) ?></td>
                                <td>
                                    <form action="" method="POST" style="margin:0;">
                                        <input type="hidden" name="cancelar_convite_id" value="<?= $c['id'] ?>">
                                        <button type="submit" style="background:none; border:none; color:var(--danger-color); cursor:pointer;">
                                            <i class="fas fa-times"></i>
                                        </button>
                                    </form>
                                </td>
                            </tr>
                            <?php endforeach; ?>
                        </tbody>
                    </table>
                <?php else: ?>
                    <p style="text-align:center; color:#666; padding:10px;">Nenhum convite pendente.</p>
                <?php endif; ?>
            </div>

            <div class="game-panel">
                <div style="display:flex; justify-content:space-between; align-items:center; margin-bottom:10px;">
                    <h2 class="panel-title" style="margin:0; border:none;">Arquivos do Clã</h2>
                    <form action="" method="GET" style="display:flex;">
                        <input type="text" name="busca" placeholder="Buscar..." value="<?= htmlspecialchars($busca) ?>" style="background:#000; border:1px solid #444; color:#fff; padding:5px;">
                        <button type="submit" style="background:var(--primary); color:#000; border:none; padding:5px 10px;"><i class="fas fa-search"></i></button>
                    </form>
                </div>
                
                <table class="table-neon">
                    <thead><tr><th>Data</th><th>Ação</th><th>Quem</th><th>Alvo</th><th>Detalhes</th></tr></thead>
                    <tbody>
                        <?php if (!empty($historico)): ?>
                            <?php foreach ($historico as $h): 
                                $tag = 'tag';
                                if ($h['acao'] == 'CONVITE') $tag .= ' tag-convite';
                                elseif ($h['acao'] == 'EXPULSAO') $tag .= ' tag-expulsao';
                            ?>
                            <tr>
                                <td style="font-size:0.8rem; color:#aaa;"><?= date('d/m H:i', strtotime($h['data'])) ?></td>
                                <td><span class="<?= $tag ?>"><?= $h['acao'] ?></span></td>
                                <td><?= htmlspecialchars($h['quem_fez']) ?></td>
                                <td style="font-weight:bold;"><?= htmlspecialchars($h['alvo']) ?></td>
                                <td style="font-style:italic; color:#ccc;"><?= htmlspecialchars($h['motivo'] ?? '-') ?></td>
                            </tr>
                            <?php endforeach; ?>
                        <?php else: ?>
                            <tr><td colspan="5" style="text-align:center;">Nenhum registro.</td></tr>
                        <?php endif; ?>
                    </tbody>
                </table>
                
                <?php if ($total_paginas > 1): ?>
                <div style="text-align:center; margin-top:15px;">
                    <?php for($i=1; $i<=$total_paginas; $i++): ?>
                        <a href="?p=<?= $i ?>&busca=<?= urlencode($busca) ?>" style="color:<?= ($i == $pagina) ? 'var(--neon-bright)' : '#666' ?>; margin:0 5px; text-decoration:none;"><?= $i ?></a>
                    <?php endfor; ?>
                </div>
                <?php endif; ?>
            </div>
            <?php endif; ?>

        </main>
        <center><footer class="footer-simple-medieval" style="margin-top:20px;"><p>&copy; 2025 RPG</p></footer></center>
    </div>
</body>
</html>