<?php
session_start();
require '../../conexao.php'; 

// ==========================================================
// 1. SEGURANÇA E DADOS
// ==========================================================
if (!isset($_SESSION['user_id']) || empty($_SESSION['personagem'])) {
    header("Location: ../../login.php");
    exit();
}

$nomePersonagem = $_SESSION['personagem_nome'];

// Busca dados atualizados do usuário
$stmtP = $pdo->prepare("SELECT id, cla, cargo FROM personagens WHERE personagem = :nome LIMIT 1");
$stmtP->execute([':nome' => $nomePersonagem]);
$user_data = $stmtP->fetch(PDO::FETCH_ASSOC);

// Validação de Clã
if (!$user_data || empty($user_data['cla']) || $user_data['cla'] === 'Nenhum') {
    $_SESSION['msg'] = "Você não pertence a um clã.";
    header("Location: ../../dashboard.php");
    exit();
}

// Busca ID do Clã
$stmtC = $pdo->prepare("SELECT id FROM cla WHERE nome = :nome LIMIT 1");
$stmtC->execute([':nome' => $user_data['cla']]);
$cla_data = $stmtC->fetch(PDO::FETCH_ASSOC);

if (!$cla_data) { die("Erro de integridade: Clã não encontrado."); }

$cla_id = $cla_data['id'];
$nome_cla = $user_data['cla'];
$meu_cargo = $user_data['cargo'] ?? 1;

// Nomes dos Cargos
$lista_cargos = [
    1 => 'Guardião da Vanguarda', 
    2 => 'Capitão do Mato', 
    3 => 'Capitão da Vanguarda',
    4 => 'Comandante da Guarda Real', 
    5 => 'Subcomandante', 
    6 => 'Comandante Oficial', 
    7 => '1º Ministro'
];

// Permissões
if ($meu_cargo < 5) {
    $_SESSION['msg'] = "Apenas Subcomandantes (Cargo 5+) podem gerenciar patentes.";
    header("Location: ../../dashboard.php");
    exit();
}

$pode_alterar = $meu_cargo >= 5;
$pode_ver_log = $meu_cargo >= 6; 

// ==========================================================
// 2. LÓGICA DE PROMOÇÃO/REBAIXAMENTO (POST)
// ==========================================================
if ($_SERVER['REQUEST_METHOD'] === 'POST' && isset($_POST['acao_patente'])) {
    
    $alvo_nome = trim($_POST['nome_personagem']);
    $tipo_acao = $_POST['acao_patente']; 
    
    if (empty($alvo_nome)) {
        $_SESSION['msg'] = "Digite o nome do personagem.";
    } else {
        $stmtAlvo = $pdo->prepare("SELECT id, cla, cargo FROM personagens WHERE personagem = :nome LIMIT 1");
        $stmtAlvo->execute([':nome' => $alvo_nome]);
        $alvo_data = $stmtAlvo->fetch(PDO::FETCH_ASSOC);
        
        if (!$alvo_data || $alvo_data['cla'] !== $nome_cla) {
            $_SESSION['msg'] = "O personagem '$alvo_nome' não pertence ao seu clã.";
        } else {
            $cargo_atual_alvo = $alvo_data['cargo'] ?? 1;
            
            // Regra de Hierarquia
            if ($cargo_atual_alvo >= $meu_cargo) {
                $stmtLog = $pdo->prepare("INSERT INTO cla_log_cargos (cla_id, acao, quem_fez, cargo_quem_fez, alvo, cargo_anterior, cargo_novo, data) VALUES (:cid, 'TENTATIVA_ILEGAL', :quem, :mcargo, :alvo, :acargo, :acargo, NOW())");
                $stmtLog->execute([
                    ':cid' => $cla_id, ':quem' => $nomePersonagem, ':mcargo' => $meu_cargo, 
                    ':alvo' => $alvo_nome, ':acargo' => $cargo_atual_alvo
                ]);
                $_SESSION['msg'] = "AÇÃO BLOQUEADA: Tentativa de alterar patente superior registrada.";
            } else {
                
                $novo_cargo = $cargo_atual_alvo;
                $sucesso = false;
                $acao_txt = "";

                if ($tipo_acao === 'promover') {
                    if (($cargo_atual_alvo + 1) >= $meu_cargo) {
                        $_SESSION['msg'] = "Você não pode promover para patente igual ou superior a sua.";
                    } elseif ($cargo_atual_alvo >= 7) {
                        $_SESSION['msg'] = "Patente máxima atingida.";
                    } else {
                        $novo_cargo++;
                        $sucesso = true;
                        $acao_txt = "PROMOCAO";
                    }
                } elseif ($tipo_acao === 'rebaixar') {
                    if ($cargo_atual_alvo <= 1) {
                        $_SESSION['msg'] = "Já está na patente mínima.";
                    } else {
                        $novo_cargo--;
                        $sucesso = true;
                        $acao_txt = "REBAIXAMENTO";
                    }
                }

                if ($sucesso) {
                    $pdo->beginTransaction();
                    try {
                        $stmtUp = $pdo->prepare("UPDATE personagens SET cargo = :ncargo WHERE id = :id");
                        $stmtUp->execute([':ncargo' => $novo_cargo, ':id' => $alvo_data['id']]);
                        
                        $stmtLog = $pdo->prepare("INSERT INTO cla_log_cargos (cla_id, acao, quem_fez, cargo_quem_fez, alvo, cargo_anterior, cargo_novo, data) VALUES (:cid, :acao, :quem, :mcargo, :alvo, :antigo, :novo, NOW())");
                        $stmtLog->execute([
                            ':cid' => $cla_id, ':acao' => $acao_txt, ':quem' => $nomePersonagem, 
                            ':mcargo' => $meu_cargo, ':alvo' => $alvo_nome, 
                            ':antigo' => $cargo_atual_alvo, ':novo' => $novo_cargo
                        ]);
                        
                        $pdo->commit();
                        $nome_novo_cargo = $lista_cargos[$novo_cargo];
                        $_SESSION['msg'] = "Sucesso! $alvo_nome agora é $novo_cargo - $nome_novo_cargo.";
                    } catch (Exception $e) {
                        $pdo->rollBack();
                        $_SESSION['msg'] = "Erro: " . $e->getMessage();
                    }
                }
            }
        }
    }
    header("Location: admcargos_cla.php");
    exit();
}

// ==========================================================
// 3. BUSCAR HISTÓRICO COM PAGINAÇÃO E PESQUISA
// ==========================================================
$historico = [];
$total_paginas = 0;
$pagina = isset($_GET['p']) ? (int)$_GET['p'] : 1;
$busca = isset($_GET['busca']) ? trim($_GET['busca']) : '';
$limite = 10;
$offset = ($pagina - 1) * $limite;

if ($pode_ver_log) {
    // Construção da Query Dinâmica
    $sqlBase = "FROM cla_log_cargos WHERE cla_id = :cid";
    $params = [':cid' => $cla_id];
    
    if (!empty($busca)) {
        // Pesquisa tanto quem fez quanto quem sofreu a ação
        $sqlBase .= " AND (quem_fez LIKE :busca OR alvo LIKE :busca)";
        $params[':busca'] = "%$busca%";
    }
    
    // 1. Contar Total de Registros (para paginação)
    $stmtCount = $pdo->prepare("SELECT COUNT(*) $sqlBase");
    $stmtCount->execute($params);
    $total_registros = $stmtCount->fetchColumn();
    $total_paginas = ceil($total_registros / $limite);
    
    // 2. Buscar Registros Paginados
    // Nota: bindParam é necessário para LIMIT/OFFSET em alguns drivers PDO
    $sqlFinal = "SELECT * $sqlBase ORDER BY data DESC LIMIT :limite OFFSET :offset";
    $stmtHist = $pdo->prepare($sqlFinal);
    
    // Bind manual dos parâmetros
    $stmtHist->bindParam(':cid', $cla_id, PDO::PARAM_INT);
    if (!empty($busca)) {
        $termo = "%$busca%";
        $stmtHist->bindParam(':busca', $termo, PDO::PARAM_STR);
    }
    $stmtHist->bindParam(':limite', $limite, PDO::PARAM_INT);
    $stmtHist->bindParam(':offset', $offset, PDO::PARAM_INT);
    
    $stmtHist->execute();
    $historico = $stmtHist->fetchAll(PDO::FETCH_ASSOC);
}
?>

<!DOCTYPE html>
<html lang="pt-BR">
<head>
    <meta charset="UTF-8">
    <title>Patentes Militares | <?= htmlspecialchars($nome_cla) ?></title>
    <link rel="stylesheet" href="../../css/dashboardmed.css">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css">
    <style>
        .cargo-grid {
            display: grid;
            grid-template-columns: 1fr;
            gap: 20px;
            max-width: 600px;
            margin: 0 auto;
        }

        .action-card {
            background: rgba(0,0,0,0.7);
            border: 2px solid var(--primary);
            border-radius: 10px;
            padding: 25px;
            box-shadow: 0 0 15px rgba(0,0,255,0.15);
        }

        .btn-group-action { display: flex; gap: 10px; margin-top: 15px; }
        .btn-promo { flex: 1; background: #000; border: 2px solid #00ff44; color: #00ff44; padding: 10px; border-radius: 5px; cursor: pointer; font-weight: bold; text-transform: uppercase; transition: 0.3s; }
        .btn-promo:hover { background: #00ff44; color: #000; box-shadow: 0 0 15px #00ff44; }
        .btn-demote { flex: 1; background: #000; border: 2px solid #ff2222; color: #ff2222; padding: 10px; border-radius: 5px; cursor: pointer; font-weight: bold; text-transform: uppercase; transition: 0.3s; }
        .btn-demote:hover { background: #ff2222; color: #fff; box-shadow: 0 0 15px #ff2222; }

        .neon-input { width: 100%; padding: 12px; background: #050510; border: 1px solid var(--primary); color: white; border-radius: 5px; text-align: center; font-size: 1.1rem; box-sizing: border-box; }

        /* Histórico e Pesquisa */
        .log-container { max-width: 900px; margin: 30px auto 0 auto; }
        .log-header {
            display: flex;
            justify-content: space-between;
            align-items: center;
            margin-bottom: 15px;
            border-bottom: 1px solid var(--primary);
            padding-bottom: 10px;
        }
        .search-form { display: flex; gap: 5px; }
        .search-input { background: #000; border: 1px solid #444; color: #fff; padding: 5px 10px; border-radius: 4px; }
        .search-btn { background: var(--primary); border: none; color: #000; padding: 5px 10px; cursor: pointer; border-radius: 4px; }

        .table-neon { width: 100%; border-collapse: collapse; color: #fff; }
        .table-neon th, .table-neon td { padding: 12px; border-bottom: 1px solid rgba(255,255,255,0.1); text-align: left; }
        .table-neon th { color: var(--primary); text-transform: uppercase; font-size: 0.8rem; }
        
        .arrow-up { color: #00ff44; }
        .arrow-down { color: #ff2222; }
        .badge-illegal { background: #ff0000; color: #fff; padding: 2px 5px; border-radius: 3px; font-size: 0.7rem; }
        
        .pagination { text-align: center; margin-top: 15px; }
        .page-link { 
            color: #888; text-decoration: none; margin: 0 5px; padding: 3px 8px; border: 1px solid #333; 
            transition: 0.2s;
        }
        .page-link:hover, .page-link.active { color: var(--neon-bright); border-color: var(--neon-bright); background: rgba(0,0,255,0.1); }
        
        @media (max-width: 768px) {
            .log-header { flex-direction: column; gap: 10px; align-items: stretch; }
            .search-form { width: 100%; display: flex; }
            .search-input { flex-grow: 1; }
        }
    </style>
</head>
<body>
    <div class="light-rays"></div>
    <div class="container">
        
        <header class="header-game">
             <h1 style="color: var(--primary); font-family: 'Times New Roman', serif; text-transform: uppercase;">Patentes Militares</h1>
             <p style="text-align: center; color: var(--neon-bright);">Clã: <?= htmlspecialchars($nome_cla) ?></p>
             <div class="btn-group navigation">
                 <a href="../../dashboard.php"><button>Voltar</button></a>
             </div>
        </header>

        <?php if (!empty($_SESSION['msg'])): ?>
            <div class="game-msg-box"><?= htmlspecialchars($_SESSION['msg']) ?></div>
            <?php $_SESSION['msg'] = ''; ?>
        <?php endif; ?>

        <main>
            
            <div class="cargo-grid">
                <div class="action-card">
                    <h2 class="panel-title" style="text-align: center;"><i class="fas fa-medal"></i> Gerenciar Patentes</h2>
                    <p style="text-align: center; color: #888; font-size: 0.9rem; margin-bottom: 15px;">
                        Limite de Promoção: Cargo <strong><?= $meu_cargo - 1 ?></strong>.
                    </p>

                    <form action="" method="POST">
                        <label style="display: block; margin-bottom: 5px; color: #ccc;">Nome do Soldado:</label>
                        <input type="text" name="nome_personagem" class="neon-input" required placeholder="Digite o nome exato">
                        
                        <div class="btn-group-action">
                            <button type="submit" name="acao_patente" value="promover" class="btn-promo">
                                <i class="fas fa-angle-double-up"></i> Promover
                            </button>
                            <button type="submit" name="acao_patente" value="rebaixar" class="btn-demote">
                                <i class="fas fa-angle-double-down"></i> Rebaixar
                            </button>
                        </div>
                    </form>
                </div>
            </div>

            <?php if ($pode_ver_log): ?>
            <div class="game-panel log-container">
                <center>
                <div class="log-header">
                    <h2 class="panel-title" style="border: none; margin: 0;"><i class="fas fa-history"></i> Histórico de trajetória hierárquica</h2>                    
                    <form action="" method="GET" class="search-form">
                        <input type="text" name="busca" class="search-input" placeholder="Buscar nome..." value="<?= htmlspecialchars($busca) ?>">
                        <button type="submit" class="search-btn"><i class="fas fa-search"></i></button>
                    </form>
                </div>
                </center>

                <?php if (!empty($historico)): ?>
                <table class="table-neon">
                    <thead>
                        <tr>
                            <th>Data</th>
                            <th>Ação</th>
                            <th>Oficial</th>
                            <th>Alvo</th>
                            <th>Alteração</th>
                        </tr>
                    </thead>
                    <tbody>
                        <?php foreach ($historico as $h): 
                            $eh_ilegal = ($h['acao'] === 'TENTATIVA_ILEGAL');
                            $eh_promo = ($h['acao'] === 'PROMOCAO');
                            
                            $icone = $eh_promo ? '<i class="fas fa-arrow-up arrow-up"></i>' : '<i class="fas fa-arrow-down arrow-down"></i>';
                            if ($eh_ilegal) $icone = '<i class="fas fa-ban" style="color:red"></i>';
                            
                            $nome_cargo_antigo = $lista_cargos[$h['cargo_anterior']] ?? $h['cargo_anterior'];
                            $nome_cargo_novo = $lista_cargos[$h['cargo_novo']] ?? $h['cargo_novo'];
                        ?>
                        <tr>
                            <td style="color: #aaa; font-size: 0.85rem;"><?= date('d/m H:i', strtotime($h['data'])) ?></td>
                            <td>
                                <?php if ($eh_ilegal): ?>
                                    <span class="badge-illegal">ILEGAL</span>
                                <?php else: ?>
                                    <?= $h['acao'] ?>
                                <?php endif; ?>
                            </td>
                            <td><?= htmlspecialchars($h['quem_fez']) ?> <small>(C:<?= $h['cargo_quem_fez'] ?>)</small></td>
                            <td style="font-weight: bold; color: #fff;"><?= htmlspecialchars($h['alvo']) ?></td>
                            <td>
                                <?php if ($eh_ilegal): ?>
                                    <span style="color: #666;">Tentou C:<?= $h['cargo_anterior'] ?></span>
                                <?php else: ?>
                                    <span style="color: #888;"><?= $h['cargo_anterior'] ?></span> 
                                    <?= $icone ?> 
                                    <strong style="color: var(--neon-bright);"><?= $h['cargo_novo'] ?></strong>
                                <?php endif; ?>
                            </td>
                        </tr>
                        <?php endforeach; ?>
                    </tbody>
                </table>

                <?php if ($total_paginas > 1): ?>
                <div class="pagination">
                    <?php if ($pagina > 1): ?>
                         <a href="?p=<?= $pagina - 1 ?>&busca=<?= urlencode($busca) ?>" class="page-link">&laquo;</a>
                    <?php endif; ?>

                    <?php for($i=1; $i<=$total_paginas; $i++): ?>
                        <a href="?p=<?= $i ?>&busca=<?= urlencode($busca) ?>" class="page-link <?= ($i == $pagina) ? 'active' : '' ?>">
                            <?= $i ?>
                        </a>
                    <?php endfor; ?>

                    <?php if ($pagina < $total_paginas): ?>
                         <a href="?p=<?= $pagina + 1 ?>&busca=<?= urlencode($busca) ?>" class="page-link">&raquo;</a>
                    <?php endif; ?>
                </div>
                <?php endif; ?>

                <?php else: ?>
                    <p style="text-align: center; color: #666; padding: 20px;">
                        <?php if(!empty($busca)): ?>
                            Nenhum registro encontrado para "<strong><?= htmlspecialchars($busca) ?></strong>".
                        <?php else: ?>
                            Nenhum registro de alteração de patente encontrado.
                        <?php endif; ?>
                    </p>
                <?php endif; ?>
            </div>
            <?php endif; ?>

        </main>
        
        <center><footer class="footer-simple-medieval" style="margin-top:20px;"><p>&copy; 2025 RPG</p></footer></center>
    </div>
</body>
</html>