<?php
session_start();
if ($_SERVER["REQUEST_METHOD"] == "POST") {
    require 'conexao.php';

    // Recebe os dados do formulário de login
    $email = $_POST['email'];
    $senha = $_POST['senha'];

    // Busca o usuário com o email informado no banco de dados
    $stmt = $pdo->prepare("SELECT * FROM usersblock WHERE email = ?");
    $stmt->execute([$email]);

    if ($stmt->rowCount() == 1) {
        $usuario = $stmt->fetch(PDO::FETCH_ASSOC);

        // Verifica se a senha informada coincide com a senha armazenada no banco
        if (password_verify($senha, $usuario['password'])) {
            // Autenticação bem-sucedida, cria a sessão do usuário
            $_SESSION['user_id'] = $usuario['id'];
            $_SESSION['user_name'] = $usuario['user'];
            $_SESSION['user_wallet'] = $usuario['wallet'];
            $_SESSION['user_pin'] = $usuario['pin'];
            $_SESSION['user_altemail'] = $usuario['altemail'];
            $_SESSION['email'] = $email;

            // Redireciona para a página de perfil do usuário
            header('Location: altenticar2.php');
            exit;
        } else {
            // Senha incorreta, redireciona para a página de login com mensagem de erro
            header('Location: login.php?erro=senha_incorreta');
            exit;
        }
    } else {
        // Usuário não encontrado, redireciona para a página de login com mensagem de erro
        header('Location: login.php?erro=email_nao_encontrado');
        exit;
    }
} else {
    // Redireciona para a página de login caso alguém acesse diretamente esse script
    header('Location: login.php');
    exit;
}
?>
