<?php
ob_start();
session_start();
// Ajuste o caminho para o conexao.php se necessário
require '../conexao.php';

// Verificação de login
if (!isset($_SESSION['user_id'])) {
    header("Location: ../login.php");
    exit();
}

// Gerenciamento de token CSRF
if (empty($_SESSION['csrf_token'])) {
    $_SESSION['csrf_token'] = bin2hex(random_bytes(32));
}

// Inicialização
$user_name = $_SESSION['user_name'];
$successMessage = '';
$errorMessage = '';

// --- LÓGICA PHP (Processamento do POST) ---
if ($_SERVER['REQUEST_METHOD'] === 'POST' && isset($_POST['criar_personagem'])) {
    try {
        // Verificação CSRF
        if (!hash_equals($_SESSION['csrf_token'], $_POST['csrf_token'] ?? '')) {
            throw new Exception("Token de segurança inválido!");
        }

        $nome_personagem = trim($_POST['nome_personagem'] ?? '');
        $datahora_atual = date('Y-m-d H:i:s');

        // Validações
        if (strlen($nome_personagem) < 3 || strlen($nome_personagem) > 25) {
            throw new Exception("Nome deve ter entre 3 e 25 caracteres!");
        }

        if (!preg_match('/^[a-zA-Z0-9À-ÿ ]+$/', $nome_personagem)) {
            throw new Exception("Caracteres inválidos no nome!");
        }

        $pdo->beginTransaction();

        // Verificação de nome duplicado COM LOCK
        $stmt = $pdo->prepare("SELECT id FROM personagens WHERE personagem = ? LIMIT 1 FOR UPDATE");
        $stmt->execute([$nome_personagem]);
        if ($stmt->fetch()) {
            throw new Exception("Nome já está em uso!");
        }

        // Obter ficha disponível COM LOCK (Compatível com MySQL antigo)
        $stmt = $pdo->prepare("SELECT id FROM fichaspersonagens WHERE jogador = ? AND situacao = '1' LIMIT 1 FOR UPDATE");
        $stmt->execute([$user_name]);
        $ficha = $stmt->fetch(PDO::FETCH_ASSOC);

        if (!$ficha) {
            throw new Exception("Nenhuma ficha disponível encontrada! Adquira uma no mercado.");
        }

        // Remover ficha usada
        $stmt = $pdo->prepare("DELETE FROM fichaspersonagens WHERE id = ?");
        $stmt->execute([$ficha['id']]);

        // Criar personagem
        $stmt = $pdo->prepare("INSERT INTO personagens (personagem, jogador, datacriacao) VALUES (?, ?, ?)");
        $stmt->execute([$nome_personagem, $user_name, $datahora_atual]);

        $pdo->commit();
        
        // --- ATUALIZAÇÃO AQUI: MENSAGEM COM NOME EM AZUL ---
        // 1. Higienizamos o nome para segurança
        $nome_seguro = htmlspecialchars($nome_personagem);
        // 2. Criamos a mensagem com o HTML do span azul
        $_SESSION['creation_success'] = "Personagem <span class='highlight-neon-blue'>'$nome_seguro'</span> criado com sucesso!";
        
        $_SESSION['last_creation'] = time();
        
        ob_end_clean();
        header("Location: ".$_SERVER['PHP_SELF']);
        exit();

    } catch (Exception $e) {
        $pdo->rollBack();
        error_log("Erro ao criar personagem: " . $e->getMessage());
        if (strpos($e->getMessage(), 'SQLSTATE') !== false) {
             $errorMessage = "Ocorreu um erro interno no banco de dados.";
        } else {
             $errorMessage = $e->getMessage();
        }
    }
}

// Rate limiting
if (isset($_SESSION['last_creation']) && (time() - $_SESSION['last_creation'] < 5)) {
    $errorMessage = "Aguarde 5 segundos entre criações.";
}

// Mensagens pós-redirecionamento
if (isset($_SESSION['creation_success'])) {
    $successMessage = $_SESSION['creation_success'];
    unset($_SESSION['creation_success']);
}

// Contar fichas ATUALIZADO
$stmt = $pdo->prepare("SELECT COUNT(*) as total FROM fichaspersonagens WHERE jogador = ? AND situacao = '1'");
$stmt->execute([$user_name]);
$fichas_disponiveis = $stmt->fetch(PDO::FETCH_ASSOC)['total'];
?>
<!DOCTYPE html>
<html lang="pt-br">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Criar Personagem - Ferro & Fogo</title>
    <link href="https://fonts.googleapis.com/css2?family=Roboto:wght@400;700&display=swap" rel="stylesheet">
    <link rel="stylesheet" href="../css/dashboard.css">
</head>
<body>
    <div class="light-rays"></div>

    <div class="container">
        
        <div class="card" style="margin-top: 30px; margin-bottom: 50px;">
            
            <div class="listing-header-centered">
                <h1 style="color: var(--primary); font-family: 'Times New Roman', serif; text-transform: uppercase; letter-spacing: 2px; text-shadow: var(--text-neon-glow); margin-bottom: 25px; font-size: 2rem;">
                    RPG ERA MEDIEVAL: Ferro & Fogo Pelo Poder
                </h1>
                
                <div class="btn-group btn-container-center" style="margin-bottom: 25px;">
    
                     <div class="btn-group nav-buttons-container">
                     <center>
                        <a href="../admpersonagens.php">
                            <button style="margin:0; padding: 12px 50px; width: auto;">Administração de Fichas & Personagens</button>
                        </a>
                        <br>
                        <a href="../dashboard.php">
                            <button style="margin:0; padding: 12px 50px; width: auto;">Menu Principal</button>
                        </a>
                        </center>
                    </div>
                    
                </div>

                <h2 style="color: white; text-transform: uppercase; letter-spacing: 1px; margin-bottom: 15px;">
                    Criar Personagem
                </h2>

                <p class="listing-intro">
                    Use uma de suas fichas para dar vida a um novo personagem no mundo de Ferro & Fogo.
                </p>
            </div>
            <?php if ($successMessage): ?>
                <div class="message-neon success" style="max-width: 700px; margin: 20px auto;"><?= $successMessage ?></div>
            <?php endif; ?>
            
            <?php if ($errorMessage): ?>
                <div class="message-neon error" style="max-width: 700px; margin: 20px auto;"><?= htmlspecialchars($errorMessage) ?></div>
            <?php endif; ?>

            <div class="fichas-counter" id="contador-fichas">
                Você possui <span class="highlight-neon"><?= $fichas_disponiveis ?></span> ficha(s) disponível(is).
            </div>

            <div class="form-stack-container">
                <form method="POST" id="formPersonagem">
                    <input type="hidden" name="csrf_token" value="<?= $_SESSION['csrf_token'] ?>">
                    
                    <div>
                        <label for="nome_personagem">Nome do Personagem:</label>
                        <input type="text" id="nome_personagem" name="nome_personagem" required pattern="[a-zA-Z0-9À-ÿ ]{3,25}" placeholder="Digite o nome aqui...">
                    </div>
                    
                    <div class="btn-group" style="margin-top: 20px;">
                        <button type="submit" name="criar_personagem">CRIAR PERSONAGEM</button>
                    </div>

                   
                    </form>
            </div>

        </div> <footer class="footer-simple-medieval">
            <div class="footer-content">
                <h4>⚔️ RPG ERA MEDIEVAL: FERRO & FOGO ⚔️</h4>
                <p>&copy; <?php echo date("Y"); ?> Todos os direitos reservados.</p>
            </div>
        </footer>

    </div> <script>
    function atualizarFichas() {
        fetch('atualizar_fichas.php?user=<?= urlencode($user_name) ?>')
            .then(r => r.json())
            .then(data => {
                if (data.success) {
                    document.getElementById('contador-fichas').innerHTML = 
                        `Você possui <span class="highlight-neon">${data.total}</span> ficha(s) disponível(is).`;
                }
            })
            .catch(err => console.error('Erro ao atualizar fichas:', err));
    }
    setInterval(atualizarFichas, 3000);
    document.getElementById('formPersonagem').addEventListener('submit', () => {
        setTimeout(atualizarFichas, 500);
    });
    </script>
</body>
</html>