<!DOCTYPE html>
<html>
<head>
    <title>Cadastro</title>
    <link rel="stylesheet" type="text/css" href="style.css">
    <style>
        .main-container {
            max-width: 500px;
            margin: 0 auto;
            padding: 20px;
            text-align: center;
        }
        
        input[type="number"],
        input[type="text"],
        input[type="email"],
        input[type="password"],
        input[type="date"],
        select {
            width: 90%;
            padding: 10px;
            font-size: 16px;
            margin: 5px 0;
            border-radius: 5px;
            border: 1px solid #ccc;
        }

        .info-box {
            background-color: #f2f2f2;
            padding: 15px;
            border-radius: 8px;
            margin-bottom: 20px;
            font-size: 14px;
            color: #222;
            text-align: left;
        }

        .error { color: red; }
        .success { color: green; }
        
        .btnmenu {
            background-color: #0000FF;
            color: white;
            padding: 10px 20px;
            border: none;
            border-radius: 5px;
            cursor: pointer;
            font-size: 16px;
            margin: 5px;
        }
        
        .checkbox-wrapper {
            display: flex;
            justify-content: center;
            align-items: center;
            gap: 8px;
            font-size: 16px;
            color: #333;
            cursor: pointer;
            margin: 15px 0;
        }

        .checkbox-wrapper input[type="checkbox"] {
            appearance: none;
            width: 18px;
            height: 18px;
            border: 2px solid #0000FF;
            border-radius: 4px;
            background-color: transparent;
            position: relative;
            cursor: pointer;
        }

        .checkbox-wrapper input[type="checkbox"]:checked::before {
            content: "";
            position: absolute;
            top: 3px;
            left: 3px;
            width: 10px;
            height: 10px;
            background-color: #0000FF;
            border-radius: 2px;
        }
    </style>

    <script>
        function validarCPF(cpf) {
            cpf = cpf.replace(/[^\d]+/g, '');
            if (cpf.length !== 11 || /^(\d)\1+$/.test(cpf)) return false;
            let soma = 0;
            for (let i = 0; i < 9; i++) soma += parseInt(cpf.charAt(i)) * (10 - i);
            let resto = (soma * 10) % 11;
            if (resto === 10 || resto === 11) resto = 0;
            if (resto !== parseInt(cpf.charAt(9))) return false;
            soma = 0;
            for (let i = 0; i < 10; i++) soma += parseInt(cpf.charAt(i)) * (11 - i);
            resto = (soma * 10) % 11;
            if (resto === 10 || resto === 11) resto = 0;
            return resto === parseInt(cpf.charAt(10));
        }

        function validarFormulario() {
            // Validar CPF
            const cpf = document.querySelector('input[name="cpf"]').value;
            if (!validarCPF(cpf)) {
                alert("CPF inválido. Verifique e tente novamente.");
                return false;
            }

            // Validar termos
            const termos = document.querySelector('#termos');
            if (!termos.checked) {
                alert("Você deve aceitar os termos e condições para continuar.");
                return false;
            }

            // Validar senhas iguais
            const senha = document.querySelector('input[name="senha"]').value;
            const confirmarSenha = document.querySelector('input[name="confirmar_senha"]').value;
            if (senha !== confirmarSenha) {
                alert("As senhas não coincidem.");
                return false;
            }

            // Validar pins iguais
            const pin = document.querySelector('input[name="pin"]').value;
            const confirmarPin = document.querySelector('input[name="confirmar_pin"]').value;
            if (pin !== confirmarPin) {
                alert("Os PINs não coincidem.");
                return false;
            }

            return true;
        }

        window.addEventListener('DOMContentLoaded', function () {
            // Máscara para CPF
            const cpfInput = document.querySelector('input[name="cpf"]');
            cpfInput.addEventListener('input', function () {
                let v = cpfInput.value.replace(/\D/g, '');
                if (v.length > 11) v = v.slice(0, 11);
                v = v.replace(/(\d{3})(\d)/, '$1.$2');
                v = v.replace(/(\d{3})(\d)/, '$1.$2');
                v = v.replace(/(\d{3})(\d{1,2})$/, '$1-$2');
                cpfInput.value = v;
            });

            // Máscara para telefones
            const zaps = [document.querySelector('input[name="zap1"]'), document.querySelector('input[name="zap2"]')];
            zaps.forEach(function (input) {
                input.addEventListener('input', function () {
                    let v = input.value.replace(/\D/g, '');
                    if (v.length > 11) v = v.slice(0, 11);
                    v = v.replace(/^(\d{2})(\d)/, '($1) $2');
                    v = v.replace(/(\d{5})(\d)/, '$1-$2');
                    input.value = v;
                });
            });
        });
    </script>
</head>

<body>
    <div class="main-container">
        <img class="bn" src="bn.png" alt=""><br><br>
        <div class="titulo">Cadastro</div>

        <?php
        session_start();
        if (isset($_GET['erro'])) {
            $erros = [
                'usuario_email_cadastrado' => 'Usuário ou email já cadastrados.',
                'campos_vazios' => 'Preencha todos os campos obrigatórios.',
                'cpf_invalido' => 'CPF inválido.',
                'senhas_diferentes' => 'As senhas não coincidem.',
                'pins_diferentes' => 'Os PINs não coincidem.',
                'falha_armazenamento' => 'Falha ao armazenar dados. Tente novamente.',
                'erro_bd' => 'Erro no banco de dados. Tente novamente.'
            ];
            echo '<p class="error">' . ($erros[$_GET['erro']] ?? 'Erro desconhecido.') . '</p>';
        } elseif (isset($_GET['cadastrado'])) {
            echo '<p class="success">Usuário cadastrado com sucesso!</p>';
        }
        ?>

        <div class="info-box">
            <strong>Atenção!</strong><br><br>
            Por favor, preencha todas as informações corretamente. Dados inconsistentes ou falsos poderão impedir a recuperação da sua conta.<br><br>
            Conforme as leis brasileiras sobre criptoativos, é possível que tenhamos que declarar movimentações financeiras. Por isso, os dados precisam ser reais e válidos.<br><br>
            O <strong>PIN, senha e frase de recuperação</strong> não poderão ser manualmente alterados no futuro. Guarde essas informações com cuidado!<br><br>
            Aceitar os termos é obrigatório para usar nossa plataforma.
        </div>

        <form action="cadastrar.php" method="POST" onsubmit="return validarFormulario();">
            <input type="text" name="user" placeholder="Nome de usuário" required><br>
            <input type="email" name="email" placeholder="Email" required><br>

            <input type="text" name="cpf" placeholder="CPF (somente números)" maxlength="14" required><br>
            <input type="date" name="nascimento" required><br>

            <select name="genero" required>
                <option value="" disabled selected>Gênero</option>
                <option value="masculino">Masculino</option>
                <option value="feminino">Feminino</option>
                <option value="outro">Outro</option>
            </select><br>

            <input type="text" name="zap1" placeholder="Celular / WhatsApp 1" required><br>
            <input type="text" name="zap2" placeholder="Celular / WhatsApp 2 (opcional)"><br>

            <input type="number" name="pin" placeholder="Código PIN (apenas números)" required><br>
            <input type="number" name="confirmar_pin" placeholder="Confirmar código PIN" required><br>

            <input type="password" name="senha" placeholder="Senha" required><br>
            <input type="password" name="confirmar_senha" placeholder="Confirmar senha" required><br>

            <input type="text" name="frase" placeholder="Frase de recuperação de conta" required><br>

            <div style="text-align: left; width: 90%; margin: 10px auto;">
                <label>Autenticar em 2 fatores?</label>
                <select name="2fatores" style="width: 100%;">
                    <option value="0">Não</option>
                    <option value="1">Sim</option>
                </select>
            </div>

            <div style="text-align: left; width: 90%; margin: 10px auto;">
                <label>Quer receber informações do projeto no WhatsApp/Telegram?</label>
                <select name="informacoeszap" style="width: 100%;">
                    <option value="1">Sim</option>
                    <option value="0">Não</option>
                </select>
            </div>

            <label class="checkbox-wrapper">
                <input type="checkbox" name="termos" id="termos" required>
                Aceito os termos e condições
            </label>

            <div class="button-container">
                <button class="btnmenu" type="submit">Cadastrar</button>
            </div>
        </form>

        <div style="margin-top: 20px;">
            <a href="login.php"><button class="btnmenu">Login</button></a>
            <a href="esquesci.php"><button class="btnmenu">Esqueci a senha</button></a>
        </div>
    </div>
</body>
</html>