<?php
session_start();
require '../conexao.php'; // Inclui o arquivo de conexão

ini_set('display_errors', 1);
ini_set('display_startup_errors', 1);
error_reporting(E_ALL);

// Verifica se o usuário está logado
if (!isset($_SESSION['user_id'])) {
    header("Location: login.php");
    exit();
}

$user_id = $_SESSION['user_id'];
$user_name = $_SESSION['user_name'];

// Função para gerar um hash a partir do hash anterior
function gerarHash($hashAnterior) {
    return hash('sha256', $hashAnterior . uniqid());
}

// Função para gerar um link único de 15 dígitos
function gerarLinkUnico($pdo) {
    do {
        $link = substr(md5(uniqid()), 0, 15);
        $stmt = $pdo->prepare("SELECT COUNT(*) FROM fichaspersonagens WHERE link = ?");
        $stmt->execute([$link]);
    } while ($stmt->fetchColumn() > 0);
    return $link;
}

// Processamento do formulário
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $jogador = trim($_POST['jogador']);
    $quantidade = (int)$_POST['quantidade'];

    // Validação básica
    if (empty($jogador) || $quantidade <= 0) {
        $_SESSION['msg'] = "Por favor, preencha todos os campos corretamente.";
        header("Location: gerar_fichas.php");
        exit();
    }

    // Busca o último hash da tabela
    $stmt = $pdo->query("SELECT hash FROM fichaspersonagens ORDER BY id DESC LIMIT 1");
    $ultimoHash = $stmt->fetchColumn();
    if (!$ultimoHash) {
        $ultimoHash = 'genesis'; // Hash inicial para a primeira ficha
    }

    // Gera as fichas
    try {
        $pdo->beginTransaction();
        for ($i = 0; $i < $quantidade; $i++) {
            $novoHash = gerarHash($ultimoHash);
            $linkUnico = gerarLinkUnico($pdo);

            $stmt = $pdo->prepare("INSERT INTO fichaspersonagens (jogador, quantidade, situacao, descricao, validade, hash, link, responsavel, data) VALUES (?, 1, '1', 'Gerada sistema', 1, ?, ?, ?, NOW())");
            $stmt->execute([$jogador, $novoHash, $linkUnico, $user_name]);

            $ultimoHash = $novoHash;
        }
        $pdo->commit();

        // Calcula o total de fichas do jogador
        $stmt = $pdo->prepare("SELECT COUNT(*) FROM fichaspersonagens WHERE jogador = ?");
        $stmt->execute([$jogador]);
        $totalFichas = $stmt->fetchColumn();

        $_SESSION['msg'] = "{$quantidade} fichas geradas com sucesso para o jogador {$jogador}. Agora ele tem o total de {$totalFichas} fichas.";
        header("Location: gerar_fichas.php");
        exit();
    } catch (PDOException $e) {
        $pdo->rollBack();
        $_SESSION['msg'] = "Erro ao gerar fichas: " . $e->getMessage();
        header("Location: gerar_fichas.php");
        exit();
    }
}
?>

<!DOCTYPE html>
<html lang="pt-BR">
<head>
    <meta charset="UTF-8">
    <title>Gerar Fichas</title>
    <link rel="stylesheet" type="text/css" href="../style.css">
    <script>
        function confirmarGeracao() {
            return confirm("Tem certeza que deseja gerar essas fichas?");
        }
    </script>
</head>
<body>
<i

    <div class="titulo">Gerar Fichas</div>
    <center>
        <?php
        if (isset($_SESSION['msg'])) {
            echo '<p class="mensagem">' . $_SESSION['msg'] . '</p>';
            unset($_SESSION['msg']);
        }
        ?>
    </center>
    <form method="POST" onsubmit="return confirmarGeracao()">
        <input type="text" class="inputpadrao" id="jogador" name="jogador" placeholder="Nome do Jogador" required>
        <br><br>
        <input type="number" class="inputpadrao" id="quantidade" name="quantidade" placeholder="Quantidade de Fichas" required min="1">
        <br><br>
        <button type="submit" class="btn">Gerar Fichas</button>
    </form>
<br>
    <a href="../dashboard.php"><button class="btnmenu">Voltar ao menu principal</button></a>

</body>
</html>