<?php
session_start();
require '../conexao.php';

// Verifica se o usuário está logado
if (!isset($_SESSION['user_id'])) {
    header("Location: login.php");
    exit();
}

$user_id = $_SESSION['user_id'];
$user_name = $_SESSION['user_name'];

// Configurações de paginação
$por_pagina = 10;
$pagina = isset($_GET['pagina']) ? max(1, intval($_GET['pagina'])) : 1;
$offset = ($pagina - 1) * $por_pagina;

// Processar ativação de personagem
if ($_SERVER['REQUEST_METHOD'] === 'POST' && isset($_POST['ativar_personagem'])) {
    $personagem_id = $_POST['personagem_id'];
    
    try {
        $pdo->beginTransaction();
        
        // 1. Desativar todos os personagens do jogador
        $stmt = $pdo->prepare("UPDATE personagens SET ativo = 0, situacao = 0 WHERE jogador = ?");
        $stmt->execute([$user_name]);
        
        // 2. Ativar apenas o personagem selecionado
        $stmt = $pdo->prepare("UPDATE personagens SET ativo = 1, situacao = 'livre' WHERE id = ? AND jogador = ?");
        $stmt->execute([$personagem_id, $user_name]);
        
        $pdo->commit();
        
        echo "<script>
                alert('Personagem ativado com sucesso!');
                window.location.href = window.location.pathname;
              </script>";
        exit();
        
    } catch (Exception $e) {
        $pdo->rollBack();
        echo "<script>alert('Erro: ".addslashes($e->getMessage())."');</script>";
    }
}

// Contar total de personagens
$stmt = $pdo->prepare("SELECT COUNT(*) FROM personagens WHERE jogador = ?");
$stmt->execute([$user_name]);
$total_personagens = $stmt->fetchColumn();

// Listar personagens do jogador com paginação (ativo primeiro)
$sql = "SELECT id, personagem, soldados, ouro, prata, cargo, local, reputacao, atk, def, ativo, situacao 
        FROM personagens 
        WHERE jogador = ? 
        ORDER BY ativo DESC, id DESC 
        LIMIT " . intval($por_pagina) . " OFFSET " . intval($offset);

$stmt = $pdo->prepare($sql);
$stmt->execute([$user_name]);
$personagens = $stmt->fetchAll(PDO::FETCH_ASSOC);

$total_paginas = ceil($total_personagens / $por_pagina);
?>

<!DOCTYPE html>
<html lang="pt-BR">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Gerenciar Personagens</title>
    <link rel="stylesheet" type="text/css" href="../style.css">
    <style>
        :root {
            --azul-vivo: #0000FF;
            --azul-hover: #1E90FF;
            --verde-ativo: #00AA00;
            --vermelho-inativo: #AA0000;
        }
        
        body {
            font-family: 'Segoe UI', Tahoma, Geneva, Verdana, sans-serif;
            background-color: #1a1a1a;
            color: #e0e0e0;
            margin: 0;
            padding: 20px;
        }
        
        .container {
            max-width: 1200px;
            margin: 0 auto;
            background-color: #2a2a2a;
            border-radius: 8px;
            padding: 20px;
            box-shadow: 0 4px 8px rgba(0, 0, 0, 0.3);
        }
        
        h1, h2 {
            color: var(--azul-vivo);
            text-align: center;
        }
        
        .personagem-card {
            background-color: #333;
            border-left: 4px solid;
            border-radius: 4px;
            padding: 15px;
            margin-bottom: 10px;
            transition: all 0.3s;
        }
        
        .personagem-ativo {
            border-left-color: var(--verde-ativo);
        }
        
        .personagem-inativo {
            border-left-color: var(--vermelho-inativo);
        }
        
        .personagem-card:hover {
            transform: translateY(-3px);
            box-shadow: 0 4px 12px rgba(0, 0, 255, 0.2);
        }
        
        .personagem-header {
            display: flex;
            justify-content: space-between;
            align-items: center;
            margin-bottom: 10px;
        }
        
        .personagem-nome {
            font-size: 1.3em;
            font-weight: bold;
        }
        
        .nome-ativo {
            color: var(--verde-ativo);
        }
        
        .nome-inativo {
            color: #e0e0e0;
        }
        
        .personagem-detalhes {
            display: grid;
            grid-template-columns: repeat(auto-fill, minmax(200px, 1fr));
            gap: 10px;
            margin-top: 10px;
        }
        
        .detalhe-item {
            background-color: #444;
            padding: 5px 10px;
            border-radius: 4px;
            font-size: 0.9em;
        }
        
        .btn-ativar {
            background-color: var(--azul-vivo);
            color: white;
            border: none;
            padding: 8px 15px;
            border-radius: 4px;
            cursor: pointer;
            font-weight: bold;
            transition: all 0.3s;
        }
        
        .btn-ativar:hover {
            background-color: var(--azul-hover);
            transform: scale(1.05);
        }
        
        .status-ativo {
            color: var(--verde-ativo);
            font-weight: bold;
        }
        
        .status-inativo {
            color: var(--vermelho-inativo);
        }
        
        .paginacao {
            display: flex;
            justify-content: center;
            margin-top: 20px;
            gap: 5px;
        }
        
        .pagina-link {
            padding: 5px 10px;
            background-color: #333;
            color: #e0e0e0;
            text-decoration: none;
            border-radius: 4px;
            transition: all 0.3s;
        }
        
        .pagina-link:hover, .pagina-ativa {
            background-color: var(--azul-vivo);
            color: white;
        }
        
        .sem-personagens {
            text-align: center;
            padding: 20px;
            background-color: #333;
            border-radius: 4px;
        }
    </style>
</head>
<body>
<center>
<img class="bn" src="../bn.png" alt=""><br><br>
<h1>Ativar personagem</h1>
<a href="../dashboard.php"><button class="btnmenu">Menu principal</button></a><br><br>
<a href="../admpersonagens.php"><button class="btnmenu">Administração de personagens</button></a><br><br>
<a href="../dashboardmed.php"><button class="btnmenu">Jogo</button></a><br><br><br>

<div class="container">
    <?php if (empty($personagens)): ?>
        <div class="sem-personagens">
            <p>Você não possui personagens cadastrados.</p>
        </div>
    <?php else: ?>
        <h2>Seus Personagens (<?= $total_personagens ?> no total)</h2>
        
        <?php foreach ($personagens as $p): 
            $estaAtivo = $p['ativo'] == 1;
        ?>
            <form method="POST" class="personagem-form">
                <input type="hidden" name="personagem_id" value="<?= $p['id'] ?>">
                <div class="personagem-card <?= $estaAtivo ? 'personagem-ativo' : 'personagem-inativo' ?>">
                    <div class="personagem-header">
                        <div class="personagem-nome <?= $estaAtivo ? 'nome-ativo' : 'nome-inativo' ?>">
                            <?= htmlspecialchars($p['personagem']) ?>
                            <span class="<?= $estaAtivo ? 'status-ativo' : 'status-inativo' ?>">
                                (<?= $estaAtivo ? 'ATIVO' : 'inativo' ?>)
                            </span>
                        </div>
                        
                        <?php if (!$estaAtivo): ?>
                            <button type="submit" name="ativar_personagem" class="btn-ativar">
                                Ativar Personagem
                            </button>
                        <?php endif; ?>
                    </div>
                    
                    <div class="personagem-detalhes">
                        <span class="detalhe-item">📍 Local: <?= htmlspecialchars($p['local']) ?></span>
                        <span class="detalhe-item">🛡️ Soldados: <?= $p['soldados'] ?></span>
                        <span class="detalhe-item">💰 Ouro: <?= $p['ouro'] ?></span>
                        <span class="detalhe-item">💍 Prata: <?= $p['prata'] ?></span>
                        <span class="detalhe-item">🎖️ Cargo: <?= $p['cargo'] ? htmlspecialchars($p['cargo']) : 'Nenhum' ?></span>
                        <span class="detalhe-item">⭐ Reputação: <?= $p['reputacao'] ?></span>
                        <span class="detalhe-item">⚔️ Ataque: <?= $p['atk'] ?></span>
                        <span class="detalhe-item">🛡️ Defesa: <?= $p['def'] ?></span>
                    </div>
                </div>
            </form>
        <?php endforeach; ?>
        
        <?php if ($total_paginas > 1): ?>
            <div class="paginacao">
                <?php if ($pagina > 1): ?>
                    <a href="?pagina=<?= $pagina-1 ?>" class="pagina-link">« Anterior</a>
                <?php endif; ?>
                
                <?php 
                $inicio = max(1, $pagina - 2);
                $fim = min($total_paginas, $pagina + 2);
                
                if ($inicio > 1) echo '<span class="pagina-link">...</span>';
                for ($i = $inicio; $i <= $fim; $i++): ?>
                    <a href="?pagina=<?= $i ?>" class="pagina-link <?= $i == $pagina ? 'pagina-ativa' : '' ?>">
                        <?= $i ?>
                    </a>
                <?php endfor;
                if ($fim < $total_paginas) echo '<span class="pagina-link">...</span>';
                ?>
                
                <?php if ($pagina < $total_paginas): ?>
                    <a href="?pagina=<?= $pagina+1 ?>" class="pagina-link">Próxima »</a>
                <?php endif; ?>
            </div>
        <?php endif; ?>
    <?php endif; ?>
</div>
</body>
</html>