<?php
session_start();
require '../../conex/conexao.php';

// 1. Verificação de Segurança
if (!isset($_SESSION['user_id'])) {
    header("Location: login.php");
    exit(); // Faltava o exit aqui
}

// 2. Verifica se a requisição é POST (evita acesso direto pela URL)
if ($_SERVER['REQUEST_METHOD'] == 'POST') {

    // Recupera dados da Sessão
    $personagem = $_SESSION['personagem'] ?? null;
    $carne = $_SESSION['carne'] ?? 0;
    $soldados = $_SESSION['soldados'] ?? 0;
    
    // Verifica se personagem existe
    if (!$personagem) {
        $_SESSION['msg'] = "Erro: Personagem não selecionado.";
        header("Location: ../../dashboardmed.php");
        exit();
    }

    // 3. Regra de Negócio: Capacidade de Carga
    // Se a carne atual for maior ou igual ao número de soldados, não há quem carregue mais.
    if ($carne >= $soldados) {
        $_SESSION['msg'] = "Você não pode pescar! Seus soldados já estão carregando o máximo de carne (1 por soldado).";
        header("Location: ../../dashboardmed.php");
        exit(); 
    }

    // 4. Preparação dos Dados
    $pescando = "pescando"; // Define a situação
    $paralisado = date('Y-m-d H:i:s', strtotime('+1 minutes')); // Tempo de pesca


$fome = $_SESSION['fome'];
    $sede = $_SESSION['sede'];
    
    
    if ($fome <= 30) {
$_SESSION['msg'] = "Seus homens não podem caçar com tanta fome, compre alimentos nas cidades, ou alimente-os de outras formas, urgente.";
header("Location: ../../dashboardmed.php");
    exit; 
}
if ($sede <= 30) {
$_SESSION['msg'] = "Seus homens não podem caçar com tanta sede, leve-os para beber água urgente.";
header("Location: ../../dashboardmed.php");
    exit; 
}
    
    
   $fome = max(0, $fome - 10); 
$sede = max(0, $sede - 10);

    // 5. Atualização no Banco de Dados (PDO Seguro)
    try {
        $sql = "UPDATE personagens SET situacao = :pescando, paralisado = :paralisado, fome = :fome, sede = :sede WHERE id = :personagem";
        $stmt = $pdo->prepare($sql);
        
        $stmt->bindParam(':pescando', $pescando, PDO::PARAM_STR);
        $stmt->bindParam(':paralisado', $paralisado, PDO::PARAM_STR);
        $stmt->bindParam(':personagem', $personagem, PDO::PARAM_INT);
 $stmt->bindParam(':fome', $fome, PDO::PARAM_STR);
 $stmt->bindParam(':sede', $sede, PDO::PARAM_STR);
 
        if ($stmt->execute()) {
            // Sucesso
            $_SESSION['msg'] = "Você e seus soldados iniciaram a pescaria (1 min).";
            
            // Opcional: Registrar no log (se você implementou a tabela de logs)
            // registrarLog($pdo, $_SESSION['user_name'], $personagem, 'TRABALHO', 'Iniciou Pesca', []);

            header("Location: ../../dashboardmed.php");
            exit();
        } else {
            // Erro no SQL
            $_SESSION['msg'] = "Erro ao tentar pescar. Tente novamente.";
            header("Location: ../../dashboardmed.php");
            exit();
        }
    } catch (PDOException $e) {
        $_SESSION['msg'] = "Erro de sistema: " . $e->getMessage();
        header("Location: ../../dashboardmed.php");
        exit();
    }

} else {
    // Se tentar acessar pesca.php direto pela URL sem clicar no botão
    header("Location: ../../dashboardmed.php");
    exit();
}
?>