<?php
session_start();
require '../../conex/conexao.php';

// 1. Verificação de Login
if (!isset($_SESSION['user_id'])) {
    header("Location: login.php");
    exit();
}

// 2. Verifica se o botão correto foi clicado (finalizar_acao)
if (isset($_POST['treinar'])) {

    // Inicializa variáveis
    $personagem = $_SESSION['personagem'];
    $trabalhando = "livre";
    // Define a data como NULL ou vazia para liberar o personagem
    $tempotrabalho = null; 

    // Garante que os valores numéricos existam (evita erro de cálculo)
    $prata = isset($_SESSION['prata']) ? $_SESSION['prata'] : 0;
    $soldados = isset($_SESSION['soldados']) ? $_SESSION['soldados'] : 0;

    // Lógica de Pagamento
    $pgg = "35";
    // Verifica se tem soldados para evitar erro no bcmul
    $qtd_soldados = ($soldados > 0) ? $soldados : 1; 
    
    // Se bcmul não estiver disponível no servidor, usa multiplicação normal
    if (function_exists('bcmul')) {
        $pg = bcmul($pgg, $qtd_soldados); 
    } else {
        $pg = $pgg * $qtd_soldados;
    }

    $nvsaldo = $prata + $pg; 

    // Mensagem de Feedback
    $_SESSION['msg'] = "Trabalho concluído! Você recebeu 35 pratas por soldado. Total: $pg pratas.";

    // 3. Atualização no Banco de Dados
    // Importante: paralisado deve aceitar NULL no banco, ou usamos uma data antiga
    $sql = "UPDATE personagens SET prata = :nvsaldo, situacao = :trabalhando, paralisado = NULL WHERE id = :personagem";
    
    $stmt = $pdo->prepare($sql);
    $stmt->bindParam(':nvsaldo', $nvsaldo, PDO::PARAM_STR);
    $stmt->bindParam(':trabalhando', $trabalhando, PDO::PARAM_STR);
    $stmt->bindParam(':personagem', $personagem, PDO::PARAM_STR);
    
    if ($stmt->execute()) {
        // Atualiza a sessão para refletir o novo saldo imediatamente sem precisar relogar
        $_SESSION['prata'] = $nvsaldo;
        $_SESSION['situacao'] = "livre";
        
        header("Location: ../../dashboardmed.php");
        exit(); 
    } else {
        $_SESSION['msg'] = "Erro ao processar pagamento.";
        header("Location: ../../dashboardmed.php");
        exit();
    }

} else {
    // Se acessou a página sem clicar no botão, volta pro jogo
    header("Location: ../../dashboardmed.php");
    exit();
}
?>