<?php
session_start();
require '../../conex/conexao.php';

// Verifique se o usuário não está logado
if (!isset($_SESSION['user_id'])) {
    header("Location: login.php");
    exit();
}

// CORREÇÃO: O nome do botão no formulário é 'dispensar', não 'vendercarne'
if (isset($_POST['dispensar'])) {
    
    $qnt = (int)$_POST['quantidade']; // Força ser um número inteiro
    $personagem = $_SESSION['personagem'];
    $soldados = $_SESSION['soldados'];

    // 1. Validação básica: Quantidade deve ser maior que zero
    if ($qnt <= 0) {
        $_SESSION['msg'] = "Quantidade inválida.";
        header("Location: ../../dashboardmed.php");
        exit;
    }

    // 2. Verifica se tem soldados suficientes
    if ($qnt > $soldados) {
        $_SESSION['msg'] = "Você não tem $qnt soldado(s) para dispensar. Você tem apenas $soldados.";
        header("Location: ../../dashboardmed.php");
        exit;
    }

    // Realiza o cálculo
    // Se tiver bcmath instalado usa bcsub, senão usa subtração normal
    if (function_exists('bcsub')) {
        $qntfinal = bcsub($soldados, $qnt);
    } else {
        $qntfinal = $soldados - $qnt;
    }

    // Atualiza no Banco de Dados
    $sql = "UPDATE personagens SET soldados = :qntfinal WHERE id = :personagem";
    $stmt = $pdo->prepare($sql);
    
    $stmt->bindParam(':qntfinal', $qntfinal, PDO::PARAM_STR);
    $stmt->bindParam(':personagem', $personagem, PDO::PARAM_STR);
    
    if ($stmt->execute()) {
        // Atualiza a sessão para refletir na hora sem precisar relogar
        $_SESSION['soldados'] = $qntfinal;
        
        $_SESSION['msg'] = "Você dispensou $qnt soldado(s). Agora possui $qntfinal.";
        
        // Opcional: Registrar no histórico de ações do personagem
        // $sqlLog = "INSERT INTO acoespersonagens (personagem, acao, dataehora, tipoacao) VALUES (:nome, :acao, NOW(), 'dispensa')";
        // $stmtLog = $pdo->prepare($sqlLog);
        // $acaoTexto = "Dispensou $qnt soldados";
        // $stmtLog->execute([':nome' => $_SESSION['personagem_nome'], ':acao' => $acaoTexto]);

        header("Location: ../../dashboardmed.php");
        exit;
    } else {
        $_SESSION['msg'] = "Erro no banco de dados ao dispensar soldados.";
        header("Location: ../../dashboardmed.php");
        exit;
    }

} else {
    // Se acessou a página sem clicar no botão, volta pro jogo
    header("Location: ../../dashboardmed.php");
    exit;
}
?>