<?php
// config_seguranca.php

// 1. BLINDAGEM DE SESSÃO
// Impede que JavaScript leia o cookie da sessão (Mitiga XSS roubando sessão)
ini_set('session.cookie_httponly', 1);
// Força o uso apenas de cookies (não permite ID na URL)
ini_set('session.use_only_cookies', 1);

// Se estiver usando HTTPS (OBRIGATÓRIO para sistemas financeiros), descomente a linha abaixo:
// ini_set('session.cookie_secure', 1);

if (session_status() === PHP_SESSION_NONE) {
    session_start();
}

// 2. CABEÇALHOS DE SEGURANÇA (HEADERS)
// Protege contra clickjacking e injeção de conteúdo
header("X-Frame-Options: DENY");
header("X-Content-Type-Options: nosniff");
header("Content-Security-Policy: default-src 'self' 'unsafe-inline' 'unsafe-eval' https://fonts.googleapis.com https://cdnjs.cloudflare.com; img-src 'self' data:;");

// 3. GERADOR DE TOKEN CSRF
if (empty($_SESSION['csrf_token'])) {
    $_SESSION['csrf_token'] = bin2hex(random_bytes(32));
}

// 4. FUNÇÃO DE VERIFICAÇÃO (Usada nos processadores)
function verificarTokenCSRF() {
    if ($_SERVER['REQUEST_METHOD'] === 'POST') {
        if (!isset($_POST['csrf_token']) || !hash_equals($_SESSION['csrf_token'], $_POST['csrf_token'])) {
            // Mata a execução silenciosamente ou mostra erro genérico
            die("Erro de Segurança: Token de sessão inválido ou expirado. Recarregue a página.");
        }
    }
}
?>