<?php
session_start();
require '../../conexao.php'; 

// ==========================================================
// 1. SEGURANÇA E DADOS DO USUÁRIO
// ==========================================================
if (!isset($_SESSION['user_id']) || empty($_SESSION['personagem'])) {
    header("Location: ../../login.php");
    exit();
}

$nomePersonagem = $_SESSION['personagem_nome'];

// Busca dados atualizados do usuário (Cargo e Clã)
$stmtP = $pdo->prepare("SELECT id, cla, cargo FROM personagens WHERE personagem = :nome LIMIT 1");
$stmtP->execute([':nome' => $nomePersonagem]);
$user_data = $stmtP->fetch(PDO::FETCH_ASSOC);

// Validação
if (!$user_data || empty($user_data['cla']) || $user_data['cla'] === 'Nenhum') {
    $_SESSION['msg'] = "Você não pertence a um clã.";
    header("Location: ../../dashboard.php");
    exit();
}

$nome_cla = trim($user_data['cla']);
// Forçamos o cargo a ser Inteiro (int) para garantir que a matemática de maior/menor funcione
$meu_cargo = isset($user_data['cargo']) ? (int)$user_data['cargo'] : 1;

// Busca ID do Clã (para validar integridade)
$stmtC = $pdo->prepare("SELECT id FROM cla WHERE nome = :nome LIMIT 1");
$stmtC->execute([':nome' => $nome_cla]);
$cla_data = $stmtC->fetch(PDO::FETCH_ASSOC);

if (!$cla_data) { die("Erro Crítico: Clã não encontrado no banco."); }
$cla_id = $cla_data['id'];

// Mapeamento de Cargos
$lista_cargos = [
    1 => 'Guardião da Vanguarda', 2 => 'Capitão do Mato', 3 => 'Capitão da Vanguarda',
    4 => 'Comandante da Guarda Real', 5 => 'Subcomandante', 6 => 'Comandante Oficial', 
    7 => '1º Ministro'
];

// ==========================================================
// 2. BUSCA E PAGINAÇÃO DE MEMBROS
// ==========================================================
$busca = isset($_GET['busca']) ? trim($_GET['busca']) : '';
$pagina = isset($_GET['p']) ? (int)$_GET['p'] : 1;
if ($pagina < 1) $pagina = 1;
$limite = 20;
$offset = ($pagina - 1) * $limite;

// Query Base
$sqlWhere = "WHERE cla = :nome_cla";
$params = [':nome_cla' => $nome_cla];

if (!empty($busca)) {
    $sqlWhere .= " AND personagem LIKE :busca";
    $params[':busca'] = "%$busca%";
}

// 1. Contar Total
$stmtCount = $pdo->prepare("SELECT COUNT(*) FROM personagens $sqlWhere");
$stmtCount->execute($params);
$total_registros = $stmtCount->fetchColumn();
$total_paginas = ceil($total_registros / $limite);

// 2. Buscar Membros (Ordenados por Cargo DESC)
$sqlFinal = "SELECT id, personagem, local, reputacao, cargo 
             FROM personagens 
             $sqlWhere 
             ORDER BY cargo DESC, personagem ASC 
             LIMIT :limite OFFSET :offset";

$stmtLista = $pdo->prepare($sqlFinal);

// Bind manual para LIMIT/OFFSET
$stmtLista->bindParam(':nome_cla', $nome_cla, PDO::PARAM_STR);
if (!empty($busca)) {
    $termo = "%$busca%";
    $stmtLista->bindParam(':busca', $termo, PDO::PARAM_STR);
}
$stmtLista->bindParam(':limite', $limite, PDO::PARAM_INT);
$stmtLista->bindParam(':offset', $offset, PDO::PARAM_INT);
$stmtLista->execute();
$membros = $stmtLista->fetchAll(PDO::FETCH_ASSOC);

?>

<!DOCTYPE html>
<html lang="pt-BR">
<head>
    <meta charset="UTF-8">
    <title>Lista de Membros | <?= htmlspecialchars($nome_cla) ?></title>
    <link rel="stylesheet" href="../../css/dashboardmed.css">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css">
    <style>
        .page-container {
            max-width: 1200px;
            margin: 0 auto;
        }
        
        /* Barra de Ferramentas */
        .toolbar {
            display: flex;
            justify-content: space-between;
            align-items: center;
            margin-bottom: 20px;
            background: rgba(0,0,0,0.6);
            padding: 15px;
            border-radius: 8px;
            border: 1px solid var(--primary);
        }
        
        .search-box { display: flex; gap: 5px; }
        .search-input { 
            background: #000; border: 1px solid #555; color: #fff; padding: 8px; border-radius: 4px; 
            width: 250px;
        }
        
        /* Tabela */
        .table-container {
            overflow-x: auto;
            background: rgba(0,0,0,0.8);
            border: 2px solid var(--primary);
            border-radius: 10px;
            box-shadow: 0 0 15px rgba(0,0,255,0.1);
        }
        
        .table-neon {
            width: 100%;
            border-collapse: collapse;
            white-space: nowrap;
        }
        
        .table-neon th {
            background: rgba(0, 0, 255, 0.1);
            color: var(--primary);
            padding: 15px;
            text-align: left;
            text-transform: uppercase;
            font-size: 0.85rem;
            border-bottom: 2px solid var(--primary);
        }
        
        .table-neon td {
            padding: 12px 15px;
            border-bottom: 1px solid rgba(255,255,255,0.1);
            color: #ddd;
            vertical-align: middle;
        }
        
        .table-neon tr:hover {
            background: rgba(255,255,255,0.05);
        }
        
        /* Badges de Cargo */
        .badge-cargo {
            padding: 4px 8px;
            border-radius: 4px;
            font-weight: bold;
            font-size: 0.8rem;
            background: #333;
            border: 1px solid #555;
        }
        .badge-cargo.high-rank { /* Cargos 6 e 7 */
            background: rgba(255, 215, 0, 0.2);
            border-color: #ffd700;
            color: #ffd700;
        }
        
        /* Botões de Ação Pequenos */
        .btn-action {
            padding: 5px 10px;
            border-radius: 4px;
            cursor: pointer;
            border: 1px solid transparent;
            font-weight: bold;
            font-size: 0.75rem;
            margin-right: 3px;
            text-transform: uppercase;
            transition: 0.2s;
            background: #000;
        }
        
        .btn-promo { border-color: #00ff44; color: #00ff44; }
        .btn-promo:hover { background: #00ff44; color: #000; }
        
        .btn-demote { border-color: #ffaa00; color: #ffaa00; }
        .btn-demote:hover { background: #ffaa00; color: #000; }
        
        .btn-kick { border-color: #ff2222; color: #ff2222; }
        .btn-kick:hover { background: #ff2222; color: #fff; }
        
        .btn-disabled { opacity: 0.2; cursor: not-allowed; border-color: #444; color: #444; }

        /* Paginação */
        .pagination { text-align: center; margin-top: 20px; }
        .page-link { 
            color: #888; text-decoration: none; margin: 0 5px; padding: 5px 10px; border: 1px solid #333; 
            transition: 0.2s; display: inline-block;
        }
        .page-link:hover, .page-link.active { 
            color: var(--neon-bright); border-color: var(--neon-bright); background: rgba(0,0,255,0.1); 
        }
        
        @media (max-width: 800px) {
            .toolbar { flex-direction: column; gap: 10px; align-items: stretch; }
            .search-input { width: 100%; }
            .table-container { overflow-x: scroll; }
        }
    </style>
    
    <script>
        function confirmarExpulsao(nome, formId) {
            const motivo = prompt("ATENÇÃO: Você está prestes a expulsar " + nome + ".\nEsta ação será registrada.\n\nDigite o motivo:");
            if (motivo !== null && motivo.trim() !== "") {
                document.getElementById('motivo_' + formId).value = motivo;
                document.getElementById('form_expulsar_' + formId).submit();
            } else if (motivo !== null) {
                alert("A expulsão requer um motivo.");
            }
        }
    </script>
</head>
<body>
    <div class="light-rays"></div>
    <div class="container page-container">
        
        <header class="header-game">
             <h1 style="color: var(--primary); font-family: 'Times New Roman', serif; text-transform: uppercase;">Membros do Clã</h1>
             <p style="text-align: center; color: var(--neon-bright);">Clã: <?= htmlspecialchars($nome_cla) ?> | Seu Cargo: <?= $meu_cargo ?></p>
             <div class="btn-group navigation">
                 <a href="../../dashboard.php"><button>Voltar</button></a>
             </div>
        </header>

        <div class="toolbar">
            <div style="color: #ccc; font-weight: bold;">
                Membros: <span style="color: var(--neon-bright);"><?= $total_registros ?></span>
            </div>
            
            <form action="" method="GET" class="search-box">
                <input type="text" name="busca" class="search-input" placeholder="Buscar por nome..." value="<?= htmlspecialchars($busca) ?>">
                <button type="submit" class="action-btn-neon" style="padding: 8px 15px;"><i class="fas fa-search"></i></button>
            </form>
        </div>

        <div class="table-container">
            <table class="table-neon">
                <thead>
                    <tr>
                        <th style="width: 50px;">ID</th>
                        <th>Personagem</th>
                        <th>Cargo</th>
                        <th>Local</th>
                        <th>Reputação</th>
                        <th style="text-align: center;">Ações</th>
                    </tr>
                </thead>
                <tbody>
                    <?php if (!empty($membros)): ?>
                        <?php foreach ($membros as $m): 
                            $cargo_alvo = isset($m['cargo']) ? (int)$m['cargo'] : 1;
                            $nome_cargo = $lista_cargos[$cargo_alvo] ?? 'Desconhecido';
                            $classe_badge = ($cargo_alvo >= 6) ? 'high-rank' : '';
                            
                            // ==========================================================
                            // LÓGICA DE PERMISSÕES CORRIGIDA
                            // ==========================================================
                            $eh_voce = ($m['personagem'] === $nomePersonagem);
                            
                            // --- REGRA DE PROMOVER ---
                            // Cargo 5+: Pode promover.
                            // Alvo: Deve ter cargo que, ao somar +1, ainda seja menor que o meu.
                            // Exemplo: Eu sou 5. Alvo é 3. (3+1) = 4. 4 < 5. OK.
                            // Exemplo: Eu sou 5. Alvo é 4. (4+1) = 5. 5 < 5 (Falso). Não pode promover 4 para 5.
                            $pode_promover = ($meu_cargo >= 5) && ($cargo_alvo + 1 < $meu_cargo) && !$eh_voce;
                            
                            // --- REGRA DE REBAIXAR ---
                            // Cargo 6+: Pode rebaixar.
                            // Alvo: Deve ter cargo menor que o meu. E cargo > 1.
                            // Exemplo: Eu sou 6. Alvo é 5. 5 < 6. OK.
                            $pode_rebaixar = ($meu_cargo >= 6) && ($cargo_alvo < $meu_cargo) && !$eh_voce && ($cargo_alvo > 1);
                            
                            // --- REGRA DE EXPULSAR ---
                            // Cargo 7: Pode expulsar.
                            // Alvo: Deve ter cargo menor que o meu.
                            $pode_expulsar = ($meu_cargo >= 7) && ($cargo_alvo < $meu_cargo) && !$eh_voce;
                        ?>
                        <tr>
                            <td style="color: #666; font-family: monospace;">#<?= $m['id'] ?></td>
                            
                            <td style="font-weight: bold; font-size: 1.05rem;">
                                <?= htmlspecialchars($m['personagem']) ?>
                                <?php if($eh_voce): ?> <span style="color: #00ff44; font-size: 0.7rem;">(Você)</span><?php endif; ?>
                            </td>
                            
                            <td>
                                <span class="badge-cargo <?= $classe_badge ?>">
                                    <?= $cargo_alvo ?> - <?= $nome_cargo ?>
                                </span>
                            </td>
                            
                            <td><?= htmlspecialchars($m['local']) ?></td>
                            
                            <td style="color: #ffd700;"><?= $m['reputacao'] ?></td>
                            
                            <td style="text-align: center;">
                                <div style="display: flex; justify-content: center; gap: 5px;">
                                    
                                    <?php if ($pode_promover): ?>
                                        <form action="admcargos_cla.php" method="POST" style="margin:0;">
                                            <input type="hidden" name="nome_personagem" value="<?= $m['personagem'] ?>">
                                            <button type="submit" name="acao_patente" value="promover" class="btn-action btn-promo" title="Promover">
                                                <i class="fas fa-angle-double-up"></i>
                                            </button>
                                        </form>
                                    <?php else: ?>
                                        <button class="btn-action btn-disabled" disabled><i class="fas fa-angle-double-up"></i></button>
                                    <?php endif; ?>

                                    <?php if ($pode_rebaixar): ?>
                                        <form action="admcargos_cla.php" method="POST" style="margin:0;">
                                            <input type="hidden" name="nome_personagem" value="<?= $m['personagem'] ?>">
                                            <button type="submit" name="acao_patente" value="rebaixar" class="btn-action btn-demote" title="Rebaixar">
                                                <i class="fas fa-angle-double-down"></i>
                                            </button>
                                        </form>
                                    <?php else: ?>
                                        <button class="btn-action btn-disabled" disabled><i class="fas fa-angle-double-down"></i></button>
                                    <?php endif; ?>

                                    <?php if ($pode_expulsar): ?>
                                        <form id="form_expulsar_<?= $m['id'] ?>" action="membros_cla.php" method="POST" style="margin:0;">
                                            <input type="hidden" name="nome_expulsar" value="<?= $m['personagem'] ?>">
                                            <input type="hidden" name="motivacao" id="motivo_<?= $m['id'] ?>" value="">
                                            <input type="hidden" name="acao_expulsar" value="1">
                                            
                                            <button type="button" onclick="confirmarExpulsao('<?= $m['personagem'] ?>', <?= $m['id'] ?>)" class="btn-action btn-kick" title="Expulsar">
                                                <i class="fas fa-times"></i>
                                            </button>
                                        </form>
                                    <?php else: ?>
                                        <button class="btn-action btn-disabled" disabled><i class="fas fa-times"></i></button>
                                    <?php endif; ?>
                                </div>
                            </td>
                        </tr>
                        <?php endforeach; ?>
                    <?php else: ?>
                        <tr>
                            <td colspan="6" style="text-align: center; padding: 30px; color: #666;">
                                Nenhum membro encontrado.
                            </td>
                        </tr>
                    <?php endif; ?>
                </tbody>
            </table>
        </div>

        <?php if ($total_paginas > 1): ?>
        <div class="pagination">
            <?php if ($pagina > 1): ?>
                 <a href="?p=<?= $pagina - 1 ?>&busca=<?= urlencode($busca) ?>" class="page-link">&laquo;</a>
            <?php endif; ?>

            <?php for($i=1; $i<=$total_paginas; $i++): ?>
                <a href="?p=<?= $i ?>&busca=<?= urlencode($busca) ?>" class="page-link <?= ($i == $pagina) ? 'active' : '' ?>">
                    <?= $i ?>
                </a>
            <?php endfor; ?>

            <?php if ($pagina < $total_paginas): ?>
                 <a href="?p=<?= $pagina + 1 ?>&busca=<?= urlencode($busca) ?>" class="page-link">&raquo;</a>
            <?php endif; ?>
        </div>
        <?php endif; ?>

        <center><footer class="footer-simple-medieval" style="margin-top:20px;"><p>&copy; 2025 RPG</p></footer></center>
    </div>
</body>
</html>