<?php
ini_set('display_errors', 1);
ini_set('display_startup_errors', 1);
error_reporting(E_ALL);

session_start();

// Verifica se o formulário foi submetido
if ($_SERVER['REQUEST_METHOD'] !== 'POST') {
    // Se tentar acessar direto, manda de volta com erro genérico ou específico
    header('Location: cadastro.php?erro=campos_vazios');
    exit;
}

require_once 'conexao.php';

// Função para gerar a carteira
function gerarCarteira() {
    $caracteres = '0123456789abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ';
    $tamanho = strlen($caracteres);
    $carteira = '';
    
    for ($i = 0; $i < 50; $i++) {
        try {
            $carteira .= $caracteres[random_int(0, $tamanho - 1)];
        } catch (Exception $e) {
            $carteira .= $caracteres[rand(0, $tamanho - 1)];
        }
    }
    
    return $carteira;
}

try {
    // 1. Verificar campos obrigatórios
    $required_fields = [
        'user', 'email', 'cpf', 'nascimento', 'genero', 'zap1', 
        'pin', 'confirmar_pin', 'senha', 'confirmar_senha', 'frase'
    ];

    foreach ($required_fields as $field) {
        if (empty($_POST[$field])) {
            // Envia o código que seu HTML espera
            throw new Exception('campos_vazios');
        }
    }

    // 2. Obter e sanitizar dados
    $user = trim($_POST['user']);
    $email = filter_var(trim($_POST['email']), FILTER_SANITIZE_EMAIL);
    $cpf = preg_replace('/[^0-9]/', '', $_POST['cpf']);
    $nascimento = $_POST['nascimento'];
    $genero = $_POST['genero'];
    $zap1 = preg_replace('/[^0-9]/', '', $_POST['zap1']);
    $zap2 = !empty($_POST['zap2']) ? preg_replace('/[^0-9]/', '', $_POST['zap2']) : null;
    $pin = $_POST['pin'];
    $confirmar_pin = $_POST['confirmar_pin'];
    $senha = $_POST['senha'];
    $confirmar_senha = $_POST['confirmar_senha'];
    $frase = trim($_POST['frase']);
    
    // CORREÇÃO: Captura o valor real do select (0 ou 1) convertendo para inteiro
    $fatores2 = isset($_POST['2fatores']) ? (int)$_POST['2fatores'] : 0;
    $infozap = isset($_POST['informacoeszap']) ? (int)$_POST['informacoeszap'] : 0;

    // 3. Validações Específicas (Enviando as chaves corretas para o HTML)

    // Validação de PIN
    if ($pin !== $confirmar_pin) {
        throw new Exception('pins_diferentes');
    }

    // Validação de Senha
    if ($senha !== $confirmar_senha) {
        throw new Exception('senhas_diferentes');
    }

    // Validação de Email
    if (!filter_var($email, FILTER_VALIDATE_EMAIL)) {
        // Como não tem 'email_invalido' no seu array, usamos campos_vazios ou criamos um novo
        throw new Exception('campos_vazios');
    }

    // 4. Verificar se usuário/email já existem no banco
    $stmt = $pdo->prepare("SELECT id FROM usersblock WHERE user = ? OR email = ?");
    $stmt->execute([$user, $email]);
    
    if ($stmt->rowCount() > 0) {
        throw new Exception('usuario_email_cadastrado');
    }

    // 5. Gerar hashes de segurança
    $senha_hash = password_hash($senha, PASSWORD_BCRYPT);
    $pin_hash = password_hash($pin, PASSWORD_BCRYPT);
    $frase_hash = password_hash($frase, PASSWORD_BCRYPT);

    if ($senha_hash === false || $pin_hash === false || $frase_hash === false) {
        throw new Exception('falha_armazenamento');
    }

    // 6. Gerar carteira
    $wallet = gerarCarteira();

    // 7. Inserir no banco de dados
    $sql = "INSERT INTO usersblock 
            (user, email, cpf, nascimento, genero, zap1, zap2, pin, password, words, wallet, doisfatores, informacoeszap) 
            VALUES 
            (:user, :email, :cpf, :nascimento, :genero, :zap1, :zap2, :pin, :password, :words, :wallet, :doisfatores, :informacoeszap)";

    $stmt = $pdo->prepare($sql);
    $stmt->execute([
        ':user' => $user,
        ':email' => $email,
        ':cpf' => $cpf,
        ':nascimento' => $nascimento,
        ':genero' => $genero,
        ':zap1' => $zap1,
        ':zap2' => $zap2,
        ':pin' => $pin_hash,
        ':password' => $senha_hash,
        ':words' => $frase_hash,
        ':wallet' => $wallet,
        ':doisfatores' => $fatores2,
        ':informacoeszap' => $infozap
    ]);

    // Sucesso!
    header('Location: cadastro.php?cadastrado=1');
    exit;

} catch (PDOException $e) {
    // Erro de Banco de Dados
    error_log("Erro de banco de dados: " . $e->getMessage());
    header('Location: cadastro.php?erro=erro_bd');
    exit;

} catch (Exception $e) {
    // Erros de Validação (captura a mensagem exata que definimos no throw)
    error_log("Erro no cadastro: " . $e->getMessage());
    header('Location: cadastro.php?erro=' . urlencode($e->getMessage()));
    exit;
}
?>