<?php
// ativar_personagem.php (BLINDADO COM LOG ESPECÍFICO)

// 1. SEGURANÇA E CONEXÃO
require '../conexao.php';
require '../config_seguranca.php';

// 2. VERIFICAÇÃO DE LOGIN
if (!isset($_SESSION['user_id'])) {
    header("Location: ../login.php");
    exit();
}

$user_id = $_SESSION['user_id'];
$user_name = $_SESSION['user_name'];
$csrf_token = $_SESSION['csrf_token'];

// Captura mensagens de feedback
$mensagem_sucesso = "";
$mensagem_erro = "";

if (isset($_SESSION['msg_sucesso'])) {
    $mensagem_sucesso = $_SESSION['msg_sucesso'];
    unset($_SESSION['msg_sucesso']);
}
if (isset($_SESSION['msg_erro'])) {
    $mensagem_erro = $_SESSION['msg_erro'];
    unset($_SESSION['msg_erro']);
}

// Configurações de paginação
$por_pagina = 10;
$pagina = filter_input(INPUT_GET, 'pagina', FILTER_VALIDATE_INT);
$pagina = $pagina ? max(1, $pagina) : 1;
$offset = ($pagina - 1) * $por_pagina;

// --- PROCESSAMENTO DA ATIVAÇÃO ---
if ($_SERVER['REQUEST_METHOD'] === 'POST' && isset($_POST['ativar_personagem'])) {
    
    verificarTokenCSRF();

    $personagem_id = filter_input(INPUT_POST, 'personagem_id', FILTER_VALIDATE_INT);
    
    if ($personagem_id) {
        try {
            $pdo->beginTransaction();
            
            // A. Verificar propriedade e PEGAR O NOME DO PERSONAGEM (Necessário para o log)
            $stmtCheck = $pdo->prepare("SELECT id, personagem FROM personagens WHERE id = ? AND jogador = ?");
            $stmtCheck->execute([$personagem_id, $user_name]);
            $dados_personagem = $stmtCheck->fetch(PDO::FETCH_ASSOC);
            
            if (!$dados_personagem) {
                throw new Exception("Personagem não encontrado ou não pertence a você.");
            }

            // B. Desativar todos
            $stmt = $pdo->prepare("UPDATE personagens SET ativo = 0, situacao = '0' WHERE jogador = ?");
            $stmt->execute([$user_name]);
            
            // C. Ativar o selecionado
            $stmt = $pdo->prepare("UPDATE personagens SET ativo = 1, situacao = '1' WHERE id = ?");
            $stmt->execute([$personagem_id]);
            
            // --- D. LOG NO INFOSSISTEMA (Conforme solicitado) ---
            
            // 1. Buscar Wallet (Apenas para preencher a coluna p1 de referência técnica)
            $stmtW = $pdo->prepare("SELECT wallet FROM usersblock WHERE user = ? LIMIT 1");
            $stmtW->execute([$user_name]);
            $wallet_user = $stmtW->fetchColumn();

            // 2. Montar Texto Exato Solicitado
            $data_formatada = date('d/m/Y H:i:s');
            $nome_do_personagem = $dados_personagem['personagem'];
            
            // "usuario $name ativou o personagem $nomepersonagem e a data"
            $log_info = "Usuario $user_name ativou o personagem $nome_do_personagem em $data_formatada";

            $stmtLog = $pdo->prepare("INSERT INTO infossistema (informacao, p1, p2, origem, dataehora) VALUES (?, ?, ?, 'Ativação', NOW())");
            // P1 = Wallet (para consistência técnica), P2 = ID do Personagem
            $stmtLog->execute([$log_info, $wallet_user, $personagem_id]);

            // --- FIM DO LOG ---

            $pdo->commit();
            
            $_SESSION['msg_sucesso'] = "Personagem ativado com sucesso!";
            header("Location: " . $_SERVER['PHP_SELF'] . "?pagina=" . $pagina);
            exit();
            
        } catch (Exception $e) {
            if ($pdo->inTransaction()) $pdo->rollBack();
            $_SESSION['msg_erro'] = "Erro ao ativar: " . $e->getMessage();
            header("Location: " . $_SERVER['PHP_SELF'] . "?pagina=" . $pagina);
            exit();
        }
    }
}

// --- CONSULTAS DE LEITURA ---

// Contar total
$stmt = $pdo->prepare("SELECT COUNT(*) FROM personagens WHERE jogador = :jogador");
$stmt->execute([':jogador' => $user_name]);
$total_personagens = $stmt->fetchColumn();

// Listar personagens
$sql = "SELECT id, personagem, soldados, ouro, prata, cargo, local, reputacao, atk, def, ativo, situacao 
        FROM personagens 
        WHERE jogador = :jogador 
        ORDER BY ativo DESC, id DESC 
        LIMIT :limit OFFSET :offset";

$stmt = $pdo->prepare($sql);
$stmt->bindValue(':jogador', $user_name);
$stmt->bindValue(':limit', $por_pagina, PDO::PARAM_INT);
$stmt->bindValue(':offset', $offset, PDO::PARAM_INT);
$stmt->execute();
$personagens = $stmt->fetchAll(PDO::FETCH_ASSOC);

$total_paginas = ceil($total_personagens / $por_pagina);
?>

<!DOCTYPE html>
<html lang="pt-br">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Gerenciar Personagens - Ferro & Fogo</title>
    <link href="https://fonts.googleapis.com/css2?family=Roboto:wght@400;700&display=swap" rel="stylesheet">
    <link rel="stylesheet" href="../css/dashboard.css">
</head>
<body>
    <div class="light-rays"></div>

    <div class="container"> 
        
        <div class="card" style="margin-top: 30px; margin-bottom: 50px;">
            
            <div class="listing-header-centered">
                <h1 style="color: var(--primary); font-family: 'Times New Roman', serif; text-transform: uppercase; letter-spacing: 2px; text-shadow: var(--text-neon-glow); margin-bottom: 25px; font-size: 2rem;">
                    RPG ERA MEDIEVAL: Ferro & Fogo Pelo Poder
                </h1>
                   <center>
                <div class="btn-group btn-container-center" style="margin-bottom: 25px;">
                    <div class="btn-group nav-buttons-container">
                    <center>
                    <a href="../admpersonagens.php">
                        <button style="margin:0; padding: 12px 50px; width: auto;">Administração de Fichas & Personagens</button>
                    </a>
                    <br>
                    <a href="../dashboard.php">
                        <button style="margin:0; padding: 12px 50px; width: auto;">Menu Principal</button>
                    </a>
                    </center>
                    </div>
                </div>

                <h2 style="color: white; text-transform: uppercase; letter-spacing: 1px; margin-bottom: 15px;">
                    Ativar Personagens
                </h2>

                <p class="listing-intro">
                    Ative um personagem; você só pode ativar um por vez<br>Você possui <strong><?= $total_personagens ?></strong> personagem(ns)
                </p>
            </div>
            
            <?php if ($mensagem_sucesso): ?>
                <div class="message-neon success" style="border: 1px solid #00ff00; background: rgba(0,255,0,0.1); color: #00ff00; padding: 15px; margin: 10px auto; max-width: 600px; text-align: center; border-radius: 8px;">
                    <?= htmlspecialchars($mensagem_sucesso) ?>
                </div>
            <?php endif; ?>
            
            <?php if ($mensagem_erro): ?>
                <div class="message-neon error" style="border: 1px solid #ff2222; background: rgba(255,0,0,0.1); color: #ff2222; padding: 15px; margin: 10px auto; max-width: 600px; text-align: center; border-radius: 8px;">
                    <?= htmlspecialchars($mensagem_erro) ?>
                </div>
            <?php endif; ?>

            <br><br>
            
            <div class="personagens-list-container">
                
                <?php if (empty($personagens)): ?>
                    <div class="sem-personagens-neon">
                        <p>Você não possui personagens cadastrados.</p>
                        <div class="btn-group" style="margin-top: 20px; display: inline-block;">
                            <a href="criarpersonagem.php"><button>Criar Novo Personagem</button></a>
                        </div>
                    </div>
                <?php else: ?>
                    
                    <?php foreach ($personagens as $p): 
                        $estaAtivo = $p['ativo'] == 1;
                        $classe_card = $estaAtivo ? 'personagem-ativo-neon' : 'personagem-inativo-neon';
                    ?>
                        <form method="POST">
                            <input type="hidden" name="csrf_token" value="<?= $csrf_token ?>">
                            <input type="hidden" name="personagem_id" value="<?= $p['id'] ?>">
                            
                            <div class="personagem-neon-card <?= $classe_card ?>">
                                
                                <div class="personagem-header-neon">
                                    <div class="personagem-nome-neon">
                                        <?= htmlspecialchars($p['personagem']) ?>
                                        <span class="<?= $estaAtivo ? 'status-badge-ativo' : 'status-badge-inativo' ?>">
                                            (<?= $estaAtivo ? 'ATIVO' : 'INATIVO' ?>)
                                        </span>
                                    </div>
                                    
                                    <?php if (!$estaAtivo): ?>
                                        <button type="submit" name="ativar_personagem" class="btn-ativar-neon" onclick="return confirm('Deseja ativar <?= htmlspecialchars($p['personagem']) ?>? O personagem atual será desativado.');">
                                            Ativar Este Personagem
                                        </button>
                                    <?php endif; ?>
                                </div>
                                
                                <div class="personagem-detalhes-grid">
                                    <div class="detalhe-item-neon"><span class="icon">📍</span> Local: <?= htmlspecialchars($p['local']) ?></div>
                                    <div class="detalhe-item-neon"><span class="icon">🛡️</span> Soldados: <?= $p['soldados'] ?></div>
                                    <div class="detalhe-item-neon"><span class="icon">💰</span> Ouro: <?= $p['ouro'] ?></div>
                                    <div class="detalhe-item-neon"><span class="icon">💍</span> Prata: <?= $p['prata'] ?></div>
                                    <div class="detalhe-item-neon"><span class="icon">🎖️</span> Cargo: <?= $p['cargo'] ? htmlspecialchars($p['cargo']) : 'Nenhum' ?></div>
                                    <div class="detalhe-item-neon"><span class="icon">⭐</span> Reputação: <?= $p['reputacao'] ?></div>
                                    <div class="detalhe-item-neon"><span class="icon">⚔️</span> Ataque: <?= $p['atk'] ?></div>
                                    <div class="detalhe-item-neon"><span class="icon">🛡️</span> Defesa: <?= $p['def'] ?></div>
                                </div>

                            </div> 
                        </form>
                    <?php endforeach; ?>
                    
                    <?php if ($total_paginas > 1): ?>
                        <div class="pagination-neon">
                            <?php if ($pagina > 1): ?>
                                <a href="?pagina=<?= $pagina-1 ?>">« Anterior</a>
                            <?php endif; ?>
                            
                            <?php 
                            $inicio = max(1, $pagina - 2);
                            $fim = min($total_paginas, $pagina + 2);
                            
                            if ($inicio > 1) echo '<span style="color:var(--primary); padding: 10px;">...</span>';
                            
                            for ($i = $inicio; $i <= $fim; $i++): ?>
                                <?php if ($i == $pagina): ?>
                                    <a href="?pagina=<?= $i ?>" class="active"><?= $i ?></a>
                                <?php else: ?>
                                    <a href="?pagina=<?= $i ?>"><?= $i ?></a>
                                <?php endif; ?>
                            <?php endfor;
                            
                            if ($fim < $total_paginas) echo '<span style="color:var(--primary); padding: 10px;">...</span>';
                            ?>
                            
                            <?php if ($pagina < $total_paginas): ?>
                                <a href="?pagina=<?= $pagina+1 ?>">Próxima »</a>
                            <?php endif; ?>
                        </div>
                    <?php endif; ?>

                <?php endif; ?>
            </div> 
        </div> 
        <footer class="footer-simple-medieval">
            <div class="footer-content">
                <h4>⚔️ RPG ERA MEDIEVAL: FERRO & FOGO ⚔️</h4>
                <p>&copy; <?php echo date("Y"); ?> Todos os direitos reservados.</p>
            </div>
        </footer>

    </div> 
</body>
</html>