<?php
session_start();
require '../conexao.php'; // Ajuste o caminho se necessário

$wallet = $_SESSION['user_wallet']; // Ou coloque sua carteira manual aqui para testar
$pin_que_voce_esta_digitando = "1234"; // COLOQUE AQUI O PIN QUE VC ESTA TENTANDO USAR

echo "<h3>Diagnóstico de PIN</h3>";
echo "Carteira testada: " . $wallet . "<br>";

$stmt = $pdo->prepare("SELECT pin FROM usersblock WHERE wallet = :wallet");
$stmt->execute([':wallet' => $wallet]);
$pin_no_banco = $stmt->fetchColumn();

echo "<strong>O que está gravado no banco:</strong> " . $pin_no_banco . "<br><br>";

echo "<strong>Teste 1 (Comparação Simples):</strong> ";
if ($pin_no_banco == $pin_que_voce_esta_digitando) {
    echo "IGUAL (Isso significa que seu banco está sem criptografia)";
} else {
    echo "DIFERENTE";
}
echo "<br>";

echo "<strong>Teste 2 (Comparação Segura - password_verify):</strong> ";
if (password_verify($pin_que_voce_esta_digitando, $pin_no_banco)) {
    echo "SUCESSO! O Hash bateu.";
} else {
    echo "FALHOU. O sistema seguro não reconheceu.";
}

echo "<br><br><strong>Conclusão:</strong><br>";
if (strlen($pin_no_banco) < 60 && strlen($pin_no_banco) > 10) {
    echo "Seu hash parece cortado! Aumente o tamanho da coluna no banco para VARCHAR(255).";
} elseif (strlen($pin_no_banco) <= 8) {
    echo "Você está salvando a senha pura no banco. O sistema seguro EXIGE que seja um Hash.";
    echo "<br>Para corrigir, o Hash de '$pin_que_voce_esta_digitando' deveria ser: <br>" . password_hash($pin_que_voce_esta_digitando, PASSWORD_DEFAULT);
}
?>