<?php
session_start();
include 'conexao.php';

// Verifica se as variáveis de sessão necessárias estão definidas
if (!isset($_SESSION['personagem'], $_SESSION['local'], $_SESSION['user_name'])) {
    die("Variáveis de sessão necessárias não estão definidas.");
}

// Busca a data do último movimento do personagem
$stmt = $pdo->prepare("SELECT data, destino FROM movpersonagens 
                      WHERE personagem = :personagem 
                      ORDER BY data DESC LIMIT 1");
$stmt->bindParam(':personagem', $_SESSION['personagem']);
$stmt->execute();
$ultimo_movimento = $stmt->fetch(PDO::FETCH_ASSOC);

if (!$ultimo_movimento) {
    die("Histórico de movimento do personagem não encontrado.");
}

// Verifica se o destino do último movimento corresponde ao local atual
if ($ultimo_movimento['destino'] !== $_SESSION['local']) {
    die("O personagem não está no local correto.");
}

$data_chegada = $ultimo_movimento['data'];

// Pega o último ID de mensagem para atualizações incrementais
$last_id = isset($_GET['last_id']) ? (int)$_GET['last_id'] : 0;

// Recuperar mensagens do chat (apenas após a chegada no local)
$sql = "SELECT id, personagem, fala, direcionada, dataehora 
        FROM chatpersonagens 
        WHERE local = :local 
        AND dataehora >= :data_chegada";

// Se estamos buscando apenas mensagens novas
if ($last_id > 0) {
    $sql .= " AND id > :last_id";
}

$sql .= " ORDER BY dataehora ASC";

$stmt = $pdo->prepare($sql);
$stmt->bindParam(':local', $_SESSION['local']);
$stmt->bindParam(':data_chegada', $data_chegada);

if ($last_id > 0) {
    $stmt->bindParam(':last_id', $last_id, PDO::PARAM_INT);
}

$stmt->execute();
$mensagens = $stmt->fetchAll(PDO::FETCH_ASSOC);

// Busca o nome do personagem atual para verificação de mensagens
$stmt = $pdo->prepare("SELECT personagem FROM personagens WHERE id = :id");
$stmt->bindParam(':id', $_SESSION['personagem'], PDO::PARAM_INT);
$stmt->execute();
$meu_personagem = $stmt->fetch(PDO::FETCH_ASSOC);
$nome_personagem_atual = $meu_personagem['personagem'];

// Pega o último ID para a próxima atualização
$new_last_id = $last_id;
if (!empty($mensagens)) {
    $new_last_id = end($mensagens)['id'];
}

// Se for requisição AJAX, retorna apenas as mensagens novas
if (isset($_GET['ajax'])) {
    ob_start();
    foreach ($mensagens as $msg): 
        $isPropria = ($msg['personagem'] === $nome_personagem_atual);
        $isPrivada = (!empty($msg['direcionada']));
        $mostrarMensagem = true;
        if ($isPrivada && $msg['direcionada'] !== $nome_personagem_atual && !$isPropria) {
            $mostrarMensagem = false;
        }
        if ($mostrarMensagem):
    ?>
        <div class="mensagem <?php echo $isPropria ? 'propria' : ''; ?> <?php echo $isPrivada ? 'privada' : ''; ?>" data-id="<?php echo $msg['id']; ?>">
            <div class="cabecalho">
                <?php echo htmlspecialchars($msg['personagem']); ?>
                <?php if ($isPrivada): ?>
                    <span style="font-style: italic; font-weight: normal;">
                        (para <?php echo htmlspecialchars($msg['direcionada']); ?>)
                    </span>
                <?php endif; ?>
            </div>
            <div class="texto"><?php echo nl2br(htmlspecialchars($msg['fala'])); ?></div>
            <div class="data"><?php echo date('d/m/Y H:i', strtotime($msg['dataehora'])); ?></div>
        </div>
    <?php 
        endif;
    endforeach;
    echo ob_get_clean();
    exit;
}
?>
<!DOCTYPE html>
<html lang="pt-br">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Chat do RPG</title>
    <style>
        body {
            font-family: 'MedievalSharp', cursive;
            margin: 0;
            padding: 0;
            background-color: #000;
            color: #fff;
            display: flex;
            flex-direction: column;
            align-items: center;
            min-height: 100vh;
        }
        .container {
           width: 97%;
            max-width: 400px;
            padding: 10px;
            box-sizing: border-box;
            display: flex;
            flex-direction: column;
            align-items: center;
            position: relative;
        }
        h1 {
            color: #00f;
            text-align: center;
            font-size: 1.2em;
            margin: 5px 0;
           width: 97%;
            text-shadow: 0 0 5px #00f;
        }
        .chat-container {
            background-color: rgba(0, 0, 20, 0.7);
            border: 2px solid #00f;
            border-radius: 5px;
            padding: 8px;
            margin-bottom: 10px;
            height: 250px;
            overflow-y: auto;
           width: 97%;
            scrollbar-width: thin;
            scrollbar-color: #00f #000;
        }
        /* Estilização personalizada do scrollbar */
        .chat-container::-webkit-scrollbar {
            width: 8px;
        }
        .chat-container::-webkit-scrollbar-track {
            background: #000;
        }
        .chat-container::-webkit-scrollbar-thumb {
            background-color: #00f;
            border-radius: 4px;
            border: 1px solid #000;
        }
        .mensagens-wrapper {
            display: flex;
            flex-direction: column;
           width: 97%;
        }
        .mensagem {
            margin-bottom: 8px;
            padding: 6px;
            border-bottom: 1px solid #333;
            font-size: 0.9em;
            text-align: center;
           width: 97%;
        }
        .mensagem .cabecalho {
            font-weight: bold;
            margin-bottom: 3px;
            color: #00f;
            text-align: center;
            text-shadow: 0 0 3px #00f;
        }
        .mensagem .texto {
            text-align: center;
            margin: 5px 0;
        }
        .mensagem .data {
            font-size: 0.7em;
            color: #666;
            text-align: center;
        }
        .mensagem.propria {
            background-color: rgba(0, 0, 255, 0.1);
            border-left: 3px solid #00f;
        }
        .mensagem.privada {
            background-color: rgba(255, 255, 0, 0.1);
            border-left: 3px solid #ff0;
        }
        .mensagem.privada .cabecalho {
            color: #ff0;
            text-shadow: 0 0 3px #ff0;
        }
        #new-messages-alert {
            position: absolute;
            bottom: 20px;
            left: 50%;
            transform: translateX(-50%);
            background: rgba(0, 0, 255, 0.8);
            color: white;
            padding: 5px 15px;
            border-radius: 15px;
            cursor: pointer;
            display: none;
            z-index: 10;
            border: 1px solid #00f;
            box-shadow: 0 0 10px #00f;
            font-size: 0.8em;
        }
        #new-messages-alert:hover {
            background: rgba(0, 0, 255, 1);
        }
    </style>
    <script>
        let autoScroll = true;
        let lastId = <?php echo $new_last_id; ?>;
        let isLoading = false;
        let hasNewMessages = false;
        
        function checkScrollPosition() {
            const container = document.querySelector('.chat-container');
            // Verifica se o usuário está próximo do final (50px de margem)
            autoScroll = (container.scrollHeight - container.scrollTop - container.clientHeight < 50);
            
            // Se o usuário está no final e há novas mensagens, rola automaticamente
            if (autoScroll && hasNewMessages) {
                scrollToBottom();
                hasNewMessages = false;
                document.getElementById('new-messages-alert').style.display = 'none';
            }
        }
        
        function scrollToBottom() {
            const container = document.querySelector('.chat-container');
            container.scrollTop = container.scrollHeight;
            hasNewMessages = false;
            document.getElementById('new-messages-alert').style.display = 'none';
        }
        
        function loadNewMessages() {
            if (isLoading) return;
            
            isLoading = true;
            
            fetch(`?last_id=${lastId}&ajax=1`)
                .then(response => response.text())
                .then(html => {
                    if (html.trim()) {
                        const container = document.querySelector('.mensagens-wrapper');
                        const chatContainer = document.querySelector('.chat-container');
                        
                        // Salva a posição atual do scroll
                        const oldScrollHeight = chatContainer.scrollHeight;
                        const oldScrollTop = chatContainer.scrollTop;
                        
                        // Adiciona as novas mensagens
                        container.insertAdjacentHTML('beforeend', html);
                        
                        // Atualiza o lastId
                        const messages = container.querySelectorAll('.mensagem');
                        if (messages.length > 0) {
                            lastId = parseInt(messages[messages.length-1].dataset.id);
                        }
                        
                        // Se não estava no final, mostra o alerta de novas mensagens
                        if (!autoScroll) {
                            hasNewMessages = true;
                            document.getElementById('new-messages-alert').style.display = 'block';
                        } else {
                            // Se estava no final, rola para baixo automaticamente
                            scrollToBottom();
                        }
                    }
                    
                    isLoading = false;
                })
                .catch(error => {
                    console.error('Error:', error);
                    isLoading = false;
                });
        }
        
        // Inicia quando a página carrega
        document.addEventListener('DOMContentLoaded', function() {
            // Rola para o final inicialmente
            scrollToBottom();
            
            // Monitora o scroll
            document.querySelector('.chat-container').addEventListener('scroll', checkScrollPosition);
            
            // Configura atualização periódica
            setInterval(loadNewMessages, 3000);
            
            // Botão de novas mensagens
            document.getElementById('new-messages-alert').addEventListener('click', scrollToBottom);
        });
    </script>
</head>
<body>
    <div class="container">
        <h1>Chat - <?php echo htmlspecialchars($_SESSION['local']); ?></h1>
        <div class="chat-container">
        <div class="mensagens-wrapper">
    <?php if (empty($mensagens)): ?><center>
        <div class="mensagem-vazia">Não há mensagens desde que você chegou.</div></center>
    <?php else: ?>
        <?php foreach ($mensagens as $msg): 
            $isPropria = ($msg['personagem'] === $nome_personagem_atual);
            $isPrivada = (!empty($msg['direcionada']));
            $mostrarMensagem = true;
            if ($isPrivada && $msg['direcionada'] !== $nome_personagem_atual && !$isPropria) {
                $mostrarMensagem = false;
            }
            if ($mostrarMensagem): ?>
                <div class="mensagem <?php echo $isPropria ? 'propria' : ''; ?> <?php echo $isPrivada ? 'privada' : ''; ?>" data-id="<?php echo $msg['id']; ?>">
                    <div class="cabecalho">
                        <?php echo htmlspecialchars($msg['personagem']); ?>
                        <?php if ($isPrivada): ?>
                            <span style="font-style: italic; font-weight: normal;">
                                (para <?php echo htmlspecialchars($msg['direcionada']); ?>)
                            </span>
                        <?php endif; ?>
                    </div>
                    <div class="texto"><?php echo nl2br(htmlspecialchars($msg['fala'])); ?></div>
                    <div class="data"><?php echo date('d/m/Y H:i', strtotime($msg['dataehora'])); ?></div>
                </div>
            <?php endif; ?>
        <?php endforeach; ?>
    <?php endif; ?>
</div>
        </div>
        <div id="new-messages-alert">Novas mensagens ↓</div>
    </div>

</body>
</html>