<?php
session_start();
require 'conexao.php';

// Verifique se o usuário não está logado
if (!isset($_SESSION['user_id'])) {
    // Redirecione-o para a página de login
    header("Location: login.php");
}

if (isset($_POST['treinar'])) {

    
$personagem = $_SESSION['personagem'];
$situacao = "livre";


// Verifica se o personagem está paralisado
$sqlCheckParalisado = "SELECT paralisado FROM personagens WHERE id = :personagem";
$stmtCheck = $pdo->prepare($sqlCheckParalisado);
$stmtCheck->bindParam(':personagem', $personagem, PDO::PARAM_STR);
$stmtCheck->execute();

$paralisado = $stmtCheck->fetchColumn();

if ($paralisado) {
    $dataParalisado = new DateTime($paralisado);
    $dataAtual = new DateTime(); // Data/hora atual

    if ($dataParalisado >= $dataAtual) {echo 'oi3';
        // Ainda está paralisado, redireciona com mensagem
        $_SESSION['msg'] = "Tempo de ação ainda não terminou, só termina em " . $dataParalisado->format('d/m/Y H:i:s');
        header("Location: dashboardmed.php");
        exit;
    }
}
//  xxxxxxxxxxxxxxxxx         xxxxxxxxxxxxxxxxxxxxxx


        // Atualize a coluna 'local' na tabela 'personagens' para o novo valor
    $sql = "UPDATE personagens SET situacao = :situacao WHERE id = :personagem";
    $stmt = $pdo->prepare($sql);
    
$stmt->bindParam(':situacao', $situacao, PDO::PARAM_STR);
    $stmt->bindParam(':personagem', $personagem, PDO::PARAM_STR);
   
    
    if ($stmt->execute()) {
    $_SESSION['msg'] = "Agora seu personagem está livre novamente";
    header("Location: dashboardmed.php");
    exit; // Certifique-se de usar exit para interromper o script após o redirecionamento
} else {
    echo "Erro ao entrar em serviço.";
}

}

?>