<?php
session_start(); // Iniciar a sessão

// Verificar se o código de recuperação foi armazenado na variável de sessão
if (isset($_SESSION['codigo'])) {
    $codigo_recuperacao = $_SESSION['codigo'];

    if ($_SERVER['REQUEST_METHOD'] === 'POST') {
        // Verificar se o código de recuperação foi fornecido
        if (isset($_POST['codigoemail'])) {
            $codigo_digitado = $_POST['codigoemail'];

            // Verificar se o código de recuperação digitado está correto
            if ($codigo_digitado === $codigo_recuperacao) {
                // Redirecionar para a página de alteração de senha com o código de recuperação
                header('Location: dashboard.php?codigo=' . urlencode($codigo_recuperacao));
                exit;
            } else {
                // Exibe mensagem de erro
                $mensagem_erro = 'Código de recuperação inválido. Verifique o código novamente.';
            }
        }
    }
} else {
    echo '<p>Código de recuperação não encontrado.</p>';
}
?>

<!DOCTYPE html>
<html>
<head>
    <title>Login</title>
    <link rel="stylesheet" type="text/css" href="style.css">
</head>
<body>
<img class="bn" src="bn.png" alt=""><br><br>
    <div class="titulo">Código de verificação para logar</div><br><br>
<div class="texto2">Digite aqui, o código enviado por span, para o seu e-mail.</div><br><br><br>
       
    <?php if (isset($mensagem_erro)) { echo '<p>' . $mensagem_erro . '</p>'; } ?>
    
    <form method="post">
        <input type="text" name="codigoemail" placeholder="Digite o código recebido por e-mail" required><br><br>
        <button type="submit">Verificar Código</button>
    </form>
</body>
</html>
