<?php
session_start();
require '../../conex/conexao.php';

// 1. Segurança Básica
if (!isset($_SESSION['personagem']) || !isset($_POST['direcao'])) {
    header("Location: dashboardmed.php");
    exit();
}

$personagem_id = $_SESSION['personagem'];
$id2_destino = filter_input(INPUT_POST, 'direcao', FILTER_VALIDATE_INT);
$agora = date('Y-m-d H:i:s');


try {
    // INÍCIO DA TRANSAÇÃO (Essencial para escalabilidade e ACID)
    $pdo->beginTransaction();

    // 2. Busca dados do Personagem com TRAVAMENTO (FOR UPDATE)
    // Isso impede que duas requisições processem o movimento ao mesmo tempo (Race Condition)
    $sqlChar = "SELECT local, paralisado, movido FROM personagens WHERE id = :id FOR UPDATE";
    $stmtChar = $pdo->prepare($sqlChar);
    $stmtChar->execute([':id' => $personagem_id]);
    $char = $stmtChar->fetch(PDO::FETCH_ASSOC);

    if (!$char) {
        throw new Exception("Personagem não encontrado.");
    }

    // 3. Verificações de Bloqueio (Paralisia e Cooldown)
    // Verifica Paralisia
    if (!empty($char['paralisado']) && $char['paralisado'] > $agora) {
        $tempo = date('H:i:s', strtotime($char['paralisado']));
        $_SESSION['msg'] = "Você está paralisado até às $tempo!";
        $pdo->rollBack();
        header("Location: ../../dashboardmed.php");
        exit();
    }

    // Verifica Cooldown (15 segundos)
    if (!empty($char['movido'])) {
        $segundosPassados = time() - strtotime($char['movido']);
        if ($segundosPassados < 15) {
            $restante = 15 - $segundosPassados;
            $_SESSION['msg'] = "Aguarde $restante segundos para andar novamente.";
            $pdo->rollBack();
            header("Location: ../../dashboardmed.php");
            exit();
        }
    }

    // 4. Descobre a Região e o Destino
    // Primeiro, precisamos saber a região do local ATUAL
    $sqlMapaAtual = "SELECT * FROM mapasmed WHERE nome = :nome LIMIT 1";
    $stmtAtual = $pdo->prepare($sqlMapaAtual);
    $stmtAtual->execute([':nome' => $char['local']]);
    $mapaAtual = $stmtAtual->fetch(PDO::FETCH_ASSOC);

    if (!$mapaAtual) {
        throw new Exception("Local atual bugado/inexistente.");
    }

    $regiao = $mapaAtual['regiao'];
$tipo = $mapaAtual['tipo'];
echo $tipo;


    // Agora buscamos o alvo usando o ID2 (direção) e a Região
    $sqlAlvo = "SELECT nome, tipo FROM mapasmed WHERE id2 = :id2 AND regiao = :regiao LIMIT 1";
    $stmtAlvo = $pdo->prepare($sqlAlvo);
    $stmtAlvo->execute([':id2' => $id2_destino, ':regiao' => $regiao]);
    $alvo = $stmtAlvo->fetch(PDO::FETCH_ASSOC);

    // 5. Verificações de Destino
    if (!$alvo) {
        $_SESSION['msg'] = "Caminho bloqueado ou inexistente.";
        $pdo->rollBack();
        header("Location: ../../dashboardmed.php");
        exit();
    }

    // --- NOVA REGRA: BLOQUEIO DE MAR ---
    if ($alvo['tipo'] === 'mar') {
        $_SESSION['msg'] = "Você não pode entrar no mar sem um barco!";
        $pdo->rollBack();
        header("Location: ../../dashboardmed.php");
        exit();
    }
         
    // -----------------------------------

    // 6. Executa o Movimento
    $novo_local = $alvo['nome'];
    $fome = $_SESSION['fome'];
    $sede = $_SESSION['sede'];
   $fome = max(0, $fome - 2); 
$sede = max(0, $sede - 3);

    // Atualiza Personagem
    $sqlUpdate = "UPDATE personagens SET local = :novo_local, movido = :agora, fome = :fome, sede = :sede WHERE id = :id";
    $stmtUpdate = $pdo->prepare($sqlUpdate);
    $stmtUpdate->execute([
        ':novo_local' => $novo_local,
        ':agora'      => $agora,
        ':fome'         => $fome,
        ':sede'         => $sede,
         ':id'         => $personagem_id
    ]);
    
    // Opcional: Inserir no Log de Movimentos (tabela movpersonagens)
    // Isso ajuda a rastrear hacks ou bugs futuramente
    /*
    $sqlLog = "INSERT INTO movpersonagens (personagem, origem, destino, jogador, data) VALUES (:pid, :origem, :destino, :jog, NOW())";
    $stmtLog = $pdo->prepare($sqlLog);
    $stmtLog->execute([
        ':pid' => $personagem_id,
        ':origem' => $char['local'],
        ':destino' => $novo_local,
        ':jog' => $_SESSION['user_name'] ?? 'Sistema'
    ]);
    */

    // Confirma a Transação
    $pdo->commit();



// =========================================================
   // 7 REGISTRAR OCORRÊNCIA LOCAL (VISÍVEL NO FEED)
    // =========================================================

    // 1. Determinar o nome do novo local de destino (para o log)
    // Assumindo que você tem o ID do destino (ex: $norte_id) na variável $id_destino
    // Se o ID do destino for uma string, garanta que seja tratada ou use o nome do local.
    // **Nota:** No seu código de movimentação, $local já deve ser o NOVO LOCAL após o UPDATE.

    // . Montar a mensagem
    $personagem = $_SESSION['personagem_nome'];
    $claDoPersonagem = $_SESSION['cla'];
$local = $_SESSION['local'];
    $cla = $_SESSION['cla'];
    if ($tipo != 'mata') {
    

$mensagem = "O personagem $personagem [$cla], moveu-se para: $novo_local.";

    // . Inserir na Tabela ocorrencias_locais p inserir saida do personagm
    // NOTA: Inserimos no NOVO LOCAL ($local) para que quem está lá veja a chegada.
    try {
        $sqlInsert = "INSERT INTO ocorrencias_locais 
                      (personagem1, cla1, tipo, situacao, local, tempo_notificacao, data) 
                      VALUES (:p1, :c1, 'movimento', :situacao, :local, 120, NOW())"; // 120s = 2 minutos de validade no log

        $stmtInsert = $pdo->prepare($sqlInsert);
        $stmtInsert->execute([
            ':p1' => $nomePersonagem,
            ':c1' => $cla, // Assumindo que $cla é o clã do personagem
            ':situacao' => $mensagem,
            ':local' => $local // O NOVO LOCAL do personagem
        ]);

    } catch (Exception $e) {
        // Logar o erro, mas não travar a movimentação
        error_log("Erro ao registrar ocorrência de movimento: " . $e->getMessage());
    }

}
//fechamento if diferente de mata

// Inserção de chegada
$mensagemchegada = "O personagem $personagem [$cla], chegou em: $novo_local.";
 try { 
        $sqlInsert = "INSERT INTO ocorrencias_locais 
                      (personagem1, cla1, tipo, situacao, local, tempo_notificacao, data) 
                      VALUES (:p1, :c1, 'movimento', :situacao, :local, 120, NOW())"; // 120s = 2 minutos de validade no log

        $stmtInsert = $pdo->prepare($sqlInsert);
        $stmtInsert->execute([
            ':p1' => $nomePersonagem,
            ':c1' => $cla, // Assumindo que $cla é o clã do personagem
            ':situacao' => $mensagemchegada,
            ':local' => $novo_local // O NOVO LOCAL do personagem
        ]);

    } catch (Exception $e) {
        // Logar o erro, mas não travar a movimentação
        error_log("Erro ao registrar ocorrência de movimento: " . $e->getMessage());
    }




// 8. REGISTRAR AÇÃO COMPLETA NO INFOSSISTEMJOGO
    // =========================================================

    // 1. Definir a Origem (Local anterior) e Destino (Novo Local)
    // Assumindo que $char['local'] guarda o local anterior antes do UPDATE.
    // Assumindo que $novo_local guarda o local de destino (Passo 6).
    
    $local_anterior = $session['local'];
    $jogador_nome = $_SESSION['user_name'] ?? 'Sistema';

    // 2. Montar a Ação Detalhada
    $acao_p1 = "O personagem $personagem [$cla], do jogador $jogador_nome, moveu-se de $local, para $novo_local.";
   
    // 3. Montar a Mensagem Principal (informacao)
    $informacao = "Movimento do personagem $personagem";
$origem = "sistema";
    // 4. Inserir na Tabela infossistemjogo
    try {
        $sqlInsertInfo = "INSERT INTO infossistemjogo (
                          informacao, p1, acaop1, origem,  dataehora
                          ) VALUES (
                          :info, :p1_nome, :acao1, :origem, NOW()
                          )";

        $stmtInfo = $pdo->prepare($sqlInsertInfo);
        $stmtInfo->execute([
            ':info'        => $informacao,
            ':p1_nome'     => $nomePersonagem,
            ':acao1'       => $acao_p1,
            ':origem'      => $origem,
            // apgp1 e apgp2 são definidos como 0, pois é um movimento e não um ganho de pontos
        ]);

    } catch (Exception $e) {
        // Loga o erro, mas não trava a movimentação
        error_log("Erro ao registrar no infossistemjogo: " . $e->getMessage());
        // Opcional: Adicionar uma mensagem de erro na sessão para debug
        // $_SESSION['msg'] = "DEBUG: Falha ao registrar log completo. Detalhes: " . $e->getMessage();
    }





    // 8. Atualiza Sessão e Redireciona Instantaneamente
    $_SESSION['local'] = $novo_local;
    $_SESSION['msg'] = "Você viajou para $novo_local."; // Opcional, pode remover se quiser menos spam visual

    header("Location: ../../dashboardmed.php");
    exit();

} catch (Exception $e) {
    if ($pdo->inTransaction()) {
        $pdo->rollBack();
    }
    $_SESSION['msg'] = "Erro ao mover: " . $e->getMessage();
    header("Location: ../../dashboardmed.php");
    exit();
}
?>