<?php
session_start();
// Ajuste o caminho da conexão
require '../../conexao.php'; 

header('Content-Type: application/json');

$response = ['atacado' => false, 'locais' => []];

if (!isset($_SESSION['personagem_nome'])) {
    http_response_code(401);
    echo json_encode(['error' => 'Acesso negado.']);
    exit();
}

$personagem_nome = $_SESSION['personagem_nome'];

try {
    // 1. Encontrar todos os locais onde o personagem é o GOVERNANTE
    // O governante é o personagem (nome), não o Clã.
    $sqlLocais = "SELECT nome FROM mapasmed WHERE governante = :personagem";
    $stmtLocais = $pdo->prepare($sqlLocais);
    $stmtLocais->bindParam(':personagem', $personagem_nome, PDO::PARAM_STR);
    $stmtLocais->execute();
    
    $locais_governados = $stmtLocais->fetchAll(PDO::FETCH_COLUMN);

    if (empty($locais_governados)) {
        echo json_encode($response);
        exit();
    }

    // 2. Montar a consulta para checar ATAQUES ATIVOS (usando a tabela guerra_dominio)
    $placeholders = implode(',', array_fill(0, count($locais_governados), '?'));
    
    $sqlAtaques = "SELECT local FROM guerra_dominio 
                   WHERE local IN ($placeholders)
                   AND dominou = 0
                   AND (defensor IS NULL OR defensor = '')
                   AND iniciou > DATE_SUB(NOW(), INTERVAL 7 MINUTE)"; // Acha ataques recentes

    $stmtAtaques = $pdo->prepare($sqlAtaques);
    
    // Executa a consulta, passando os nomes dos locais (locais_governados) no array
    $stmtAtaques->execute($locais_governados);
    
    $locais_atacados = $stmtAtaques->fetchAll(PDO::FETCH_COLUMN);

    if (!empty($locais_atacados)) {
        $response['atacado'] = true;
        $response['locais'] = $locais_atacados;
    }

    echo json_encode($response);

} catch (Exception $e) {
    error_log("Erro no check_ataque_governo: " . $e->getMessage());
    http_response_code(500);
    echo json_encode(['error' => 'Erro interno do servidor.']);
}
?>