<?php
session_start();
require '../../conexao.php';

if (!isset($_SESSION['personagem'])) {
    $_SESSION['msg'] = "Nenhum personagem selecionado";
    header("Location: ../../dashboardmed.php");
    exit();
}

// Configura o fuso horário (importante!)
date_default_timezone_set('America/Sao_Paulo'); // Ajuste para seu fuso
$datamovimentacao = date('Y-m-d H:i:s');

 // 1. Determinar o nome do novo local de destino (para o log)
    // Assumindo que você tem o ID do destino (ex: $norte_id) na variável $id_destino
    // Se o ID do destino for uma string, garanta que seja tratada ou use o nome do local.
    // **Nota:** No seu código de movimentação, $local já deve ser o NOVO LOCAL após o UPDATE.

    // . Montar a mensagem
    $personagem = $_SESSION['personagem_nome'];
    $claDoPersonagem = $_SESSION['cla'];
$local = $_SESSION['local'];
    $jogador_nome = $_SESSION['user_name'] ?? 'Sistema';

    // 2. Montar a Ação Detalhada
    $acao_p1 = 'O personagem $personagem, do jogador $jogador_nome, apareceu em $local.';
   
    // 3. Montar a Mensagem Principal (informacao)
    $informacao = "Aparecimento do personagem $personagem";
$origem = "sistema";
    // 4. Inserir na Tabela infossistemjogo
    try {
        $sqlInsertInfo = "INSERT INTO infossistemjogo (
                          informacao, p1, acaop1, origem,  dataehora
                          ) VALUES (
                          :info, :p1_nome, :acao1, :origem, NOW()
                          )";

        $stmtInfo = $pdo->prepare($sqlInsertInfo);
        $stmtInfo->execute([
            ':info'        => $informacao,
            ':p1_nome'     => $personagem,
            ':acao1'       => $acao_p1,
            ':origem'      => $origem,
            // apgp1 e apgp2 são definidos como 0, pois é um movimento e não um ganho de pontos
        ]);

    } catch (Exception $e) {
        // Loga o erro, mas não trava a movimentação
        error_log("Erro ao registrar no infossistemjogo: " . $e->getMessage());
        // Opcional: Adicionar uma mensagem de erro na sessão para debug
        // $_SESSION['msg'] = "DEBUG: Falha ao registrar log completo. Detalhes: " . $e->getMessage();
    }


// xxxxxxxxxxxxxxxxxxxxxxxxxxx     xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx xxxxxxxxxxxxxxxx

// buscar situação do perosnagem p se estiver reagrupando exrcito n aparecer no ocorrencias locais
$personagem = $_SESSION['personagem_nome'];
$sqlSituacao = "SELECT * FROM personagens WHERE personagem = :pid LIMIT 1"; // Adicionado LIMIT 1 para garantir apenas um resultado

$stmtSituacao = $pdo->prepare($sqlSituacao);

// CORREÇÃO CRÍTICA: Use PDO::PARAM_STR para ligar a string do nome
$stmtSituacao->bindParam(':pid', $personagem, PDO::PARAM_STR);

$stmtSituacao->execute();

$resultado = $stmtSituacao->fetch(PDO::FETCH_ASSOC);

// Certifique-se de verificar se o resultado existe antes de acessar
if ($resultado) {
    $situacaopersonagem = $resultado['situacao'];
} else {
    $situacaopersonagem = "Personagem não encontrado no banco.";
}

echo $situacaopersonagem;




if ($situacaopersonagem != 'reagrupando soldados') {
$mensagem = "O personagem $personagem, apareceu em $local.";
// . Inserir na Tabela ocorrencias_locais p inserir saida do personagm
    // NOTA: Inserimos no NOVO LOCAL ($local) para que quem está lá veja a chegada.
    try {
        $sqlInsert = "INSERT INTO ocorrencias_locais 
                      (personagem1, cla1, tipo, situacao, local, tempo_notificacao, data) 
                      VALUES (:p1, :c1, 'movimento', :situacao, :local, 120, NOW())"; // 120s = 2 minutos de validade no log

        $stmtInsert = $pdo->prepare($sqlInsert);
        $stmtInsert->execute([
            ':p1' => $nomePersonagem,
            ':c1' => $cla, // Assumindo que $cla é o clã do personagem
            ':situacao' => $mensagem,
            ':local' => $local // O NOVO LOCAL do personagem
        ]);

    } catch (Exception $e) {
        // Logar o erro, mas não travar a movimentação
        error_log("Erro ao registrar ocorrência de movimento: " . $e->getMessage());
    }
} // fechamento do if $situacaopersonagem for diferente de reagrupando soldados

try {
    $sql = "UPDATE personagens SET situacao = 'livre', datamovimentacao = :datamovimentacao WHERE id = :personagem_id";
    $stmt = $pdo->prepare($sql);
    
    // CORREÇÃO: Remova o PARAM_INT ou use PARAM_STR
    $stmt->bindParam(':datamovimentacao', $datamovimentacao); // PDO irá detectar automaticamente
    $stmt->bindParam(':personagem_id', $_SESSION['personagem'], PDO::PARAM_INT);
    
    // DEBUG: Verifique os valores antes de executar
    error_log("Data a ser inserida: " . $datamovimentacao);
    error_log("ID do personagem: " . $_SESSION['personagem']);
    
    if ($stmt->execute()) {
        $_SESSION['msg'] = "Situação do personagem atualizada para livre";
        
        // DEBUG: Verifique quantas linhas foram afetadas
        error_log("Linhas afetadas: " . $stmt->rowCount());
    } else {
        $_SESSION['msg'] = "Erro ao atualizar a situação do personagem";
        
        // DEBUG: Capture informações de erro
        $errorInfo = $stmt->errorInfo();
        error_log("Erro PDO: " . print_r($errorInfo, true));
    }

} catch (PDOException $e) {
    $_SESSION['msg'] = "Erro no banco de dados: " . $e->getMessage();
    error_log("PDOException: " . $e->getMessage());
}

// DEBUG: Verifique a mensagem antes de redirecionar
error_log("Mensagem da sessão: " . $_SESSION['msg']);
header("Location: ../../dashboardmed.php");
exit();
?>