<?php
session_start();
require '../conexao.php';

if (!isset($_SESSION['user_id']) || !isset($_POST['id'])) {
    echo "Erro: Dados não fornecidos.";
    exit;
}

$id_alvo = (int)$_POST['id'];

// Busca os dados completos do personagem
$sql = "SELECT * FROM personagens WHERE id = :id";
$stmt = $pdo->prepare($sql);
$stmt->execute([':id' => $id_alvo]);
$p = $stmt->fetch(PDO::FETCH_ASSOC);

if (!$p) {
    echo "Personagem não encontrado.";
    exit;
}

// Define cor baseada no clã (se for do mesmo clã, fica verde)
$isAliado = (isset($_SESSION['cla']) && !empty($_SESSION['cla']) && $_SESSION['cla'] == $p['cla']);
$corDestaque = $isAliado ? '#28a745' : '#0000FF';

?>

<div style="display: flex; flex-direction: column; gap: 15px;">

    <div style="text-align: center; border-bottom: 1px solid <?=$corDestaque?>; padding-bottom: 10px;">
        <h2 style="color: <?=$corDestaque?>; margin: 0; text-transform: uppercase; text-shadow: 0 0 10px <?=$corDestaque?>;">
            <?= htmlspecialchars($p['personagem']) ?>
        </h2>
        <small style="color: #aaa;">Jogador: <?= htmlspecialchars($p['jogador']) ?></small>
    </div>

    <div class="info-card" style="border-left-color: <?=$corDestaque?>;">
        <h3 style="color: <?=$corDestaque?>; border-bottom: 1px dashed #444;">Status</h3>
        <p><strong>Clã:</strong> <span><?= htmlspecialchars($p['cla'] ?: 'Sem Clã') ?></span></p>
        <p><strong>Reputação:</strong> <span><?= $p['reputacao'] ?></span></p>
        <p><strong>Situação:</strong> <span style="color: #fff;"><?= $p['situacao'] ?></span></p>
    </div>

    <div class="info-card" style="border-left-color: #ffd700;">
        <h3 style="color: #ffd700; border-bottom: 1px dashed #444;">Recursos</h3>
        <p><strong>Ouro:</strong> <span style="color:#ffd700"><?= number_format($p['ouro'], 2) ?></span></p>
        <p><strong>Prata:</strong> <span style="color:#c0c0c0"><?= number_format($p['prata'], 2) ?></span></p>
        <p><strong>Carne:</strong> <span style="color:#ff9999"><?= number_format($p['carne'], 2) ?></span></p>
        <p><strong>Madeira:</strong> <span style="color:#daa520"><?= number_format($p['madeira'], 2) ?></span></p>
    </div>

    <div class="info-card" style="border-left-color: #ff2222;">
        <h3 style="color: #ff2222; border-bottom: 1px dashed #444;">Poder Militar</h3>
        <p><strong>Soldados:</strong> <span style="color:#ff2222"><?= $p['soldados'] ?></span></p>
        <p><strong>Ataque:</strong> <span><?= $p['atk'] ?></span></p>
        <p><strong>Defesa:</strong> <span><?= $p['def'] ?></span></p>
    </div>

</div>