<?php
session_start();
require '../conexao.php';

ini_set('display_errors', 1);
error_reporting(E_ALL);

if (!isset($_SESSION['user_id'])) {
    header("Location: login.php");
    exit();
}

$user_id = $_SESSION['user_id'];
$user_name = $_SESSION['user_name'];

function gerarHash($hashAnterior) {
    return hash('sha256', $hashAnterior . uniqid(mt_rand(), true));
}

function gerarLinkUnico($pdo) {
    do {
        $link = substr(md5(uniqid()), 0, 15);
        $stmt = $pdo->prepare("SELECT COUNT(*) FROM fichaspersonagens WHERE link = ?");
        $stmt->execute([$link]);
    } while ($stmt->fetchColumn() > 0);
    return $link;
}

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $jogador = trim($_POST['jogador']);
    $quantidade = (int)$_POST['quantidade'];

    if (empty($jogador) || $quantidade <= 0) {
        $_SESSION['msg'] = "Preencha todos os campos.";
        header("Location: gerar_fichas.php");
        exit();
    }

    // Pega ultimo hash
    $stmt = $pdo->query("SELECT hash FROM fichaspersonagens ORDER BY id DESC LIMIT 1");
    $ultimoHash = $stmt->fetchColumn() ?: 'genesis_block';

    try {
        $pdo->beginTransaction();
        
        $primeiroHashGerado = "";
        
        for ($i = 0; $i < $quantidade; $i++) {
            $novoHash = gerarHash($ultimoHash);
            $linkUnico = gerarLinkUnico($pdo);

            if($i == 0) $primeiroHashGerado = $novoHash; // Salva o primeiro para o log

            // Insere a Ficha (O Asset)
            $stmt = $pdo->prepare("INSERT INTO fichaspersonagens (jogador, quantidade, situacao, descricao, validade, hash, link, responsavel, data) VALUES (?, 1, '1', 'Gerada sistema', 1, ?, ?, ?, NOW())");
            $stmt->execute([$jogador, $novoHash, $linkUnico, $user_name]);

            $ultimoHash = $novoHash;
        }

        // --- NOVO: LOG DE AUDITORIA NO SISTEMA (Para redundância na Blockchain) ---
        // Registra que o Admin X gerou Y fichas para o Jogador Z
        $logDesc = "ADMIN MINT: O Admin $user_name gerou $quantidade fichas para a wallet/user $jogador.";
        $sqlLog = "INSERT INTO infossistema (p1, p2, informacao, dataehora, origem) VALUES (?, ?, ?, NOW(), ?)";
        $stmtLog = $pdo->prepare($sqlLog);
        // p1 = user logado (admin), p2 = jogador beneficiado
        // origem = hash da primeira ficha do lote (para rastreio)
        $stmtLog->execute([$user_name, $jogador, $logDesc, $primeiroHashGerado]);

        $pdo->commit();

        $stmt = $pdo->prepare("SELECT COUNT(*) FROM fichaspersonagens WHERE jogador = ?");
        $stmt->execute([$jogador]);
        $totalFichas = $stmt->fetchColumn();

        $_SESSION['msg'] = "<span style='color:#00ff7f'>Sucesso! {$quantidade} fichas mintadas para {$jogador}. Total atual: {$totalFichas}.</span>";
        header("Location: gerar_fichas.php");
        exit();

    } catch (PDOException $e) {
        $pdo->rollBack();
        $_SESSION['msg'] = "Erro CRÍTICO ao gerar: " . $e->getMessage();
        header("Location: gerar_fichas.php");
        exit();
    }
}
?>

<!DOCTYPE html>
<html lang="pt-BR">
<head>
    <meta charset="UTF-8">
    <title>Gerador de Assets (Mint)</title>
    <link rel="stylesheet" type="text/css" href="../style.css">
    <style>
        body { background-color: #111; color: #fff; font-family: sans-serif; }
        .inputpadrao { padding: 10px; width: 300px; background: #222; border: 1px solid #444; color: #fff; }
        .btn { padding: 10px 20px; background: #00f3ff; border: none; font-weight: bold; cursor: pointer; color: #000; }
        .mensagem { background: #222; padding: 10px; border: 1px solid #444; display: inline-block; margin-bottom: 20px; }
    </style>
    <script>
        function confirmarGeracao() {
            return confirm("ATENÇÃO: Essa ação registrará uma transação imutável na blockchain.\nDeseja MINTAR essas fichas?");
        }
    </script>
</head>
<body>

    <br><br>
    <center>
        <div class="titulo" style="font-size: 2rem; color: #00f3ff;">MINTING MACHINE</div>
        <p style="color: #666;">Geração de novos ativos na Blockchain</p>
        <br>
        
        <?php
        if (isset($_SESSION['msg'])) {
            echo '<div class="mensagem">' . $_SESSION['msg'] . '</div>';
            unset($_SESSION['msg']);
        }
        ?>
        
        <form method="POST" onsubmit="return confirmarGeracao()" style="border:1px solid #333; display:inline-block; padding:40px; border-radius:10px; background:#0a0a0a;">
            <label style="float:left; font-size:0.8rem; color:#888;">DESTINATÁRIO (JOGADOR):</label><br>
            <input type="text" class="inputpadrao" id="jogador" name="jogador" placeholder="Ex: usuario123" required>
            <br><br>
            
            <label style="float:left; font-size:0.8rem; color:#888;">QUANTIDADE (SUPPLY):</label><br>
            <input type="number" class="inputpadrao" id="quantidade" name="quantidade" placeholder="Qtd" required min="1">
            <br><br>
            
            <button type="submit" class="btn">MINTAR ATIVOS</button>
        </form>
        <br><br>
        <a href="../dashboard.php" style="color:#aaa; text-decoration:none;">&larr; Voltar ao Dashboard</a>
    </center>

</body>
</html>