<?php
// CONFIGURAÇÃO DE ERROS
ini_set('display_errors', 1);
ini_set('display_startup_errors', 1);
error_reporting(E_ALL);

session_start();

// --- CONEXÃO ---
// Ajuste o caminho conforme sua estrutura de pastas
if (file_exists('../conexao.php')) {
    require '../conexao.php';
} elseif (file_exists('../../conexao.php')) {
    require '../../conexao.php';
} else {
    require 'conexao.php';
}

// 1. SEGURANÇA
if (!isset($_SESSION['user_id']) || empty($_SESSION['personagem'])) {
    header("Location: ../login.php");
    exit();
}

$nomePersonagem = $_SESSION['personagem_nome'];

// 2. VERIFICA SE JÁ TEM CLÃ (Se tiver, não deve estar aqui)
$stmtP = $pdo->prepare("SELECT id, cla FROM personagens WHERE personagem = :nome LIMIT 1");
$stmtP->execute([':nome' => $nomePersonagem]);
$user_data = $stmtP->fetch(PDO::FETCH_ASSOC);

// Se já tem clã (diferente de vazio, NULL ou 'Nenhum'), redireciona
if ($user_data && !empty($user_data['cla']) && $user_data['cla'] !== 'Nenhum') {
    $_SESSION['msg'] = "Você já pertence a um clã.";
    header("Location: ../dashboardmed.php");
    exit();
}

// ==========================================================
// 3. PROCESSAR ACEITE / RECUSA
// ==========================================================
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    
    // --- ACEITAR CONVITE ---
    if (isset($_POST['aceitar_convite'])) {
        $convite_id = (int)$_POST['convite_id'];
        
        // 1. Busca dados do convite para garantir que é legítimo
        $stmtCheck = $pdo->prepare("SELECT c.*, cl.nome as nome_cla_alvo 
                                    FROM cla_convites c 
                                    JOIN cla cl ON c.cla_id = cl.id 
                                    WHERE c.id = :id AND c.convidado = :eu");
        $stmtCheck->execute([':id' => $convite_id, ':eu' => $nomePersonagem]);
        $dados_convite = $stmtCheck->fetch(PDO::FETCH_ASSOC);
        
        if ($dados_convite) {
            $novo_cla_nome = $dados_convite['nome_cla_alvo'];
            $cla_id_alvo = $dados_convite['cla_id'];
            
            $pdo->beginTransaction();
            try {
                // A. Atualiza o Personagem (Entra no Clã como Cargo 1)
                $stmtUp = $pdo->prepare("UPDATE personagens SET cla = :cla, cargo = 1 WHERE personagem = :nome");
                $stmtUp->execute([':cla' => $novo_cla_nome, ':nome' => $nomePersonagem]);
                
                // B. Registra no Log do Clã (Entrada)
                // Nota: cargo_quem_fez = 1 (o próprio recruta entrando)
                $stmtLog = $pdo->prepare("INSERT INTO cla_log_membros (cla_id, acao, quem_fez, cargo_quem_fez, alvo, motivo, data) VALUES (:cid, 'ENTRADA', :quem, 1, :alvo, 'Aceitou convite', NOW())");
                $stmtLog->execute([
                    ':cid' => $cla_id_alvo,
                    ':quem' => $nomePersonagem,
                    ':alvo' => $nomePersonagem
                ]);
                
                // C. LIMPEZA GERAL: Apaga TODOS os convites deste jogador (inclusive de outros clãs)
                $stmtDel = $pdo->prepare("DELETE FROM cla_convites WHERE convidado = :nome");
                $stmtDel->execute([':nome' => $nomePersonagem]);
                
                // Atualiza Sessão
                $_SESSION['cla'] = $novo_cla_nome;
                $_SESSION['cargo_id'] = 1;
                
                $pdo->commit();
                $_SESSION['msg'] = "Parabéns! Você agora é um membro do clã " . $novo_cla_nome . "!";
                header("Location: ../dashboard.php"); // Manda pro painel principal
                exit();
                
            } catch (Exception $e) {
                $pdo->rollBack();
                $_SESSION['msg'] = "Erro ao entrar no clã: " . $e->getMessage();
            }
        } else {
            $_SESSION['msg'] = "Convite inválido ou expirado.";
        }
    }
    
    // --- RECUSAR CONVITE (Apaga só este) ---
    if (isset($_POST['recusar_convite'])) {
        $convite_id = (int)$_POST['convite_id'];
        $stmtDel = $pdo->prepare("DELETE FROM cla_convites WHERE id = :id AND convidado = :eu");
        $stmtDel->execute([':id' => $convite_id, ':eu' => $nomePersonagem]);
        $_SESSION['msg'] = "Convite recusado.";
        header("Location: meus_convites.php");
        exit();
    }
}

// 4. BUSCAR CONVITES PENDENTES
$stmtList = $pdo->prepare("
    SELECT c.id, c.data, c.convidador, cl.nome as nome_cla, cl.reputacao, cl.pontos 
    FROM cla_convites c
    JOIN cla cl ON c.cla_id = cl.id
    WHERE c.convidado = :eu
    ORDER BY c.data DESC
");
$stmtList->execute([':eu' => $nomePersonagem]);
$convites = $stmtList->fetchAll(PDO::FETCH_ASSOC);

// Função de cor (igual às outras páginas)
function getRepColor($rep) {
    if ($rep >= 100) return '#00ff44';
    if ($rep >= 50) return '#00d2ff';
    return '#ff2222';
}
?>

<!DOCTYPE html>
<html lang="pt-BR">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Meus Convites | RPG Medieval</title>
    
    <link rel="stylesheet" href="../css/dashboardmed.css">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css">
    
    <style>
        /* Estilos Específicos para Convites */
        .invites-container {
            display: grid;
            grid-template-columns: repeat(auto-fill, minmax(350px, 1fr));
            gap: 20px;
            margin-top: 20px;
        }
        
        .invite-card {
            background-color: rgba(0, 0, 20, 0.9);
            border: 2px solid var(--primary);
            border-radius: 12px;
            padding: 20px;
            box-shadow: 0 0 15px rgba(0, 0, 255, 0.2);
            display: flex;
            flex-direction: column;
            justify-content: space-between;
            transition: transform 0.3s;
            position: relative;
            overflow: hidden;
        }
        
        .invite-card:hover {
            transform: translateY(-5px);
            box-shadow: 0 0 25px var(--neon-bright);
            border-color: #fff;
        }
        
        /* Faixa decorativa "CONVITE" */
        .invite-ribbon {
            position: absolute;
            top: 15px;
            right: -30px;
            background: var(--primary);
            color: #000;
            width: 120px;
            text-align: center;
            transform: rotate(45deg);
            font-weight: bold;
            font-size: 0.8rem;
            box-shadow: 0 5px 10px rgba(0,0,0,0.5);
        }

        .cla-title {
            font-family: 'Times New Roman', serif;
            font-size: 1.5rem;
            color: #fff;
            text-transform: uppercase;
            text-shadow: 0 0 10px var(--primary);
            border-bottom: 1px dashed #444;
            padding-bottom: 10px;
            margin-bottom: 15px;
        }
        
        .invite-details {
            font-size: 0.95rem;
            color: #ccc;
            margin-bottom: 20px;
            line-height: 1.6;
        }
        
        .invite-actions {
            display: flex;
            gap: 10px;
        }
        
        .btn-accept {
            flex: 1;
            background: #000;
            border: 2px solid #00ff44;
            color: #00ff44;
            padding: 12px;
            border-radius: 6px;
            cursor: pointer;
            font-weight: bold;
            text-transform: uppercase;
            transition: 0.3s;
        }
        .btn-accept:hover { background: #00ff44; color: #000; box-shadow: 0 0 15px #00ff44; }
        
        .btn-reject {
            flex: 1;
            background: #000;
            border: 2px solid #ff2222;
            color: #ff2222;
            padding: 12px;
            border-radius: 6px;
            cursor: pointer;
            font-weight: bold;
            text-transform: uppercase;
            transition: 0.3s;
        }
        .btn-reject:hover { background: #ff2222; color: #fff; box-shadow: 0 0 15px #ff2222; }
    </style>
</head>
<body>
    <div class="light-rays"></div>
    <div class="container">
        
        <header class="header-game">
             <h1 style="color: var(--primary); font-family: 'Times New Roman', serif; text-transform: uppercase; text-align: center; text-shadow: var(--text-neon-glow);">
                <i class="fas fa-envelope-open-text"></i> Convites Recebidos
             </h1>
             <div class="btn-group navigation" style="justify-content: center;">
                 <a href="../dashboard.php"><button style="width: auto;">Menu Principal</button></a>
                 <a href="../dashboardmed.php"><button style="width: auto;">Jogo</button></a>
             </div>
             <hr style="margin-top: 15px;">
        </header>

        <?php if (!empty($_SESSION['msg'])): ?>
            <div class="game-msg-box"><?= htmlspecialchars($_SESSION['msg']) ?></div>
            <?php $_SESSION['msg'] = ''; ?>
        <?php endif; ?>

        <main>
            <?php if (empty($convites)): ?>
                <div class="game-panel" style="text-align: center; padding: 50px; color: #888;">
                    <i class="fas fa-wind" style="font-size: 3rem; margin-bottom: 15px;"></i><br>
                    Você não possui convites pendentes no momento.<br>
                    <small>Aumente sua reputação para ser notado pelos clãs!</small>
                </div>
            <?php else: ?>
                
                <div class="invites-container">
                    <?php foreach ($convites as $c): 
                        $repColor = getRepColor($c['reputacao']);
                    ?>
                        <div class="invite-card">
                            <div class="invite-ribbon">CONVITE</div>
                            
                            <h3 class="cla-title"><?= htmlspecialchars($c['nome_cla']) ?></h3>
                            
                            <div class="invite-details">
                                <strong>Recrutador:</strong> <?= htmlspecialchars($c['convidador']) ?><br>
                                <strong>Data:</strong> <?= date('d/m/Y H:i', strtotime($c['data'])) ?><br>
                                <hr style="margin: 10px 0; border-color: #333;">
                                <strong>Status do Clã:</strong><br>
                                Pontos: <span style="color: cyan;"><?= number_format($c['pontos']) ?></span><br>
                                Reputação: <span style="color: <?= $repColor ?>; font-weight: bold;"><?= $c['reputacao'] ?></span>
                            </div>
                            
                            <div class="invite-actions">
                                <form action="" method="POST" style="flex: 1; margin: 0;">
                                    <input type="hidden" name="convite_id" value="<?= $c['id'] ?>">
                                    <button type="submit" name="aceitar_convite" class="btn-accept" onclick="return confirm('ATENÇÃO: Ao aceitar, você entrará automaticamente no clã e todos os outros convites serão apagados. Confirmar?');">
                                        <i class="fas fa-check"></i> Aceitar
                                    </button>
                                </form>
                                
                                <form action="" method="POST" style="flex: 1; margin: 0;">
                                    <input type="hidden" name="convite_id" value="<?= $c['id'] ?>">
                                    <button type="submit" name="recusar_convite" class="btn-reject" onclick="return confirm('Tem certeza que deseja recusar este convite?');">
                                        <i class="fas fa-times"></i> Recusar
                                    </button>
                                </form>
                            </div>
                        </div>
                    <?php endforeach; ?>
                </div>
                
            <?php endif; ?>
        </main>
        
        <center>
            <footer class="footer-simple-medieval" style="margin-top: 30px;">
                <p>&copy; 2025 RPG ERA MEDIEVAL</p>
            </footer>
        </center>
    </div>
</body>
</html>