<?php
session_start();
require 'conexao.php';

// Verifica sessão
if (!isset($_SESSION['personagem'], $_SESSION['user_name'], $_SESSION['local'])) {
    die("<div style='color:red;text-align:center; font-family:sans-serif; padding:10px;'>Sessão expirada.</div>");
}

$id_personagem = $_SESSION['personagem'];
$nome_jogador = $_SESSION['user_name'];
$nome_personagem = $_SESSION['personagem_nome'] ?? $nome_jogador;
$local_atual = $_SESSION['local'];
$local_clean = preg_replace('/[^A-Za-z0-9]/', '_', $local_atual);

// 1. OBTER DATA DE CHEGADA COM PRECISÃO
// Pega a data do movimento no banco
$stmt = $pdo->prepare("SELECT data FROM movpersonagens WHERE personagem = :id AND destino = :local ORDER BY id DESC LIMIT 1");
$stmt->execute([':id' => $id_personagem, ':local' => $local_atual]);
$movimento = $stmt->fetch(PDO::FETCH_ASSOC);

// Hora atual do servidor PHP (Timestamp)
$agora_servidor = time();

if ($movimento) {
    // Converte a data do banco para Timestamp
    $chegada_banco = strtotime($movimento['data']);
    
    // CORREÇÃO DE FUSO HORÁRIO (GAMBIARRA DE SEGURANÇA):
    // Se a data do banco parecer estar no "futuro" em relação ao servidor (diferença de fuso), 
    // ou muito no passado, usamos a lógica de segurança.
    // Mas para simplificar: O Firebase usa milissegundos UTC.
    // Vamos enviar o timestamp cru e tratar no JS.
    $timestamp_chegada = $chegada_banco * 1000;
} else {
    // Se não tem histórico, considera que chegou AGORA (menos 5 segundos de margem)
    $timestamp_chegada = ($agora_servidor - 5) * 1000;
}

// LISTA DE PERSONAGENS
$stmtChars = $pdo->prepare("SELECT personagem FROM personagens 
                            WHERE local = :local AND id != :my_id 
                            AND situacao NOT IN ('escondido', 'fugindo e reagrupando soldados')
                            ORDER BY personagem ASC");
$stmtChars->execute([':local' => $local_atual, ':my_id' => $id_personagem]);
$personagens_no_local = $stmtChars->fetchAll(PDO::FETCH_ASSOC);
?>
<!DOCTYPE html>
<html lang="pt-BR">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css">
    <style>
        /* === RESET E BASE === */
        * { box-sizing: border-box; }
        body {
            background-color: transparent;
            color: white;
            font-family: 'Segoe UI', Tahoma, Geneva, Verdana, sans-serif;
            margin: 0;
            padding: 0;
            display: flex;
            flex-direction: column;
            height: 100vh;
            overflow: hidden;
        }

        /* === ÁREA DAS MENSAGENS === */
        #messagesList {
            flex-grow: 1; 
            overflow-y: auto;
            padding: 5px 10px;
            display: flex;
            flex-direction: column;
            gap: 8px;
        }

        /* Scrollbar Neon */
        #messagesList::-webkit-scrollbar { width: 4px; }
        #messagesList::-webkit-scrollbar-track { background: rgba(0,0,0,0.3); }
        #messagesList::-webkit-scrollbar-thumb { background: #0000FF; border-radius: 2px; }

        /* Balões */
        .msg {
            padding: 8px 10px;
            border-radius: 6px;
            font-size: 0.85rem;
            animation: fadeIn 0.3s ease;
            word-wrap: break-word;
            border-left: 3px solid #555;
            background: rgba(0, 0, 0, 0.7);
            box-shadow: 0 2px 5px rgba(0,0,0,0.5);
        }
        @keyframes fadeIn { from { opacity: 0; transform: translateY(5px); } to { opacity: 1; transform: translateY(0); } }

        .msg.me { border-left-color: #3333FF; background: rgba(0, 0, 255, 0.1); }
        .msg.private { border-left-color: #ffd700; background: rgba(255, 215, 0, 0.1); border: 1px solid rgba(255, 215, 0, 0.2); }
        
        .msg-header {
            font-size: 0.7rem; color: #aaa; margin-bottom: 4px;
            display: flex; justify-content: space-between; align-items: center;
        }
        .author-me { color: #3333FF; font-weight: bold; }
        .author-other { color: #fff; font-weight: bold; }
        .target-arrow { color: #ffd700; font-style: italic; margin-left: 5px; }
        .text { color: #eee; line-height: 1.3; }

        /* === ÁREA DE CONTROLE (LAYOUT CORRIGIDO) === */
        .controls-area {
            flex-shrink: 0;
            background: #000;
            border-top: 1px solid #0000FF;
            padding: 8px 5px; 
            display: flex;
            flex-direction: column;
            gap: 6px;
            width: 100%;
        }

        /* Linha 1: Select */
        .select-wrapper { width: 100%; }
        #msgTarget {
            width: 100%;
            background: #050505;
            color: #ccc;
            border: 1px solid #333;
            border-radius: 4px;
            padding: 6px;
            font-size: 0.8rem;
            outline: none;
        }
        #msgTarget:focus { border-color: #0000FF; color: #fff; }

        /* Linha 2: Input + Botão */
        .input-row {
            display: flex;
            gap: 8px; /* Espaço entre input e botão */
            width: 100%;
            align-items: stretch;
            padding-right: 2px; /* Margem de segurança para não cortar */
        }

        #msgInput {
            flex: 1; /* Ocupa o máximo possível */
            min-width: 0;
            background: #050505;
            border: 1px solid #0000FF;
            color: white;
            padding: 10px;
            border-radius: 4px;
            outline: none;
            font-size: 0.9rem;
        }
        #msgInput:focus { box-shadow: 0 0 8px rgba(0,0,255,0.5); }

        #sendBtn {
            width: 50px;    /* Largura fixa */
            flex-shrink: 0; /* IMPEDE DE ENCOLHER/CORTAR */
            background: #0000FF;
            color: white;
            border: none;
            border-radius: 4px;
            cursor: pointer;
            font-size: 1.1rem;
            display: flex;
            align-items: center;
            justify-content: center;
            transition: 0.2s;
        }
        #sendBtn:hover { background: #000; color: #0000FF; outline: 1px solid #0000FF; box-shadow: 0 0 10px #0000FF; }

        .empty-state { text-align: center; color: #666; font-size: 0.8rem; margin-top: 30px; font-style: italic; }
    </style>
</head>
<body>

    <div id="messagesList">
        <div style="text-align:center; margin-top:20px; color:#555; font-size:0.8rem;">
            <i class="fas fa-sync fa-spin"></i> Conectando...
        </div>
    </div>

    <div class="controls-area">
        <div class="select-wrapper">
            <select id="msgTarget">
                <option value="Todos">Falar para: Todos</option>
                <?php foreach ($personagens_no_local as $p): ?>
                    <option value="<?php echo htmlspecialchars($p['personagem']); ?>">
                        Sussurrar para: <?php echo htmlspecialchars($p['personagem']); ?>
                    </option>
                <?php endforeach; ?>
            </select>
        </div>

        <div class="input-row">
            <input type="text" id="msgInput" placeholder="Digite sua mensagem..." autocomplete="off">
            <button id="sendBtn"><i class="fas fa-paper-plane"></i></button>
        </div>
    </div>

    <script src="https://www.gstatic.com/firebasejs/9.22.0/firebase-app-compat.js"></script>
    <script src="https://www.gstatic.com/firebasejs/9.22.0/firebase-database-compat.js"></script>

    <script>
        const firebaseConfig = {
             apiKey: "AIzaSyC1nRXk-rUBjUdRJtoXUDjWGLeiPnbV7vY",
             authDomain: "rpg-ffpp.firebaseapp.com",
             databaseURL: "https://rpg-ffpp-default-rtdb.firebaseio.com",
             projectId: "rpg-ffpp",
             storageBucket: "rpg-ffpp.firebasestorage.app",
             messagingSenderId: "539302281406",
             appId: "1:539302281406:web:a7736df5c7392d70049eef"
        };

        firebase.initializeApp(firebaseConfig);
        const db = firebase.database();

        const myName = "<?php echo $nome_personagem; ?>";
        const roomID = "chat_<?php echo $local_clean; ?>";
        
        // Lógica de Tempo: Chegada vs Agora
        // Usamos Date.now() para garantir que só vemos coisas de agora em diante se o banco estiver confuso
        // Mas tentamos respeitar o banco se ele estiver coerente.
        const serverArrivalTime = <?php echo $timestamp_chegada; ?>;
        const clientNow = Date.now();
        
        // Se a data do banco for MUITO antiga (mais de 1 dia), ou no futuro, usa o tempo do cliente
        // Isso corrige o bug de ver mensagens velhas se o fuso estiver doido
        let arrivalTime = serverArrivalTime;
        if (serverArrivalTime < (clientNow - 86400000)) {
            arrivalTime = clientNow; 
        }

        const msgList = document.getElementById('messagesList');
        const msgInput = document.getElementById('msgInput');
        const msgTarget = document.getElementById('msgTarget');
        const sendBtn = document.getElementById('sendBtn');
        const chatRef = db.ref('chats/' + roomID);

        // ENVIAR
        function sendMessage() {
            const text = msgInput.value.trim();
            const target = msgTarget.value;
            
            if (text === "") return;

            chatRef.push({
                user: myName,
                text: text,
                target: target,
                timestamp: firebase.database.ServerValue.TIMESTAMP
            });

            msgInput.value = "";
            msgInput.focus();
        }

        sendBtn.addEventListener('click', sendMessage);
        msgInput.addEventListener('keypress', (e) => { if (e.key === 'Enter') sendMessage(); });

        // RECEBER
        let firstMsgReceived = false;

        chatRef.limitToLast(50).on('child_added', (snapshot) => {
            const data = snapshot.val();

            // 1. FILTRO DE TEMPO (RIGOROSO)
            // Ignora qualquer mensagem cujo timestamp seja MENOR que sua chegada
            // Dá 1 segundo de tolerância para latência
            if (data.timestamp < (arrivalTime - 1000)) {
                return; 
            }

            // 2. FILTRO DE PRIVACIDADE
            const isMe = (data.user === myName);
            const target = data.target || "Todos";
            const isPrivate = (target !== "Todos");

            if (isPrivate && !isMe && target !== myName) {
                return; 
            }

            // Remove loader inicial
            if (!firstMsgReceived) {
                msgList.innerHTML = ""; 
                firstMsgReceived = true;
            }

            const msgDiv = document.createElement('div');
            if (isPrivate) msgDiv.className = 'msg private';
            else if (isMe) msgDiv.className = 'msg me';
            else msgDiv.className = 'msg other';

            const date = new Date(data.timestamp);
            const timeStr = date.toLocaleTimeString([], { hour: '2-digit', minute: '2-digit' });

            let targetHtml = "";
            if (isPrivate) {
                targetHtml = `<span class="target-arrow">➝ ${target} [Sussurro]</span>`;
            }

            const authorClass = isMe ? 'author-me' : 'author-other';

            msgDiv.innerHTML = `
                <div class="msg-header">
                    <span><span class="${authorClass}">${data.user}</span>${targetHtml}</span>
                    <span class="time">${timeStr}</span>
                </div>
                <div class="text">${data.text}</div>
            `;

            msgList.appendChild(msgDiv);
            msgList.scrollTop = msgList.scrollHeight;
        });
        
        // Timeout para mostrar mensagem de silêncio
        setTimeout(() => {
            if (msgList.innerHTML.includes("Conectando")) {
                msgList.innerHTML = "<div class='empty-state'><i class='fas fa-wind'></i><br>Este local está em silêncio...</div>";
            }
        }, 2000);

    </script>
</body>
</html>