<?php
session_start();
require 'conexao.php'; // Certifique-se de que este arquivo contém a conexão com o banco de dados

// Verifica se o personagem está armazenado como ID e busca o nome real
if (is_numeric($_SESSION['personagem'])) {
    $queryNome = "SELECT personagem FROM personagens WHERE id = :id";
    $stmtNome = $pdo->prepare($queryNome);
    $stmtNome->bindParam(':id', $_SESSION['personagem']);
    $stmtNome->execute();
    $personagematk = $stmtNome->fetchColumn();
} else {
    $personagematk = $_SESSION['personagem'];
}

// pegar personagem atacado vindo do post ou session
$personagemdef = $_POST['inimigo'] ?? $_SESSION['personagemdef'] ?? null;

// Atualiza sempre na sessão para manter o valor atualizado
$_SESSION['personagemdef'] = $personagemdef;

// Consulta para obter os dados do atacante
$queryAtk = "SELECT soldados, ouro, prata, carne, madeira, local, atk, def, reputacao, cla, cargo FROM personagens WHERE personagem = :personagem";
$stmtAtk = $pdo->prepare($queryAtk);
$stmtAtk->bindParam(':personagem', $personagematk);
$stmtAtk->execute();
$atkData = $stmtAtk->fetch(PDO::FETCH_ASSOC);

// Definir variaveis aleatorioas
$resumosituacao = '';


// Definir variáveis do atacante
$soldadosatk = $atkData['soldados'];
$ouroatk = $atkData['ouro'];
$prataatk = $atkData['prata'];
$carneatk = $atkData['carne'];
$madeiraatk = $atkData['madeira'];
$pontosatacanteatk = $atkData['atk'];
$pontosatacantedef = $atkData['def'];
$reputacaoatk = $atkData['reputacao'];
$claatk = $atkData['cla'];
$cargoatk = $atkData['cargo'];
$localatk = $atkData['local'];

// Consulta para obter os dados do defensor
$queryDef = "SELECT jogador, personagem, soldados, ouro, prata, carne, madeira, local, paralisado, situacao, atk, def, reputacao, cla, cargo FROM personagens WHERE personagem = :personagem";
$stmtDef = $pdo->prepare($queryDef);
$stmtDef->bindParam(':personagem', $personagemdef);
$stmtDef->execute();
$defData = $stmtDef->fetch(PDO::FETCH_ASSOC);

// Definir variáveis do defensor
$jogadordef = $defData['jogador'];
$personagemdef = $defData['personagem'];
$soldadosdef = $defData['soldados'];
$ourodef = $defData['ouro'];
$pratadef = $defData['prata'];
$carnedef = $defData['carne'];
$madeiradef = $defData['madeira'];
$situacaodef = $defData['situacao'];
$paralisadodef = $defData['paralisado'];
$pontosdefensoratk = $defData['atk'];
$pontosdefensordef = $defData['def'];
$reputacaodef = $defData['reputacao'];
$cladef = $defData['cla'];
$cargodef = $defData['cargo'];
$localdef = $defData['local'];

// xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx

// organizar fuga do perdedor e mandar pra $nvlocal 

try {
    // 1. Busca as direções no banco de dados
    $stmt = $pdo->prepare("SELECT n, l, s, o FROM mapasmed WHERE nome = :local");
    $stmt->bindParam(':local', $localdef, PDO::PARAM_STR);
    $stmt->execute();
    
    $direcoes = $stmt->fetch(PDO::FETCH_ASSOC);
    
    if (!$direcoes) {
        die("Local não encontrado no mapa.");
    }
    
    // Filtra apenas direções válidas (não vazias)
    $direcoes_validas = array_filter([
        'norte' => $direcoes['n'],
        'leste' => $direcoes['l'], 
        'sul' => $direcoes['s'],
        'oeste' => $direcoes['o']
    ]);
    
    if (empty($direcoes_validas)) {
        die("Nenhuma direção válida encontrada para este local.");
    }
    
    // Seleciona uma direção aleatória
    $direcao_escolhida = array_rand($direcoes_validas);
    $nvdirecao = $direcoes_validas[$direcao_escolhida];
    
    // 2. Agora busca a região correspondente
    $stmt = $pdo->prepare("SELECT nome, regiao FROM mapasmed WHERE id2 = :nvdirecao LIMIT 1");
    $stmt->bindParam(':nvdirecao', $nvdirecao, PDO::PARAM_STR);
    $stmt->execute();
    
    $local_info = $stmt->fetch(PDO::FETCH_ASSOC);
    
    if (!$local_info) {
        die("Local de destino não encontrado no mapa.");
    }
    
    $nvlocal = $local_info['nome'];
    $regiao_destino = $local_info['regiao'];
    

    
    // Saída com todas as informações
    echo "Direção escolhida: " . $direcao_escolhida . "\n";
    echo "Local de destino: " . $nvlocal . "\n";
    echo "Região: " . $regiao_destino . "\n";
    

    
} catch (PDOException $e) {
    die("Erro no banco de dados: " . $e->getMessage());
}

// xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx      xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx
// Verificar ação do personagem defensor, se ele ta pegando madeira/ caçando
if ($paralisadodef) {
    $dataParalisia = new DateTime($paralisadodef);
    $dataAtual = new DateTime(); // Data/hora atual

    if ($dataParalisia >= $dataAtual) {
        echo "Ainda paralisado (até " . $dataParalisia->format('d/m/Y H:i:s') . ")";
    } else {
        echo "Paralisação já acabou (terminou em " . $dataParalisia->format('d/m/Y H:i:s') . ")";
        $parou = 's';
    }
} else {
    echo "Não está paralisado";
}


if ($situacaodef == 'pegando madeira') {
    if ($madeiradef < $soldadosdef) {
  $faltamadeira = 'Tem menos madeiras que soldados';
  echo $faltamadeira;
    }
  
      if (isset($parou) && $parou == 's' && $faltamadeira != '') { 
   $_SESSION['personagemdef'] = $personagemdef;
          $_SESSION['soldadosdef'] = $soldadosdef;
          $_SESSION['situacaodef'] = $situacaodef;
          header("Location: atacandocolhetor.php");
         
          exit;
  }
  } 

if ($situacaodef == 'caçando') {
  if ($carnedef < $soldadosdef) {
$faltacarne = 'Tem menos carne que soldados';
echo $faltacarne;
  }

    if (isset($parou) && $parou == 's' && $faltacarne != '') { 
 $_SESSION['personagemdef'] = $personagemdef;
        $_SESSION['soldadosdef'] = $soldadosdef;
        $_SESSION['situacaodef'] = $situacaodef;
        header("Location: atacandocolhetor.php");
       
        exit;
}
} // Fechamento do elseif
//verifica se atacado está colhendo/caçando e se já terminou
// xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx    xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx

?>

<br><br> Guerra<br><br>
      <?php 
// Oque vai definir quem ganhou, é o Sptsatk/$ptsdef que representa o ponto de atk/ def o que for maior, vence, os pontos será uma serie de um monte de fatores somados
$ptsatk = bcmul($soldadosatk, $pontosatacanteatk); 
$ptsdef = bcmul($soldadosdef, $pontosdefensordef); 
$jogadoratk = $_SESSION['user_name'];
$local = $_SESSION['local'];
$dataHora = date('Y-m-d H:i:s');


if ($ptsatk > $ptsdef ) {echo 'O ATK Venceu';

    // xxxxxxxxxxxxxxxxxxxxxxxx    xxxxxxxxxxxxxxxxxxxxxxxx
    //nv é novo saldo ATK vencedor
    $nvsoldadosatk = "";
    $nvcarneatk = "";
    $nvmadeiraatk = '';
    $carnedefperdeu = "";
    $madeiradefperdeu = "";
    $nvouroatk = "";
    $nvprataatk = "";
    $ourodefperdeu = '';
    $pratadefperdeu = '';

    // Novo saldo para o defensor derrotado
    $soldadosdefperdeu = ceil(bcmul($soldadosdef, '0.37', 2));
    $soldadosdefperdeu = min($soldadosdefperdeu, $soldadosdef); // Nunca tira mais do que tem
    $nvsoldadosdef = (int)($soldadosdef - $soldadosdefperdeu); // Conversão para inteiro
    
    $nvmadeiradef = bcsub($madeiradef, bcmul($madeiradef, '0.30', 2), 2); // Reduz 27% dos soldados do defensor
    $nvcarnedef = bcsub($carnedef, bcmul($carnedef, '0.37', 2), 2); // Reduz 27% dos soldados do defensor
    $nvourodef = bcsub($ourodef, bcmul($ourodef, '0.20', 2), 2); // Reduz 27% dos soldados do defensor
    $nvpratadef = bcsub($pratadef, bcmul($pratadef, '0.40', 2), 2); // Reduz 27% dos soldados do defensor
    $nvpontosdefensordef = bcadd($pontosdefensordef, '0.01', 2);
    $nvreputacaodef = bcsub($reputacaodef, '0.04', 2); 
    $carnedefperdeu = bcmul($carnedef, '0.37', 2);
    $madeiradefperdeu =  bcmul($madeiradef, '0.30', 2);
    $ourodefperdeu = bcmul($ourodef, '0.20', 2);
    $pratadefperdeu = bcmul($pratadef, '0.40', 2);
    

    // Novo saldo para o vencedor
    
    // Cálculo seguro para soldados do ATACANTE
    $soldadosatkperdeu = ceil(bcmul($soldadosdefperdeu, '0.40', 2));
    $soldadosatkperdeu = min($soldadosatkperdeu, $soldadosatk); // Nunca tira mais do que tem
    $nvsoldadosatk = (int)($soldadosatk - $soldadosatkperdeu);
    
    $nvcarneatk = bcadd($carneatk, $carnedefperdeu, 2);
    $nvmadeiraatk = bcadd($madeiraatk, $carnedefperdeu, 2);
    $nvouroatk = bcadd($ouroatk, $ourodefperdeu, 2);
    $nvprataatk = bcadd($prataatk, $pratadefperdeu, 2);
    $nvpontosatacanteatk = bcadd($pontosatacanteatk, '0.03', 2);
    $nvreputacaoatk = bcadd($reputacaoatk, '0.03', 2);
    
        

    // ############################### PAREI AKI, MT SONO, TAVA FAZENDO ACIMA AS SOMAS DOS NOVOS VALORES DO PERSONAGEM QUE PERDEU A BATALHA, OS VALORES QUE VÃO ENTRAR OURO, PRATA.. ATUALIZANDO OVALOR
    // ########## DEPOIS VOU FAZER O SISTEMA SE O VENCEDOR TIVER VENCIDO....
    // nÃO ESQUESCERE DO SISTEMA EM AMBAS

    // xxxxxxxxxxxxxxxxxxxxxxxx    xxxxxxxxxxxxxxxxxxxxxxxx
    // Inserir as informações no sistema
    if ($situacaodef == 'caçando') {$resumosituacao = "Enquanto ele estava $situacaodef.";}
    if ($situacaodef == 'pegando madeira') {$resumosituacao = "Enquanto ele estava $situacaodef.";}

    $txtsistem = '';
    $txtsistem = "O Personagem $personagematk [$claatk], do jogador $jogadoratk, atacou bem-sucedidamente, o personagem $personagemdef [$cladef], do jogador $jogadordef. $resumosituacao no local $local na data de $dataHora, <br><br>
    O personagem atacante $personagematk [$claatk]:<br> tinha $soldadosatk soldado/s, perdeu $soldadosatkperdeu ficou com $nvsoldadosatk soldado/s;<br>
    tinha/m $ouroatk ouro/s, pegaram $ourodefperdeu dos adversários e ficaram com $nvouroatk ouro/s;<br>
    tinha/m $prataatk prata/s, pegaram $pratadefperdeu dos inimigos e ficaram com $nvprataatk prata/s;<br>
    tinha/m $carneatk carne/s, pegaram $carnedefperdeu dos inimigos e ficaram com $nvcarneatk carne/s;<br>
    tinha/m $madeiraatk madeira/s, pegaram $madeiradefperdeu dos inimigos e ficaram com $nvmadeiraatk madeira/s;<br>
    tinha/m $reputacaoatk de reputação, ganhou + 0.03, ficando com $nvreputacaoatk de reputação;<br>
    tinha/m $pontosatacanteatk pontos de atk, ganhou + 0.03 e ficou com $nvpontosatacanteatk;<br><br>
    O personagem defensor $personagemdef [$cladef], que perdeu a batalha:<br>
    tinha/m $soldadosdef soldado/s, perdeu $soldadosdefperdeu e ficou com $nvsoldadosdef soldado/s;<br>
    tinha/m $ourodef ouro/s, perderam $ourodefperdeu para os inimigos e ficaram com $nvourodef ouro/s;<br>
    tinha/m $pratadef prata/s, perderam $pratadefperdeu para os inimigos e ficaram com $nvpratadef prata/s;<br>
    tinha/m $carnedef carne/s, perderam $carnedefperdeu para os inimigos e ficaram com $nvcarnedef carne/s;<br>
    tinha/m $madeiradef madeira/s, perderam $madeiradefperdeu para os inimigos e ficaram com $nvmadeiradef madeira/s;<br>
    tinha/m $reputacaodef  de reputação, perdeu - 0.04, ficando com $nvreputacaodef de reputação;<br>
   tinha $pontosdefensordef pontos de defesa, ganhou + 0.01 e ficou com $nvpontosdefensordef pontos de defesa;<br>
    ";

    echo $txtsistem;

$informacao = "$txtsistem"; // Exemplo de informação
$p1 = $jogadoratk; // Primeiro participante (atacante)
$p2 = $jogadordef; // Segundo participante (defensor)
$origem = 'Ataque'; // Origem da informação
$dataehora = date('Y-m-d H:i:s'); // Data e hora atuais

$queryInfo = "INSERT INTO infossistema (informacao, p1, p2, origem, dataehora) 
              VALUES (:informacao, :p1, :p2, :origem, :dataehora)";

$stmtInfo = $pdo->prepare($queryInfo);
$stmtInfo->bindParam(':informacao', $informacao);
$stmtInfo->bindParam(':p1', $p1);
$stmtInfo->bindParam(':p2', $p2);
$stmtInfo->bindParam(':origem', $origem);
$stmtInfo->bindParam(':dataehora', $dataehora);
$stmtInfo->execute();
// xxxxxxxxxxxxxxxxxxxxxxxx    xxxxxxxxxxxxxxxxxxxxxxxx

    // xxxxxxxxxxxxxxxxxxxxxxxx    xxxxxxxxxxxxxxxx
    // NOTIFICAÇÃO P O JOGADor q perdeu
 $tipo = "Seu personagem $personagemdef foi atacado pelo personagem $personagematk [$cladef]. $resumosituacao E perdeu a batalha"; // Exemplo de tipo
    $notificacao = "O personagem $personagematk, atacou o seu personagem $personagemdef, no local $local.<br>
    Seu personagem perdeu a batalha e fugiu para $nvlocal.<br>
    Com ele/a tinha/m $soldadosdef soldado/s, perdeu $soldadosdefperdeu e ficou com $nvsoldadosdef soldado/s;<br>
    tinha/m $ourodef ouro/s, perderam $ourodefperdeu para os inimigos e ficaram com $nvourodef ouro/s;<br>
    tinha/m $pratadef prata/s, perderam $pratadefperdeu para os inimigos e ficaram com $nvpratadef prata/s;<br>
    tinha/m $carnedef carne/s, perderam $carnedefperdeu para os inimigos e ficaram com $nvcarnedef carne/s;<br>
    tinha/m $madeiradef madeira/s, perderam $madeiradefperdeu para os inimigos e ficaram com $nvmadeiradef madeira/s;<br>
    tinha/m $reputacaodef  de reputação, perdeu - 0.04, ficando com $nvreputacaodef de reputação;<br>
   tinha/m $pontosdefensordef pontos de defesa, ganhou + 0.01 e ficou com $nvpontosdefensordef pontos de defesa;<br>
"; // Mensagem da notificação

$user1 = $jogadoratk; // Usuário que iniciou a ação
$user2 = $jogadordef; // Usuário que foi alvo da ação
$dataehora = date('Y-m-d H:i:s'); // Data e hora atuais
$vz1 = 0; // Valor inicial para vz1
$vz2 = 0; // Valor inicial para vz2

$queryNotificacao = "INSERT INTO notificacoes_jogo (tipo, notificacao, user1, user2, dataehora, vz1, vz2) 
                     VALUES (:tipo, :notificacao, :user1, :user2, :dataehora, :vz1, :vz2)";

$stmtNotificacao = $pdo->prepare($queryNotificacao);
$stmtNotificacao->bindParam(':tipo', $tipo);
$stmtNotificacao->bindParam(':notificacao', $notificacao);
$stmtNotificacao->bindParam(':user1', $user1);
$stmtNotificacao->bindParam(':user2', $user2);
$stmtNotificacao->bindParam(':dataehora', $dataehora);
$stmtNotificacao->bindParam(':vz1', $vz1);
$stmtNotificacao->bindParam(':vz2', $vz2);
$stmtNotificacao->execute();

    // xxxxxxxxxxxxxxxxxxxx      xxxxxxxxxxxxxxxxx
    // atualizando dados dos personagem p´s batalha
// Atualizar os dados do atacante (vencedor)
$situacaoatacante = "reagrupando soldados";
$paralisacaoatk = date('Y-m-d H:i:s', strtotime('+1 minute')); // daqui a 1 minuto

$queryUpdateAtk = "UPDATE personagens SET 
    soldados = :nvsoldadosatk, 
    carne = :nvcarneatk, 
    madeira = :nvmadeiraatk, 
    ouro = :nvouroatk, 
    prata = :nvprataatk, 
    paralisado = :paralisacaoatk,
    situacao = :situacaoatacante,
    atk = :nvpontosatacanteatk, 
    reputacao = :nvreputacaoatk 
WHERE personagem = :personagematk";

$stmtUpdateAtk = $pdo->prepare($queryUpdateAtk);
$stmtUpdateAtk->bindParam(':nvsoldadosatk', $nvsoldadosatk);
$stmtUpdateAtk->bindParam(':nvcarneatk', $nvcarneatk);
$stmtUpdateAtk->bindParam(':nvmadeiraatk', $nvmadeiraatk);
$stmtUpdateAtk->bindParam(':nvouroatk', $nvouroatk);
$stmtUpdateAtk->bindParam(':nvprataatk', $nvprataatk);
$stmtUpdateAtk->bindParam(':paralisacaoatk', $paralisacaoatk);
$stmtUpdateAtk->bindParam(':situacaoatacante', $situacaoatacante);
$stmtUpdateAtk->bindParam(':nvpontosatacanteatk', $nvpontosatacanteatk);
$stmtUpdateAtk->bindParam(':nvreputacaoatk', $nvreputacaoatk);
$stmtUpdateAtk->bindParam(':personagematk', $personagematk);
$stmtUpdateAtk->execute();



// xxxxxxxxxxxxxxxxxxxxxxxxx xxxxxxxxxxxxxxxxxxxxxx
// registrar ação do vencedor
// Registrar ação para o ATACANTE (vencedor)
$acaoAtkVencedor = "Seu personagem $personagematk atacou o personagem $personagemdef ($cladef). $resumosituacao E venceu a batalha. 
Perdeu $soldadosatkperdeu soldados, mas abateu $soldadosdefperdeu soldados inimigos. 
Conquistou $ourodefperdeu ouro(s), $pratadefperdeu prata(s), $carnedefperdeu carne(s) e $madeiradefperdeu madeira(s). 
Seus soldados celebram a vitória! Reputação +0.03.
Os inimigos fugiram e se esconderam e seus soldados estão se reagrupando.";

$queryAcaoAtkVencedor = "INSERT INTO acoespersonagens (personagem, jogador, acao, tipoacao, origem, dataehora) 
                         VALUES (:personagem, :jogador, :acao, 'Ataque', 'Vitória', :dataehora)";
$stmtAcaoAtkVencedor = $pdo->prepare($queryAcaoAtkVencedor);
$stmtAcaoAtkVencedor->bindParam(':personagem', $personagematk);
$stmtAcaoAtkVencedor->bindParam(':jogador', $jogadoratk);
$stmtAcaoAtkVencedor->bindParam(':acao', $acaoAtkVencedor);
$stmtAcaoAtkVencedor->bindParam(':dataehora', $dataHora);
$stmtAcaoAtkVencedor->execute();

// Registrar ação para o DEFENSOR (perdedor)
$acaoDefPerdedor = "Seu personagem $personagemdef foi atacado pelo personagem $personagematk ($claatk). $resumosituacao em $local e perdeu a batalha, fugindo para $nvlocal. 
Perdeu $soldadosdefperdeu soldados, $ourodefperdeu ouro(s), $pratadefperdeu prata(s), $carnedefperdeu carne(s) e $madeiradefperdeu madeira(s). 
Conseguiu abater $soldadosatkperdeu soldados inimigos antes de recuar. Reputação -0.04 (agora $nvreputacaodef).";

$queryAcaoDefPerdedor = "INSERT INTO acoespersonagens (personagem, jogador, acao, tipoacao, origem, dataehora) 
                         VALUES (:personagem, :jogador, :acao, 'Defesa', 'Derrota', :dataehora)";
$stmtAcaoDefPerdedor = $pdo->prepare($queryAcaoDefPerdedor);
$stmtAcaoDefPerdedor->bindParam(':personagem', $personagemdef);
$stmtAcaoDefPerdedor->bindParam(':jogador', $jogadordef);
$stmtAcaoDefPerdedor->bindParam(':acao', $acaoDefPerdedor);
$stmtAcaoDefPerdedor->bindParam(':dataehora', $dataHora);
$stmtAcaoDefPerdedor->execute();

// xxxxxxxxxxxxxx     xxxxxxxxxxxxxx





// Atualizar os dados do defensor (perdedor)
$queryUpdateDef = "UPDATE personagens SET 
    soldados = :nvsoldadosdef, 
    carne = :nvcarnedef, 
    madeira = :nvmadeiradef, 
    local = :nvlocal,
    ouro = :nvourodef, 
    prata = :nvpratadef, 
    def = :nvpontosdefensordef, 
    reputacao = :nvreputacaodef 
WHERE personagem = :personagemdef";

$stmtUpdateDef = $pdo->prepare($queryUpdateDef);
$stmtUpdateDef->bindParam(':nvsoldadosdef', $nvsoldadosdef);
$stmtUpdateDef->bindParam(':nvcarnedef', $nvcarnedef);
$stmtUpdateDef->bindParam(':nvmadeiradef', $nvmadeiradef);
$stmtUpdateDef->bindParam(':nvlocal', $nvlocal);
$stmtUpdateDef->bindParam(':nvourodef', $nvourodef);
$stmtUpdateDef->bindParam(':nvpratadef', $nvpratadef);
$stmtUpdateDef->bindParam(':nvpontosdefensordef', $nvpontosdefensordef);
$stmtUpdateDef->bindParam(':nvreputacaodef', $nvreputacaodef);
$stmtUpdateDef->bindParam(':personagemdef', $personagemdef);
$stmtUpdateDef->execute();


// XXXXXXXXXXXXXXXXXXXXXXXXXXX       XXXXXXXXXXXXXXXXXX
// Fuga do perdedor
 // ATUALIZA A SITUAÇÃO DO DEFENSOR PARA "ESCONDIDO"
 try {
    // Calcula a data/hora para daqui a 5 minutos
    $dataParalisado = date('Y-m-d H:i:s', strtotime('+5 minutes'));
    
    // Prepara a query
    $queryUpdateSituacao = "UPDATE personagens 
                          SET situacao = 'escondido', 
                              paralisado = :paralisado 
                          WHERE personagem = :personagem";
    
    $stmtUpdate = $pdo->prepare($queryUpdateSituacao);
    
    if (!$stmtUpdate) {
        throw new Exception("Erro ao preparar a query de atualização");
    }
    
    // Bind dos parâmetros
    $stmtUpdate->bindParam(':personagem', $personagemdef, PDO::PARAM_STR);
    $stmtUpdate->bindParam(':paralisado', $dataParalisado, PDO::PARAM_STR);
    
    // Executa a query
    if (!$stmtUpdate->execute()) {
        $errorInfo = $stmtUpdate->errorInfo();
        throw new Exception("Erro ao executar a query: " . $errorInfo[2]);
    }
    
    // Mensagem de sucesso (opcional)
   // $_SESSION['msg'] = "Personagem escondido por 5 minutos";
    
} catch (Exception $e) {
    // Tratamento de erros
    error_log("Erro ao esconder personagem: " . $e->getMessage());
    $_SESSION['msg'] = "Ocorreu um erro ao tentar esconder o personagem";
}


// xxxxxxxxxxxxxxxxxx xxxxxxxxxxxxxxxx
//Redirecionar jogador pra pagina do jogo, apos ele vencer o atk

// . Inserir na Tabela ocorrencias_locais 
    $mensagemlocal = "O personagem $personagematk [$claatk], atacou bemsucedidamente o personagem $personagemdef [$cladef]";
    try {
        $sqlInsert = "INSERT INTO ocorrencias_locais 
                      (personagem1, personagem2, cla1, cla2, tipo, situacao, local, tempo_notificacao, data) 
                      VALUES (:p1, :p2, :c1, :c2, 'movimento', :situacao, :local, 120, NOW())"; // 120s = 2 minutos de validade no log

        $stmtInsert = $pdo->prepare($sqlInsert);
        $stmtInsert->execute([
            ':p1' => $personagematk,
            ':p2' => $personagemdef,
            ':c1' => $claatk, // Assumindo que $cla é o clã do personagem
            ':c2' => $cladef, // Assumindo que $cla é o clã do personagem
            ':situacao' => $mensagemlocal,
            ':local' => $local // O NOVO LOCAL do personagem
        ]);

    } catch (Exception $e) {
        // Logar o erro, mas não travar a movimentação
        error_log("Erro ao registrar ocorrência de movimento: " . $e->getMessage());
    }

header("Location: dashboardmed.php");
    exit(); // Importante para parar a execução

}


// xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx      xxxxxxxxxxxxxxxxxxxxxxxx
// xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx      xxxxxxxxxxxxxxxxxxxxxxxx
// xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx      xxxxxxxxxxxxxxxxxxxxxxxx
    // xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx      xxxxxxxxxxxxxxxxxxxxxxxx



if ($ptsatk <= $ptsdef ) {echo 'O defensor venceu';

//nv é novo saldo def vencedor
$nvsoldadosdef = "";
$nvcarnedef = "";
$nvmadeiradef = '';
$carneatkperdeu = "";
$madeiraatkperdeu = "";
$nvourodef = "";
$nvpratadef = "";
$ouroatkperdeu = '';
$prataatkperdeu = '';

// Novo saldo para o atkensor derrotado
$soldadosatkperdeu = ceil(bcmul($soldadosatk, '0.37', 2));
$soldadosatkperdeu = min($soldadosatkperdeu, $soldadosatk); // Nunca tira mais do que tem
$nvsoldadosatk = (int)($soldadosatk - $soldadosatkperdeu); // Conversão para inteiro

$nvmadeiraatk = bcsub($madeiraatk, bcmul($madeiraatk, '0.30', 2), 2); // Reduz 27% dos soldados do atkensor
$nvcarneatk = bcsub($carneatk, bcmul($carneatk, '0.37', 2), 2); // Reduz 27% dos soldados do atkensor
$nvouroatk = bcsub($ouroatk, bcmul($ouroatk, '0.20', 2), 2); // Reduz 27% dos soldados do atkensor
$nvprataatk = bcsub($prataatk, bcmul($prataatk, '0.40', 2), 2); // Reduz 27% dos soldados do atkensor
$nvpontosatkensoratk = bcadd($pontosatkensoratk, '0.01', 2);
$nvpontosatacanteatk =  bcadd($pontosatacanteatk, '0.01', 2);
$nvreputacaoatk = bcsub($reputacaoatk, '0.04', 2); 
$carneatkperdeu = bcmul($carneatk, '0.37', 2);
$madeiraatkperdeu =  bcmul($madeiraatk, '0.30', 2);
$ouroatkperdeu = bcmul($ouroatk, '0.20', 2);
$prataatkperdeu = bcmul($prataatk, '0.40', 2);


// Novo saldo para o vencedor

// Cálculo seguro para soldados do ATACANTE
$soldadosdefperdeu = ceil(bcmul($soldadosatkperdeu, '0.40', 2));
$soldadosdefperdeu = min($soldadosdefperdeu, $soldadosdef); // Nunca tira mais do que tem
$nvsoldadosdef = (int)($soldadosdef - $soldadosdefperdeu);

$nvcarnedef = bcadd($carnedef, $carneatkperdeu, 2);
$nvmadeiradef = bcadd($madeiradef, $carneatkperdeu, 2);
$nvourodef = bcadd($ourodef, $ouroatkperdeu, 2);
$nvpratadef = bcadd($pratadef, $prataatkperdeu, 2);
$nvpontosdefensordef = bcadd($pontosdefensordef, '0.03', 2);
$nvreputacaodef = bcadd($reputacaodef, '0.03', 2);

    
 // xxxxxxxxxxxxxxxxxxxxxxxx    xxxxxxxxxxxxxxxxxxxxxxxx
    // Inserir as informações no sistema
    if ($situacaodef == 'caçando') {$resumosituacao = "Enquanto ele estava $situacaodef.";}
    if ($situacaodef == 'pegando madeira') {$resumosituacao = "Enquanto ele estava $situacaodef.";}

    $txtsistem = '';
    $txtsistem = "O Personagem $personagematk [$claatk], do jogador $jogadoratk, atacou mal sucedidamente, o personagem $personagemdef [$cladef], do jogador $jogadordef. $resumosituacao No local $local na data de $dataHora<br><br>
    O personagem atacante $personagematk [$claatk], que perdeu a batalha, fugiu para $nvlocal:<br> 
    tinha $soldadosatk soldado/s, perdeu $soldadosatkperdeu e ficou com $nvsoldadosatk soldado/s;<br>
    tinha/m $ouroatk ouro/s, perdeu $ouroatkperdeu para os adversários e ficaram com $nvouroatk ouro/s;<br>
    tinha/m $prataatk prata/s, perdeu $prataatkperdeu para os inimigos e ficaram com $nvprataatk prata/s;<br>
    tinha/m $carneatk carne/s, perdeu $carneatkperdeu para os inimigos e ficaram com $nvcarneatk carne/s;<br>
    tinha/m $madeiraatk madeira/s, perdeu $madeiraatkperdeu para os inimigos e ficaram com $nvmadeiraatk madeira/s;<br>
    tinha/m $reputacaoatk de reputação, perdeu 0.4, ficando com $nvreputacaoatk de reputação;<br>
    tinha $pontosatacanteatk pontos de atk, ganhou 0.01, ficando com $nvpontosatacanteatk. <br><br>
    O personagem defensor $personagemdef [$cladef], que venceu a batalha:<br>
    tinha/m $soldadosdef soldado/s, perdeu $soldadosdefperdeu e ficou com $nvsoldadosdef soldado/s;<br>
    tinha/m $ourodef ouro/s, pegaram $ouroatkperdeu dos inimigos e ficaram com $nvourodef ouro/s;<br>
    tinha/m $pratadef prata/s, pegaram $prataatkperdeu dos inimigos e ficaram com $nvpratadef prata/s;<br>
    tinha/m $carnedef carne/s, pegaram $carneatkperdeu dos inimigos e ficaram com $nvcarnedef carne/s;<br>
    tinha/m $madeiradef madeira/s, pegaram $madeiraatkperdeu dos inimigos e ficaram com $nvmadeiradef madeira/s;<br>
    tinha/m $reputacaodef  de reputação, ganhou 0.3, ficando com $nvreputacaodef de reputação;<br>
   tinha $pontosdefensordef pontos de defesa, ganhou + 0.03 e ficou com $nvpontosdefensordef pontos de defesa;<br>
    ";

    echo $txtsistem;


// xxxxxxxxxxxxxxxxxxx     xxxxxxxxxxxxxxxxxxxxx
$informacao = "$txtsistem"; // Exemplo de informação
$p1 = $jogadoratk; // Primeiro participante (atacante)
$p2 = $jogadordef; // Segundo participante (defensor)
$origem = 'Ataque'; // Origem da informação
$dataehora = date('Y-m-d H:i:s'); // Data e hora atuais

$queryInfo = "INSERT INTO infossistema (informacao, p1, p2, origem, dataehora) 
              VALUES (:informacao, :p1, :p2, :origem, :dataehora)";

$stmtInfo = $pdo->prepare($queryInfo);
$stmtInfo->bindParam(':informacao', $informacao);
$stmtInfo->bindParam(':p1', $p1);
$stmtInfo->bindParam(':p2', $p2);
$stmtInfo->bindParam(':origem', $origem);
$stmtInfo->bindParam(':dataehora', $dataehora);
$stmtInfo->execute();

    // xxxxxxxxxxxxxxxxx        xxxxxxxxxxxxxxxxxxxx
   // NOTIFICAÇÃO P O JOGADor DEFENSOR q venceu
// NOTIFICAÇÃO P O JOGADOR DEFENSOR q venceu
if ($resumosituacao == '') {$resumosituacao = '';}
$tipo = "Seu personagem $personagemdef foi atacado pelo $personagematk [$cladef]. $resumosituacao E venceu a batalha";
$notificacao = "O personagem $personagematk, atacou o seu personagem $personagemdef, no local $local.
    Seu personagem venceu a batalha, parabéns.
    Com o seu personagem $personagemdef tinha/m $soldadosdef soldado/s, perdeu $soldadosdefperdeu e ficou com $nvsoldadosdef soldado/s;
    tinha/m $ourodef ouro/s, pegaram $ouroatkperdeu dos inimigos e ficaram com $nvourodef ouro/s;
    tinha/m $pratadef prata/s, pegaram $prataatkperdeu dos inimigos e ficaram com $nvpratadef prata/s;
    tinha/m $carnedef carne/s, pegaram $carneatkperdeu dos inimigos e ficaram com $nvcarnedef carne/s;
    tinha/m $madeiradef madeira/s, pegaram $madeiraatkperdeu dos inimigos e ficaram com $nvmadeiradef madeira/s;
    tinha/m $reputacaodef  de reputação, ganhou + 0.3, ficando com $nvreputacaodef de reputação;
   tinha/m $pontosdefensordef pontos de defesa, ganhou + 0.03 e ficou com $nvpontosdefensordef pontos de defesa;
   Você pegaram $ouroatkperdeu ouro/s, $prataatkperdeu prata/s, $carneatkperdeu carne/s e $madeiraatkperdeu madeiras dos inimigos.
   Ainda conseguiram abater $soldadosatkperdeu soldados inimigos. Os sobreviventes fugiram e se esconderam.
   Parabéns, seus soldados ficam felizes, por estarem sob o comando de um excelente comandante!!
";

$user1 = $jogadoratk;
$user2 = $jogadordef;
$personagem1 = $personagematk; // Personagem do atacante
$personagem2 = $personagemdef; // Personagem do defensor
$cla1 = $claatk; // Clã do atacante
$cla2 = $cladef; // Clã do defensor
$apg = 0; // Campo apg com valor 0
$dataehora = date('Y-m-d H:i:s');
$vz1 = 0;
$vz2 = 0;

$queryNotificacao = "INSERT INTO notificacoes_jogo (tipo, notificacao, user1, user2, personagem1, personagem2, cla1, cla2, apg, dataehora, vz1, vz2) 
                     VALUES (:tipo, :notificacao, :user1, :user2, :personagem1, :personagem2, :cla1, :cla2, :apg, :dataehora, :vz1, :vz2)";

$stmtNotificacao = $pdo->prepare($queryNotificacao);
$stmtNotificacao->bindParam(':tipo', $tipo);
$stmtNotificacao->bindParam(':notificacao', $notificacao);
$stmtNotificacao->bindParam(':user1', $user1);
$stmtNotificacao->bindParam(':user2', $user2);
$stmtNotificacao->bindParam(':personagem1', $personagem1);
$stmtNotificacao->bindParam(':personagem2', $personagem2);
$stmtNotificacao->bindParam(':cla1', $cla1);
$stmtNotificacao->bindParam(':cla2', $cla2);
$stmtNotificacao->bindParam(':apg', $apg);
$stmtNotificacao->bindParam(':dataehora', $dataehora);
$stmtNotificacao->bindParam(':vz1', $vz1);
$stmtNotificacao->bindParam(':vz2', $vz2);
$stmtNotificacao->execute();

    // xxxxxxxxxxxxxxxxxxxxxxxx      xxxxxxxxxxxxxxxxxxxxxx

    // xxxxxxxxxxxxxxxxxxxx      xxxxxxxxxxxxxxxxx
    // atualizando dados dos personagem p´s batalha
// Atualizar os dados do atacante (perdedor)
$situacaoatacante = "fugindo e reagrupando soldados";
$paralisacaoatk = date('Y-m-d H:i:s', strtotime('+3 minute')); // daqui a 3 minuto

$queryUpdateAtk = "UPDATE personagens SET 
    soldados = :nvsoldadosatk, 
    carne = :nvcarneatk, 
    madeira = :nvmadeiraatk, 
    local = :nvlocal,
    ouro = :nvouroatk, 
    prata = :nvprataatk, 
    paralisado = :paralisacaoatk,
    situacao = :situacaoatacante,
    atk = :nvpontosatacanteatk, 
    reputacao = :nvreputacaoatk 
WHERE personagem = :personagematk";

$stmtUpdateAtk = $pdo->prepare($queryUpdateAtk);
$stmtUpdateAtk->bindParam(':nvsoldadosatk', $nvsoldadosatk);
$stmtUpdateAtk->bindParam(':nvcarneatk', $nvcarneatk);
$stmtUpdateAtk->bindParam(':nvmadeiraatk', $nvmadeiraatk);
$stmtUpdateAtk->bindParam(':nvlocal', $nvlocal);
$stmtUpdateAtk->bindParam(':nvouroatk', $nvouroatk);
$stmtUpdateAtk->bindParam(':nvprataatk', $nvprataatk);
$stmtUpdateAtk->bindParam(':paralisacaoatk', $paralisacaoatk);
$stmtUpdateAtk->bindParam(':situacaoatacante', $situacaoatacante);
$stmtUpdateAtk->bindParam(':nvpontosatacanteatk', $nvpontosatacanteatk);
$stmtUpdateAtk->bindParam(':nvreputacaoatk', $nvreputacaoatk);
$stmtUpdateAtk->bindParam(':personagematk', $personagematk);
$stmtUpdateAtk->execute();

// Atualizar os dados do defensor (vencedor)
$queryUpdateDef = "UPDATE personagens SET 
    soldados = :nvsoldadosdef, 
    carne = :nvcarnedef, 
    madeira = :nvmadeiradef, 
    ouro = :nvourodef, 
    prata = :nvpratadef, 
    def = :nvpontosdefensordef, 
    reputacao = :nvreputacaodef 
WHERE personagem = :personagemdef";

$stmtUpdateDef = $pdo->prepare($queryUpdateDef);
$stmtUpdateDef->bindParam(':nvsoldadosdef', $nvsoldadosdef);
$stmtUpdateDef->bindParam(':nvcarnedef', $nvcarnedef);
$stmtUpdateDef->bindParam(':nvmadeiradef', $nvmadeiradef);
$stmtUpdateDef->bindParam(':nvourodef', $nvourodef);
$stmtUpdateDef->bindParam(':nvpratadef', $nvpratadef);
$stmtUpdateDef->bindParam(':nvpontosdefensordef', $nvpontosdefensordef);
$stmtUpdateDef->bindParam(':nvreputacaodef', $nvreputacaodef);
$stmtUpdateDef->bindParam(':personagemdef', $personagemdef);
$stmtUpdateDef->execute();


// xxxxxxxxxxxxxxxxxxxxxx    xxxxxxxxxxxxxxxxx
// Registrar ação para o DEFENSOR (vencedor)
// xxxxxxxxxxxxxxxxxxxxxx    xxxxxxxxxxxxxxxxx
// Registrar ação para o DEFENSOR (vencedor)
// Registrar ação para o DEFENSOR (vencedor)
$acaoDefVencedor = "Seu personagem $personagemdef foi atacado pelo personagem $personagematk ($claatk). $resumosituacao Em $local e venceu a batalha. 
Perdeu $soldadosdefperdeu soldados, mas abateu $soldadosatkperdeu soldados inimigos. 
Conquistou $ouroatkperdeu ouro(s), $prataatkperdeu prata(s), $carneatkperdeu carne(s) e $madeiraatkperdeu madeira(s). 
Seus soldados celebram a vitória! Reputação +0.03 (agora $nvreputacaodef).";

$vz = 0; // Campo vz com valor 0

$queryAcaoDefVencedor = "INSERT INTO acoespersonagens (personagem, jogador, acao, tipoacao, origem, dataehora, vz) 
                         VALUES (:personagem, :jogador, :acao, 'Defesa', 'Vitória', :dataehora, :vz)";
$stmtAcaoDefVencedor = $pdo->prepare($queryAcaoDefVencedor);
$stmtAcaoDefVencedor->bindParam(':personagem', $personagemdef);
$stmtAcaoDefVencedor->bindParam(':jogador', $jogadordef);
$stmtAcaoDefVencedor->bindParam(':acao', $acaoDefVencedor);
$stmtAcaoDefVencedor->bindParam(':dataehora', $dataHora);
$stmtAcaoDefVencedor->bindParam(':vz', $vz);
$stmtAcaoDefVencedor->execute();

// Registrar ação para o ATACANTE (perdedor)
$acaoAtkPerdedor = "Seu personagem $personagematk atacou o personagem $personagemdef ($cladef). $resumosituacao Em $local e perdeu a batalha, fugindo para $nvlocal. 
Perdeu $soldadosatkperdeu soldados, $ouroatkperdeu ouro(s), $prataatkperdeu prata(s), $carneatkperdeu carne(s) e $madeiraatkperdeu madeira(s). 
Conseguiu abater $soldadosdefperdeu soldados inimigos antes de recuar. Reputação -0.04 (agora $nvreputacaoatk).";

$vz2 = 0; // Campo vz com valor 0 para a segunda inserção

$queryAcaoAtkPerdedor = "INSERT INTO acoespersonagens (personagem, jogador, acao, tipoacao, origem, dataehora, vz) 
                         VALUES (:personagem, :jogador, :acao, 'Ataque', 'Derrota', :dataehora, :vz)";
$stmtAcaoAtkPerdedor = $pdo->prepare($queryAcaoAtkPerdedor);
$stmtAcaoAtkPerdedor->bindParam(':personagem', $personagematk);
$stmtAcaoAtkPerdedor->bindParam(':jogador', $jogadoratk);
$stmtAcaoAtkPerdedor->bindParam(':acao', $acaoAtkPerdedor);
$stmtAcaoAtkPerdedor->bindParam(':dataehora', $dataHora);
$stmtAcaoAtkPerdedor->bindParam(':vz', $vz2);
$stmtAcaoAtkPerdedor->execute();
// xxxxxxxxxxxxxxxxxx xxxxxxxxxxxxxxxx
//Redirecionar jogador pra pagina do jogo, apos ele vencer o atk
// . Inserir na Tabela ocorrencias_locais 
    $mensagemlocal = "O personagem $personagematk [$claatk], atacou malsucedidamente o personagem $personagemdef [$cladef]";
    try {
        $sqlInsert = "INSERT INTO ocorrencias_locais 
                      (personagem1, personagem2, cla1, cla2, tipo, situacao, local, tempo_notificacao, data) 
                      VALUES (:p1, :p2, :c1, :c2, 'movimento', :situacao, :local, 120, NOW())"; // 120s = 2 minutos de validade no log

        $stmtInsert = $pdo->prepare($sqlInsert);
        $stmtInsert->execute([
            ':p1' => $personagematk,
            ':p2' => $personagemdef,
            ':c1' => $claatk, // Assumindo que $cla é o clã do personagem
            ':c2' => $cladef, // Assumindo que $cla é o clã do personagem
            ':situacao' => $mensagemlocal,
            ':local' => $local // O NOVO LOCAL do personagem
        ]);

    } catch (Exception $e) {
        // Logar o erro, mas não travar a movimentação
        error_log("Erro ao registrar ocorrência de movimento: " . $e->getMessage());
    }
header("Location: dashboardmed.php");
    exit(); // Importante para parar a execução

}


?>
<!DOCTYPE html>
<html lang="pt-BR">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Combate</title>
    <style>
        table { width: 100%; border-collapse: collapse; }
        th, td { border: 1px solid black; padding: 8px; text-align: center; }
        th { background-color: #ddd; }
        .riscado { text-decoration: line-through; }
    </style>
</head>
<body>
    <h2>Combate entre <?php echo $personagematk; ?> e <?php echo $personagemdef; ?></h2>
    <table>
        <tr>
            <th>Atributo</th>
            <th><?php echo $personagematk; echo "[$claatk]"; ?> (Atacante)</th>
            <th><?php echo $personagemdef; echo "[$claatk]"; ?> (Defensor)</th>
        </tr>
        <?php 
        $atributos = ['soldados', 'ouro', 'prata', 'carne', 'madeira', 'atk', 'def', 'reputacao'];
        $novosValoresAtk = ['soldados' => $nvsoldadosatk, 'ouro' => $nvouroatk, 'prata' => $nvprataatk, 'carne' => $nvcarneatk, 'madeira' => $nvmadeiraatk, 'atk' => $pontosatacanteatk, 'def' => $pontosatacantedef, 'reputacao' => $nvreputacaoatk];
        $novosValoresDef = ['soldados' => $nvsoldadosdef, 'ouro' => $nvourodef, 'prata' => $nvpratadef, 'carne' => $nvcarnedef, 'madeira' => $nvmadeiradef, 'atk' => $pontosdefensoratk, 'def' => $nvpontosdefensordef, 'reputacao' => $nvreputacaodef];
        
        foreach ($atributos as $atributo) {
            list($corAtk, $corDef) = compararValores($atkData[$atributo], $defData[$atributo]);
            echo "<tr>";
            echo "<td>" . ucfirst($atributo) . "</td>";
            echo "<td><span class='riscado' style='color: $corAtk;'>" . $atkData[$atributo] . "</span> (" . $novosValoresAtk[$atributo] . ")</td>";
            echo "<td><span class='riscado' style='color: $corDef;'>" . $defData[$atributo] . "</span> (" . $novosValoresDef[$atributo] . ")</td>";
            echo "</tr>";
        }
        ?>
    </table>
</body>
</html>
