<?php
session_start();
// Ajuste o caminho para voltar à raiz onde está conexao.php
require '../conexao.php'; 

// ATIVAR DEBUG (remover em produção)
ini_set('display_errors', 1);
error_reporting(E_ALL);

// 1. DADOS INICIAIS E SEGURANÇA
if (!isset($_SESSION['user_id']) || empty($_SESSION['personagem'])) {
    header("Location: ../../login.php");
    exit();
}

$nomePersonagem = $_SESSION['personagem_nome'];
$local_alvo = $_SESSION['local']; 

// Busca dados do personagem (atacante)
$stmtP = $pdo->prepare("SELECT id, cla, cargo FROM personagens WHERE personagem = :nome LIMIT 1");
$stmtP->execute([':nome' => $nomePersonagem]);
$user_data = $stmtP->fetch(PDO::FETCH_ASSOC);

if (!$user_data || empty($user_data['cla']) || $user_data['cla'] === 'Nenhum') {
    $_SESSION['msg'] = "Você precisa ter um Clã para dominar cidades.";
    header("Location: ../../dashboardmed.php");
    exit();
}

$cla_atacante = $user_data['cla'];
$cargo_atacante = (int)$user_data['cargo'];
$id_atacante = $user_data['id'];

try {
    // 2. CONSULTAR DOMÍNIO DO LOCAL (Tabela mapasmed)
    $stmtMap = $pdo->prepare("SELECT dominio, governante FROM mapasmed WHERE nome = :local LIMIT 1");
    $stmtMap->execute([':local' => $local_alvo]);
    $dados_mapa = $stmtMap->fetch(PDO::FETCH_ASSOC);

    if (!$dados_mapa) {
        $_SESSION['msg'] = "Local não encontrado no sistema.";
        header("Location: ../../dashboardmed.php");
        exit();
    }

    // Define variáveis (Fallback)
    $cla_dominante_atual = !empty($dados_mapa['dominio']) ? $dados_mapa['dominio'] : 'Nenhum';
    $governante_atual = !empty($dados_mapa['governante']) ? $dados_mapa['governante'] : 'Ninguém';

    // --- IMPLEMENTAÇÃO DO IMPEDIMENTO: NÃO ATACAR PRÓPRIO CLÃ ---
    if ($cla_atacante == $cla_dominante_atual) {
        $_SESSION['msg'] = "Seu Clã já domina o local alvo ($local_alvo). Você não pode atacá-lo.";
        header("Location: ../../dashboardmed.php");
        exit();
    }

    // 3. VERIFICAR PRESENÇA DO CLÃ DOMINANTE (Defesa Ativa)
    if ($cla_dominante_atual !== 'Nenhum') {
        $stmtDefesa = $pdo->prepare("SELECT personagem FROM personagens 
                                     WHERE cla = :cla_dom 
                                     AND local = :local 
                                     AND situacao != 'escondido' 
                                     LIMIT 1");
        $stmtDefesa->execute([':cla_dom' => $cla_dominante_atual, ':local' => $local_alvo]);

        if ($stmtDefesa->rowCount() > 0) {
            $defensor = $stmtDefesa->fetch(PDO::FETCH_ASSOC);
            $_SESSION['msg'] = "O local está protegido! O defensor {$defensor['personagem']} (Clã Dominante) está ativo. Elimine-o primeiro.";
            header("Location: ../../dashboardmed.php");
            exit();
        }
    }

    // 4. VERIFICAR INVASORES RIVAIS
    $stmtInvasao = $pdo->prepare("SELECT cla FROM guerra_dominio 
                                  WHERE local = :local 
                                  AND dominou = 0 
                                  AND (defensor IS NULL OR defensor = '') 
                                  AND iniciou > DATE_SUB(NOW(), INTERVAL 7 MINUTE) 
                                  ORDER BY iniciou DESC 
                                  LIMIT 1");
    $stmtInvasao->execute([':local' => $local_alvo]);
    $dados_invasao = $stmtInvasao->fetch(PDO::FETCH_ASSOC);

    if ($dados_invasao) {
        $nomeclainvasor = $dados_invasao['cla'];
        
        if ($nomeclainvasor !== $cla_atacante) {
            // Verifica presença física do rival
            $stmtRivalPresente = $pdo->prepare("SELECT personagem FROM personagens 
                                                WHERE cla = :cla_rival 
                                                AND local = :local 
                                                AND situacao != 'escondido' 
                                                LIMIT 1");
            $stmtRivalPresente->execute([':cla_rival' => $nomeclainvasor, ':local' => $local_alvo]);
            
            if ($stmtRivalPresente->rowCount() > 0) {
                $rival = $stmtRivalPresente->fetch(PDO::FETCH_ASSOC);
                $_SESSION['msg'] = "Este local está sob cerco do Clã $nomeclainvasor ({$rival['personagem']}). Expulse-os para assumir.";
                header("Location: ../../dashboardmed.php");
                exit();
            }
        }
    }

    // 5. VERIFICAÇÃO DE CARGO
    if ($cargo_atacante <= 1) {
        $_SESSION['msg'] = "Seu cargo é muito baixo para iniciar uma invasão.";
        header("Location: ../../dashboardmed.php");
        exit();
    }

    // 6. INICIAR DOMÍNIO (TRANSAÇÃO)
    $pdo->beginTransaction();

    $sqlInsert = "INSERT INTO guerra_dominio (atacante, cargo, cla, local, cladominante, governante, iniciou, dominou, defensor) 
                  VALUES (:atacante, :cargo, :cla, :local, :cladominante, :governante, NOW(), 0, NULL)";
    $stmtInsert = $pdo->prepare($sqlInsert);
    $stmtInsert->execute([
        ':atacante' => $nomePersonagem,
        ':cargo' => $cargo_atacante,
        ':cla' => $cla_atacante,
        ':local' => $local_alvo,
        ':cladominante' => $cla_dominante_atual,
        ':governante' => $governante_atual
    ]);

    $stmtUpdate = $pdo->prepare("UPDATE personagens SET situacao = 'Invadindo cidade', paralisado = DATE_ADD(NOW(), INTERVAL 5 MINUTE) WHERE id = :id");
    $stmtUpdate->execute([':id' => $id_atacante]);

    $pdo->commit();
    
    // --- 7. REGISTRAR OCORRÊNCIAS (LOGS) ---
    // Usamos as variáveis já definidas no topo: $nomePersonagem, $cla_atacante, $local_alvo
    
    $mensagem_local = "O personagem $nomePersonagem [$cla_atacante] iniciou uma invasão a $local_alvo.";
    
    // LOG LOCAL
    try {
        $sqlInsertLoc = "INSERT INTO ocorrencias_locais 
                         (personagem1, cla1, tipo, situacao, local, tempo_notificacao, data) 
                         VALUES (:p1, :c1, 'dominar', :situacao, :local, 300, NOW())"; 

        $stmtIL = $pdo->prepare($sqlInsertLoc);
        $stmtIL->execute([
            ':p1' => $nomePersonagem,
            ':c1' => $cla_atacante,
            ':situacao' => $mensagem_local,
            ':local' => $local_alvo 
        ]);
    } catch (Exception $e) { error_log($e->getMessage()); }

    // LOG DE CLÃ (INVASÃO)
    $mensagem_cla = "O personagem $nomePersonagem [$cla_atacante] invadiu $local_alvo (Domínio: $cla_dominante_atual).";
    
    try {
        $sqlInsertCla = "INSERT INTO ocorrencias_clas 
                         (personagem1, personagem2, cla1, cla2, tipo, situacao, local, tempo_notificacao, data) 
                         VALUES (:p1, :p2, :c1, :c2, 'invasao', :situacao, :local, 600, NOW())"; 

        $stmtIC = $pdo->prepare($sqlInsertCla);
        $stmtIC->execute([
            ':p1' => $nomePersonagem,
            ':p2' => $governante_atual,
            ':c1' => $cla_atacante,
            ':c2' => $cla_dominante_atual,
            ':situacao' => $mensagem_cla,
            ':local' => $local_alvo
        ]);
    } catch (Exception $e) { error_log($e->getMessage()); }

    $_SESSION['msg'] = "Você iniciou a invasão de $local_alvo! Aguarde 5 minutos.";
    header("Location: ../../dashboardmed.php");
    exit();

} catch (Exception $e) {
    if ($pdo->inTransaction()) {
        $pdo->rollBack();
    }
    $_SESSION['msg'] = "Erro Crítico: " . $e->getMessage();
    header("Location: ../../dashboardmed.php");
    exit();
}
?>