<?php
session_start();
require 'conexao.php';

// Verifica se o usuário está logado
if (!isset($_SESSION['user_id'])) {
    header("Location: login.php");
    exit();
}

$user_name = $_SESSION['user_name'] ?? ''; // Garantir que o nome do usuário esteja disponível

try {
    // Obter IDs de campeonatos nos quais o jogador já está inscrito
    $stmt = $pdo->prepare("SELECT idcamp FROM inscricoes WHERE inscrito = :user_name");
    $stmt->bindParam(':user_name', $user_name);
    $stmt->execute();
    $inscritos_ids = $stmt->fetchAll(PDO::FETCH_COLUMN);

    // Consulta para obter campeonatos com status 0 e que o jogador não esteja inscrito
    $query = "
        SELECT c.id, c.nomedocamp, c.informacoes, c.`1st`, c.`2st`, c.`3st`, c.`4st`, c.`5st`, 
               c.minimop, c.maximop, c.duracaoturno, c.criador, c.valorficha, c.valordinheiro,
               (SELECT COUNT(*) FROM inscricoes i WHERE i.idcamp = c.id) AS inscritos
        FROM campeonatos c
        WHERE c.status = 0
    ";

    if (!empty($inscritos_ids)) {
        // Filtrar campeonatos que o jogador já se inscreveu
        $placeholders = implode(',', array_fill(0, count($inscritos_ids), '?'));
        $query .= " AND c.id NOT IN ($placeholders)";
    }

    $stmt = $pdo->prepare($query);
    if (!empty($inscritos_ids)) {
        $stmt->execute($inscritos_ids);
    } else {
        $stmt->execute();
    }

    $campeonatos = $stmt->fetchAll(PDO::FETCH_ASSOC);
} catch (PDOException $e) {
    die("Erro ao consultar campeonatos: " . $e->getMessage());
}
?>

<!DOCTYPE html>
<html lang="pt-br">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Campeonatos Abertos</title>
    <link rel="stylesheet" href="style.css">
</head>
<body>
    <h1>Campeonatos Abertos</h1>
    <a href="dashboard.php"><button class="btnmenu">Menu Principal</button></a><br><br>

    <?php if (count($campeonatos) > 0): ?>
        <table border="1">
            <thead>
                <tr>
                    <th>ID</th>
                    <th>Nome do Campeonato</th>
                    <th>Informações</th>
                    <th>1º Lugar</th>
                    <th>2º Lugar</th>
                    <th>3º Lugar</th>
                    <th>4º Lugar</th>
                    <th>5º Lugar</th>
                    <th>Mínimo de Jogadores</th>
                    <th>Máximo de Jogadores</th>
                    <th>Inscritos</th>
                    <th>Duração por Turno (Minutos)</th>
                    <th>Criador</th>
                    <th>Entrada com Ficha</th> <!-- Nova coluna -->
                    <th>Entrada com Dinheiro</th> <!-- Nova coluna -->
                    <th>Ações</th>
                </tr>
            </thead>
            <tbody>
                <?php foreach ($campeonatos as $campeonato): ?>
                    <tr>
                        <td><?= htmlspecialchars($campeonato['id']) ?></td>
                        <td><?= htmlspecialchars($campeonato['nomedocamp']) ?></td>
                        <td><?= htmlspecialchars($campeonato['informacoes']) ?></td>
                        <td><?= htmlspecialchars($campeonato['1st']) ?></td>
                        <td><?= htmlspecialchars($campeonato['2st']) ?></td>
                        <td><?= htmlspecialchars($campeonato['3st']) ?></td>
                        <td><?= htmlspecialchars($campeonato['4st']) ?></td>
                        <td><?= htmlspecialchars($campeonato['5st']) ?></td>
                        <td><?= htmlspecialchars($campeonato['minimop']) ?></td>
                        <td>
                            <?= $campeonato['maximop'] == 0 ? '-' : htmlspecialchars($campeonato['maximop']) ?>
                        </td>
                        <td>
                            <?= $campeonato['inscritos'] ?> 
                            <?php if ($campeonato['maximop'] != 0): ?>
                                / <?= htmlspecialchars($campeonato['maximop']) ?>
                            <?php endif; ?>
                        </td>
                        <td><?= htmlspecialchars($campeonato['duracaoturno']) ?></td>
                        <td><?= htmlspecialchars($campeonato['criador']) ?></td>
                        <td>R$<?= htmlspecialchars($campeonato['valorficha']) ?></td> <!-- Exibe valor ficha -->
                        <td>R$<?= htmlspecialchars($campeonato['valordinheiro']) ?></td> <!-- Exibe valor dinheiro -->
                        <td>
                            <form method="GET" action="inscrever_jogador.php">
                                <!-- Envia o ID do campeonato via GET -->
                                <input type="hidden" name="idcamp" value="<?= htmlspecialchars($campeonato['id']) ?>">
                                <button type="submit">Entrar</button>
                            </form>
                        </td>
                    </tr>
                <?php endforeach; ?>
            </tbody>
        </table>
    <?php else: ?>
        <p>Não há campeonatos abertos no momento.</p>
    <?php endif; ?>
</body>
</html>
