<?php
session_start();
require '../conexao.php';

// --- SEGURANÇA: OCULTAR ERROS EM PRODUÇÃO ---
ini_set('display_errors', 0);
error_reporting(E_ALL);

// 1. Verificação de Login
if (!isset($_SESSION['user_id'])) {
    header("Location: ../login.php");
    exit();
}

// --- SEGURANÇA: GARANTIR TOKEN CSRF ---
// Isso é essencial para que o formulário seja aceito na próxima página
if (!isset($_SESSION['csrf_token'])) {
    $_SESSION['csrf_token'] = bin2hex(random_bytes(32));
}

// Validação do ID
$id_ordem_venda = filter_input(INPUT_GET, 'id', FILTER_VALIDATE_INT);

if (!$id_ordem_venda) {
    $_SESSION['mensagem'] = "Erro: ID inválido.";
    header("Location: ordens_venda.php");
    exit();
}

// Busca dados da ordem com segurança
$sql = "SELECT * FROM ordem_vendas WHERE id = :id";
$stmt = $pdo->prepare($sql);
$stmt->execute([':id' => $id_ordem_venda]);
$ordem_venda = $stmt->fetch(PDO::FETCH_ASSOC);

if ($ordem_venda) {
    $_SESSION['idvenda'] = $id_ordem_venda;
    $_SESSION['personagemvend'] = $ordem_venda['personagem'];
    $_SESSION['valor'] = $ordem_venda['valor'];
} else {
    $_SESSION['mensagem'] = "Esta oferta não existe mais.";
    header("Location: ordens_venda.php");
    exit();
}
?>

<!DOCTYPE html>
<html lang="pt-br">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Confirmar Compra - Mavilla</title>
    <link href="https://fonts.googleapis.com/css2?family=Roboto:wght@400;700&display=swap" rel="stylesheet">
    <link rel="stylesheet" href="../css/dashboard.css">
    
    <style>
        /* === ESTILO NEON PADRÃO === */
        html, body { background: none !important; background-color: transparent !important; }
        body {
            background: url('../rpg-login-background.jpg') no-repeat center center fixed !important;
            background-size: cover !important;
            color: white;
            min-height: 100vh;
            display: flex;
            align-items: center;
            justify-content: center;
            font-family: 'Roboto', sans-serif;
        }

        .container { width: 100%; max-width: 500px; padding: 20px; }

        .neon-card {
            background-color: rgba(0, 5, 30, 0.9); 
            border: 2px solid var(--primary);
            box-shadow: 0 0 20px rgba(0, 0, 255, 0.3);
            border-radius: 15px;
            padding: 30px;
            text-align: center;
            backdrop-filter: blur(5px);
        }

        h1 {
            color: var(--neon-bright);
            text-transform: uppercase;
            text-shadow: 0 0 10px var(--primary);
            font-family: 'Times New Roman', serif;
            margin-bottom: 20px;
            border-bottom: 1px solid var(--primary);
            padding-bottom: 10px;
            font-size: 1.8rem;
        }

        .info-box {
            background: rgba(255,255,255,0.05);
            padding: 20px;
            border-radius: 8px;
            margin: 20px 0;
            text-align: left;
            border: 1px dashed #555;
        }
        
        .highlight { color: #00f3ff; font-weight: bold; font-size: 1.2rem; }
        .price { color: #28a745; font-weight: bold; font-size: 1.3rem; text-shadow: 0 0 5px #28a745; }

        /* Input PIN Neon */
        .pin-input {
            width: 100%;
            padding: 12px;
            background-color: #000;
            border: 2px solid var(--primary);
            color: white;
            text-align: center;
            font-size: 1.2rem;
            border-radius: 6px;
            outline: none;
            letter-spacing: 5px;
            margin-bottom: 15px;
        }
        .pin-input:focus {
            box-shadow: 0 0 15px var(--neon-bright);
            border-color: #fff;
        }

        .btn-group { display: flex; flex-direction: column; gap: 15px; margin-top: 20px; }
        
        button {
            width: 100%; padding: 15px; border-radius: 8px; font-weight: bold;
            text-transform: uppercase; cursor: pointer; transition: 0.3s; font-size: 1rem;
        }

        .btn-confirm {
            background: #000; color: #28a745; border: 2px solid #28a745;
            box-shadow: 0 0 10px rgba(40, 167, 69, 0.3);
        }
        .btn-confirm:hover { background: #28a745; color: #fff; box-shadow: 0 0 20px #28a745; }

        .btn-cancel {
            background: #000; color: #ff2222; border: 2px solid #ff2222;
        }
        .btn-cancel:hover { background: #ff2222; color: #fff; box-shadow: 0 0 15px #ff2222; }

    </style>
</head>
<body>

    <div class="container">
        <div class="neon-card">
            <h1>Confirmar Compra</h1>
            
            <div class="info-box">
                <p style="color:#ccc; margin-bottom:5px;">Você está comprando:</p>
                <p><span class="highlight"><?= htmlspecialchars($ordem_venda['personagem']) ?></span></p>
                
                <hr style="border-color:#333; opacity:0.3; margin:10px 0;">
                
                <p style="color:#ccc; margin-bottom:5px;">Valor a Pagar:</p>
                <p><span class="price">R$ <?= number_format($ordem_venda['valor'], 2, ',', '.') ?></span></p>
                
                <p style="margin-top:10px; font-size:0.8rem; color:#888;">
                    Vendedor: <?= htmlspecialchars($ordem_venda['jogador']) ?>
                </p>
            </div>

            <form action="confirmarcomprapers.php" method="POST" class="btn-group">
                <input type="hidden" name="id" value="<?= $id_ordem_venda ?>">
                
                <input type="hidden" name="csrf_token" value="<?= $_SESSION['csrf_token'] ?>">
                
                <div style="text-align:left;">
                    <label style="color:#ccc; font-size:0.9rem; font-weight:bold; display:block; margin-bottom:5px;">Digite seu PIN para confirmar:</label>
                    <input type="password" name="pin" class="pin-input" maxlength="4" placeholder="****" required autocomplete="off">
                </div>

                <button type="submit" name="confirmar" class="btn-confirm">
                    Confirmar Pagamento
                </button>
                
                <a href="ordens_venda.php" style="text-decoration:none; width:100%;">
                    <button type="button" class="btn-cancel">Cancelar</button>
                </a>
            </form>
        </div>
    </div>

</body>
</html>