<?php
session_start();
require 'conexao.php';

// Verifique se o usuário está logado
if (!isset($_SESSION['user_id'])) {
    // Redirecione-o para a página de login
    header("Location: login.php");
}
?>
<!DOCTYPE html>
<html>
<head>
    <title>Apagar Ordem de Compra</title>
    <link rel="stylesheet" type="text/css" href="style.css">
</head>
<body>
<img class="bn" src="bn.png" alt=""><br>
<?php
// Verifique se o ID da ordem de venda foi fornecido na URL
if (isset($_GET['id'])) {
    $id_ordem_venda = $_GET['id'];

    // Consulte a ordem de venda pelo ID
    $sql = "SELECT * FROM ordem_vendas WHERE id = :id";
    $stmt = $pdo->prepare($sql);
    $stmt->bindParam(':id', $id_ordem_venda, PDO::PARAM_INT);

    if ($stmt->execute()) {
        $ordem_venda = $stmt->fetch(PDO::FETCH_ASSOC);
        if ($ordem_venda) {
            $personagem = $ordem_venda['personagem'];
            $valor = $ordem_venda['valor'];
            $data_publicacao = $ordem_venda['dataehora'];
        } else {
            echo "<p class='txtpadrao'>Ordem de venda não encontrada.</p>";
        }
    } else {
        echo "Erro na consulta: " . $stmt->errorInfo()[2];
    }
}

// Verifique se o usuário confirmou a exclusão
if (isset($_POST['confirmar'])) {
    // Apague a ordem de venda da tabela
    $sqlDelete = "DELETE FROM ordem_vendas WHERE id = :id";
    $stmtDelete = $pdo->prepare($sqlDelete);
    $stmtDelete->bindParam(':id', $id_ordem_venda, PDO::PARAM_INT);

    if ($stmtDelete->execute()) {
        // Altere a coluna 'situacao' na tabela 'personagens' para 'livre'
        $sqlUpdateSituacao = "UPDATE personagens SET situacao = 'livre' WHERE personagem = :personagem";
        $stmtUpdateSituacao = $pdo->prepare($sqlUpdateSituacao);
        $stmtUpdateSituacao->bindParam(':personagem', $personagem, PDO::PARAM_STR);

        if ($stmtUpdateSituacao->execute()) {
        echo "<p class='txtpadrao'>Ordem de venda, do personagem $personagem, apagada com sucesso.</p><br><br>";
        
        echo '<form method="GET" action="ordens_venda.php">';
        echo '<button type="submit">Cancelar</button>';
    echo '</form>';
        exit;
        } else {
            echo "Erro ao atualizar a situacao: " . $stmtUpdateSituacao->errorInfo()[2];
        }
    } else {
        echo "Erro ao apagar a ordem de venda: " . $stmtDelete->errorInfo()[2];
    }
}
?>


    <h1>Apagar Ordem de Compra</h1>
    <p>Tem certeza de que deseja apagar a seguinte ordem de compra?</p>
    <p><strong>Personagem:</strong> <?php echo $personagem; ?></p>
    <p><strong>Valor:</strong> R$ <?php echo $valor; ?></p>
    <form method="POST">
        <input type="hidden" name="id" value="<?php echo $id_ordem_venda; ?>">
        <button type="submit" name="confirmar">Confirmar Apagar</button>
    </form>
    <form method="GET" action="ordens_venda.php">
        <button type="submit">Cancelar</button>
    </form>
</body>
</html>
